/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.actions;

import java.awt.event.ActionEvent;
import javax.swing.event.ChangeEvent;
import org.openmicroscopy.shoola.agents.hiviewer.IconManager;
import org.openmicroscopy.shoola.agents.hiviewer.actions.HiViewerAction;
import org.openmicroscopy.shoola.agents.hiviewer.cmd.ViewHierarchyCmd;
import org.openmicroscopy.shoola.agents.hiviewer.view.HiViewer;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class ViewPDIAction
extends HiViewerAction {
    private static final String NAME = "View as Project/Dataset/Image";
    private static final String DESCRIPTION = "View the images on screen in a Project-Dataset-Images hierarchy.";

    public ViewPDIAction(HiViewer model) {
        super(model);
        this.putValue("Name", NAME);
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        IconManager im = IconManager.getInstance();
        this.putValue("SmallIcon", im.getIcon(7));
    }

    public void actionPerformed(ActionEvent e) {
        ViewHierarchyCmd cmd = new ViewHierarchyCmd(this.model, 1);
        cmd.execute();
    }

    public void stateChanged(ChangeEvent e) {
        super.stateChanged(e);
        if (this.model.getState() == 3) {
            switch (this.model.getHierarchyType()) {
                case 103: 
                case 104: 
                case 106: 
                case 107: {
                    this.setEnabled(true);
                }
            }
        }
    }
}

