/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.actions;

import java.awt.event.ActionEvent;
import javax.swing.event.ChangeEvent;
import org.openmicroscopy.shoola.agents.hiviewer.IconManager;
import org.openmicroscopy.shoola.agents.hiviewer.actions.HiViewerAction;
import org.openmicroscopy.shoola.agents.hiviewer.cmd.ViewHierarchyCmd;
import org.openmicroscopy.shoola.agents.hiviewer.view.HiViewer;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class ViewCGCIAction
extends HiViewerAction {
    private static final String NAME = "View as CategoryGroup/Category/Image";
    private static final String DESCRIPTION = "View the images on screen in a CategoryGroup-Category-Images hierarchy.";

    public ViewCGCIAction(HiViewer model) {
        super(model);
        this.putValue("Name", NAME);
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        IconManager im = IconManager.getInstance();
        this.putValue("SmallIcon", im.getIcon(7));
    }

    public void actionPerformed(ActionEvent e) {
        ViewHierarchyCmd cmd = new ViewHierarchyCmd(this.model, 0);
        cmd.execute();
    }

    public void stateChanged(ChangeEvent e) {
        super.stateChanged(e);
        if (this.model.getState() == 3) {
            switch (this.model.getHierarchyType()) {
                case 101: 
                case 102: 
                case 105: 
                case 107: {
                    this.setEnabled(true);
                }
            }
        }
    }
}

