/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.actions;

import java.awt.event.ActionEvent;
import org.openmicroscopy.shoola.agents.hiviewer.IconManager;
import org.openmicroscopy.shoola.agents.hiviewer.actions.HiViewerAction;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.hiviewer.cmd.ViewCmd;
import org.openmicroscopy.shoola.agents.hiviewer.view.HiViewer;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.ImageData;

public class ViewAction
extends HiViewerAction {
    public static final String VIEW = "View";
    public static final String DESCRIPTION_VIEW = "View the selected image.";
    public static final String BROWSE = "Browse";
    public static final String DESCRIPTION_BROWSE = "Browse the selected project, dataset, categoryGroup or category";

    protected void onDisplayChange(ImageDisplay selectedDisplay) {
        if (selectedDisplay == null) {
            this.setEnabled(false);
            return;
        }
        if (selectedDisplay.getParentDisplay() == null) {
            this.setEnabled(false);
        } else {
            Object ho = selectedDisplay.getHierarchyObject();
            if (ho instanceof ImageData) {
                this.putValue("Name", VIEW);
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_VIEW));
            } else {
                this.putValue("Name", BROWSE);
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_BROWSE));
            }
            this.setEnabled(true);
        }
    }

    public ViewAction(HiViewer model) {
        super(model);
        this.putValue("Name", VIEW);
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_VIEW));
        IconManager im = IconManager.getInstance();
        this.putValue("SmallIcon", im.getIcon(7));
    }

    public void actionPerformed(ActionEvent e) {
        ViewCmd cmd = new ViewCmd(this.model);
        cmd.execute();
    }
}

