/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.actions;

import java.awt.event.ActionEvent;
import org.openmicroscopy.shoola.agents.hiviewer.IconManager;
import org.openmicroscopy.shoola.agents.hiviewer.actions.HiViewerAction;
import org.openmicroscopy.shoola.agents.hiviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.hiviewer.cmd.SaveThumbnailsCmd;
import org.openmicroscopy.shoola.agents.hiviewer.view.HiViewer;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.CategoryData;
import pojos.DatasetData;
import pojos.ImageData;

public class SaveThumbnailsAction
extends HiViewerAction {
    private static final String NAME = "Export as";
    private static final String DESCRIPTION = "Save the thumbnails as a single image. ";

    protected void onStateChange() {
        if (this.model.getState() == 5) {
            Browser browser = this.model.getBrowser();
            if (browser != null) {
                this.onDisplayChange(browser.getLastSelectedDisplay());
            } else {
                this.setEnabled(false);
            }
        } else {
            this.setEnabled(false);
        }
    }

    protected void onDisplayChange(ImageDisplay selectedDisplay) {
        if (this.model.getState() != 5) {
            return;
        }
        if (this.model.getBrowser().getSelectedLayout() == 2) {
            this.setEnabled(true);
            return;
        }
        if (selectedDisplay == null) {
            this.setEnabled(false);
            return;
        }
        if (selectedDisplay.getParentDisplay() == null) {
            this.setEnabled(false);
        } else {
            Object ho = selectedDisplay.getHierarchyObject();
            if (this.model.getBrowser().getSelectedLayout() == 2 && !(ho instanceof ImageData)) {
                this.setEnabled(true);
                return;
            }
            this.setEnabled(ho instanceof CategoryData || ho instanceof DatasetData);
        }
    }

    public SaveThumbnailsAction(HiViewer model) {
        super(model);
        this.putValue("Name", NAME);
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        IconManager im = IconManager.getInstance();
        this.putValue("SmallIcon", im.getIcon(13));
    }

    public void actionPerformed(ActionEvent e) {
        SaveThumbnailsCmd cmd = new SaveThumbnailsCmd(this.model);
        cmd.execute();
    }
}

