/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.actions;

import java.awt.event.ActionEvent;
import java.util.Set;
import org.openmicroscopy.shoola.agents.hiviewer.IconManager;
import org.openmicroscopy.shoola.agents.hiviewer.actions.HiViewerAction;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.hiviewer.cmd.RemoveCmd;
import org.openmicroscopy.shoola.agents.hiviewer.view.HiViewer;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.CategoryData;
import pojos.CategoryGroupData;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ImageData;
import pojos.ProjectData;

public class RemoveAction
extends HiViewerAction {
    private static final String NAME = "Remove";
    private static final String NAME_PROJECT = "Remove from current project";
    private static final String NAME_CATEGORYGROUP = "Remove from current category group";
    private static final String NAME_DATASET = "Remove from current dataset";
    private static final String NAME_CATEGORY = "Remove from current category";
    private static final String DESCRIPTION = "Remove the selected element from the current container.";

    protected void onDisplayChange(ImageDisplay selectedDisplay) {
        if (selectedDisplay == null || this.model.getBrowser() == null) {
            this.setEnabled(false);
            return;
        }
        if (selectedDisplay.getParentDisplay() == null) {
            this.setEnabled(false);
        } else {
            Set nodes = this.model.getBrowser().getSelectedDisplays();
            if (nodes.size() > 1) {
                Object ho = selectedDisplay.getHierarchyObject();
                ImageDisplay parent = selectedDisplay.getParentDisplay();
                Object po = parent.getHierarchyObject();
                if (ho instanceof ImageData) {
                    if (po instanceof DatasetData) {
                        this.setEnabled(this.model.isObjectWritable((DataObject)ho));
                        this.putValue("Name", NAME_DATASET);
                    } else if (po instanceof CategoryData) {
                        this.setEnabled(this.model.isObjectWritable((DataObject)ho));
                        this.putValue("Name", NAME_CATEGORY);
                    } else {
                        this.setEnabled(false);
                        this.putValue("Name", NAME);
                    }
                } else {
                    this.setEnabled(false);
                }
            } else {
                Object ho = selectedDisplay.getHierarchyObject();
                ImageDisplay parent = selectedDisplay.getParentDisplay();
                Object po = parent.getHierarchyObject();
                if (ho instanceof ProjectData || ho instanceof CategoryGroupData) {
                    this.putValue("Name", NAME);
                    this.setEnabled(this.model.isObjectWritable((DataObject)ho));
                } else if (ho instanceof DatasetData) {
                    this.putValue("Name", NAME_PROJECT);
                    if (po instanceof ProjectData) {
                        this.setEnabled(this.model.isObjectWritable((DataObject)ho));
                    } else {
                        this.setEnabled(false);
                    }
                } else if (ho instanceof CategoryData) {
                    this.putValue("Name", NAME_CATEGORYGROUP);
                    if (po instanceof CategoryGroupData) {
                        this.setEnabled(this.model.isObjectWritable((DataObject)ho));
                    } else {
                        this.setEnabled(false);
                    }
                } else if (ho instanceof ImageData) {
                    if (po instanceof DatasetData) {
                        this.setEnabled(this.model.isObjectWritable((DataObject)ho));
                        this.putValue("Name", NAME_DATASET);
                    } else if (po instanceof CategoryData) {
                        this.setEnabled(this.model.isObjectWritable((DataObject)ho));
                        this.putValue("Name", NAME_CATEGORY);
                    } else {
                        this.setEnabled(false);
                        this.putValue("Name", NAME);
                    }
                } else {
                    this.setEnabled(false);
                }
            }
        }
    }

    public RemoveAction(HiViewer model) {
        super(model);
        this.putValue("Name", NAME);
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        IconManager icons = IconManager.getInstance();
        this.putValue("SmallIcon", icons.getIcon(IconManager.DELETE));
    }

    public void actionPerformed(ActionEvent e) {
        RemoveCmd cmd = new RemoveCmd(this.model);
        cmd.execute();
    }
}

