/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.actions;

import java.awt.event.ActionEvent;
import java.util.Set;
import org.openmicroscopy.shoola.agents.hiviewer.IconManager;
import org.openmicroscopy.shoola.agents.hiviewer.actions.HiViewerAction;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.hiviewer.cmd.PropertiesCmd;
import org.openmicroscopy.shoola.agents.hiviewer.view.HiViewer;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class PropertiesAction
extends HiViewerAction {
    public static final String NAME = "Properties";
    public static final String DESCRIPTION = "Display the object properties.";

    protected void onDisplayChange(ImageDisplay selectedDisplay) {
        if (selectedDisplay == null || this.model.getBrowser() == null) {
            this.setEnabled(false);
            return;
        }
        Set nodes = this.model.getBrowser().getSelectedDisplays();
        if (nodes.size() > 1) {
            this.setEnabled(false);
        } else {
            this.setEnabled(selectedDisplay.getParentDisplay() != null);
        }
    }

    public PropertiesAction(HiViewer model) {
        super(model);
        this.putValue("Name", NAME);
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        IconManager im = IconManager.getInstance();
        this.putValue("SmallIcon", im.getIcon(6));
    }

    public void actionPerformed(ActionEvent e) {
        PropertiesCmd cmd = new PropertiesCmd(this.model);
        cmd.execute();
    }
}

