/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openmicroscopy.shoola.agents.hiviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.hiviewer.view.HiViewer;

public abstract class HiViewerAction
extends AbstractAction
implements ChangeListener,
PropertyChangeListener {
    protected String name;
    protected HiViewer model;

    protected void onDisplayChange(ImageDisplay selectedDisplay) {
    }

    protected void onStateChange() {
    }

    public HiViewerAction(HiViewer model) {
        this.setEnabled(false);
        if (model == null) {
            throw new IllegalArgumentException("no hiViewer");
        }
        this.model = model;
        model.addChangeListener(this);
    }

    public String getName() {
        return this.name;
    }

    public void actionPerformed(ActionEvent e) {
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("selectedDisplay".equals(name)) {
            Browser browser = this.model.getBrowser();
            if (browser != null) {
                this.onDisplayChange(browser.getLastSelectedDisplay());
            } else {
                this.onDisplayChange(null);
            }
        }
    }

    public void stateChanged(ChangeEvent e) {
        int state = this.model.getState();
        if (state == 3 || state == 5 && this.model.getBrowser().getImages().size() == 0) {
            this.model.getBrowser().addPropertyChangeListener("selectedDisplay", this);
            this.model.getBrowser().addPropertyChangeListener("layout", this);
            this.onStateChange();
        } else if (state == 5) {
            this.onStateChange();
        }
    }
}

