/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.actions;

import java.awt.event.ActionEvent;
import org.openmicroscopy.shoola.agents.hiviewer.IconManager;
import org.openmicroscopy.shoola.agents.hiviewer.actions.HiViewerAction;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.hiviewer.cmd.FindCmd;
import org.openmicroscopy.shoola.agents.hiviewer.view.HiViewer;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.ImageData;

public class FindAction
extends HiViewerAction {
    private static final String NAME = "Find";
    private static final String DESCRIPTION = "Find the phrase in the currently selected container.";

    protected void onDisplayChange(ImageDisplay selectedDisplay) {
        if (selectedDisplay == null) {
            this.setEnabled(false);
            return;
        }
        if (selectedDisplay.getParentDisplay() == null) {
            this.setEnabled(false);
        } else {
            Object ho = selectedDisplay.getHierarchyObject();
            this.setEnabled(!(ho instanceof ImageData));
        }
    }

    public FindAction(HiViewer model) {
        super(model);
        this.putValue("Name", NAME);
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        IconManager im = IconManager.getInstance();
        this.putValue("SmallIcon", im.getIcon(40));
    }

    public void actionPerformed(ActionEvent e) {
        FindCmd cmd = new FindCmd(this.model);
        cmd.execute();
    }
}

