/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.actions;

import java.awt.event.ActionEvent;
import org.openmicroscopy.shoola.agents.hiviewer.IconManager;
import org.openmicroscopy.shoola.agents.hiviewer.actions.HiViewerAction;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.hiviewer.cmd.ClassifyCmd;
import org.openmicroscopy.shoola.agents.hiviewer.view.HiViewer;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.ImageData;

public class DeclassifyAction
extends HiViewerAction {
    public static final String NAME = "Decategorise";
    public static final String DESCRIPTION = "Decategorise the selected images.";

    protected void onDisplayChange(ImageDisplay selectedDisplay) {
        if (selectedDisplay == null) {
            this.setEnabled(false);
            return;
        }
        if (selectedDisplay.getParentDisplay() == null) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(selectedDisplay.getHierarchyObject() instanceof ImageData);
    }

    public DeclassifyAction(HiViewer model) {
        super(model);
        this.putValue("Name", NAME);
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        IconManager icons = IconManager.getInstance();
        this.putValue("SmallIcon", icons.getIcon(IconManager.DECATEGORISE));
    }

    public void actionPerformed(ActionEvent e) {
        ClassifyCmd cmd = new ClassifyCmd(this.model, 1);
        cmd.execute();
    }
}

