/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.actions;

import java.awt.event.ActionEvent;
import org.openmicroscopy.shoola.agents.hiviewer.IconManager;
import org.openmicroscopy.shoola.agents.hiviewer.actions.HiViewerAction;
import org.openmicroscopy.shoola.agents.hiviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.hiviewer.view.HiViewer;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.CategoryData;
import pojos.DatasetData;

public class ClassifyChildrenAction
extends HiViewerAction {
    private static final String NAME = "Categorise Images";
    private static final String DESCRIPTION = "Categorise the images contained in the selected folder.";

    protected void onDisplayChange(ImageDisplay selectedDisplay) {
        if (selectedDisplay == null) {
            this.setEnabled(false);
            return;
        }
        if (selectedDisplay.getParentDisplay() == null) {
            this.setEnabled(false);
        } else {
            Object ho = selectedDisplay.getHierarchyObject();
            this.setEnabled(ho instanceof CategoryData || ho instanceof DatasetData);
        }
    }

    public ClassifyChildrenAction(HiViewer model) {
        super(model);
        this.putValue("Name", NAME);
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        IconManager im = IconManager.getInstance();
        this.putValue("SmallIcon", im.getIcon(15));
    }

    public void actionPerformed(ActionEvent e) {
        Browser browser = this.model.getBrowser();
        if (browser == null) {
            return;
        }
        this.model.classifyChildren(browser.getLastSelectedDisplay());
    }
}

