/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.actions;

import java.awt.event.ActionEvent;
import org.openmicroscopy.shoola.agents.hiviewer.IconManager;
import org.openmicroscopy.shoola.agents.hiviewer.actions.HiViewerAction;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.hiviewer.cmd.AnnotateCmd;
import org.openmicroscopy.shoola.agents.hiviewer.view.HiViewer;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.DatasetData;
import pojos.ImageData;

public class AnnotateAction
extends HiViewerAction {
    public static final String NAME = "Annotate";
    public static final String DESCRIPTION = "Annotate the selected image or dataset.";

    protected void onDisplayChange(ImageDisplay selectedDisplay) {
        if (selectedDisplay == null) {
            this.setEnabled(false);
            return;
        }
        if (selectedDisplay.getParentDisplay() == null) {
            this.setEnabled(false);
        } else {
            Object ho = selectedDisplay.getHierarchyObject();
            this.setEnabled(ho instanceof ImageData || ho instanceof DatasetData);
        }
    }

    public AnnotateAction(HiViewer model) {
        super(model);
        this.putValue("Name", NAME);
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        IconManager im = IconManager.getInstance();
        this.putValue("SmallIcon", im.getIcon(8));
    }

    public void actionPerformed(ActionEvent e) {
        AnnotateCmd cmd = new AnnotateCmd(this.model, null);
        cmd.execute();
    }
}

