/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer;

import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.openmicroscopy.shoola.agents.hiviewer.ThumbnailProvider;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageNode;
import org.openmicroscopy.shoola.agents.hiviewer.browser.Thumbnail;
import pojos.ImageData;

public class ThumbnailsManager {
    private int totalIDs;
    private Set<Long> processedIDs;
    private Map<Long, Set> thumbProviders;

    public ThumbnailsManager(Set imageNodes) {
        if (imageNodes == null) {
            throw new NullPointerException("No image nodes.");
        }
        this.totalIDs = 0;
        this.processedIDs = new HashSet<Long>();
        this.thumbProviders = new HashMap<Long, Set>();
        for (ImageNode node : imageNodes) {
            ImageData is = (ImageData)node.getHierarchyObject();
            Long id = new Long(is.getId());
            HashSet<Thumbnail> providers = this.thumbProviders.get(id);
            if (providers == null) {
                ++this.totalIDs;
                providers = new HashSet<Thumbnail>();
                this.thumbProviders.put(id, providers);
            }
            providers.add(node.getThumbnail());
        }
    }

    public void setThumbnail(long imageID, BufferedImage thumb) {
        if (thumb == null) {
            throw new NullPointerException("No thumbnail.");
        }
        Long id = new Long(imageID);
        Set providers = this.thumbProviders.get(id);
        if (providers != null) {
            Iterator p = providers.iterator();
            while (p.hasNext()) {
                ((ThumbnailProvider)p.next()).setFullScaleThumb(thumb);
            }
            this.processedIDs.add(id);
        }
    }

    public boolean isDone() {
        return this.processedIDs.size() == this.totalIDs;
    }
}

