/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageNode;
import org.openmicroscopy.shoola.agents.hiviewer.browser.Thumbnail;
import pojos.ImageData;
import pojos.PixelsData;

public class ThumbnailProvider
implements Thumbnail {
    static final int THUMB_MAX_WIDTH = 96;
    static final int THUMB_MAX_HEIGHT = 96;
    private static final int BORDER = 1;
    private static final Color BORDER_COLOR = Color.WHITE;
    private ImageData imgInfo;
    private ImageNode display;
    private int width;
    private int height;
    private int originalWidth;
    private int originalHeight;
    private BufferedImage fullScaleThumb;
    private BufferedImage displayThumb;
    private double scalingFactor;
    private Icon iconThumb;

    private void computeDims() {
        PixelsData pxd = this.imgInfo.getDefaultPixels();
        int w = 96;
        int h = 96;
        double pixSizeX = pxd.getSizeX();
        double pixSizeY = pxd.getSizeY();
        if (pixSizeX < 96.0) {
            w = (int)pixSizeX;
        }
        if (pixSizeY < 96.0) {
            h = (int)pixSizeY;
        }
        int sizeX = (int)((double)w * 0.5);
        int sizeY = (int)((double)h * 0.5);
        this.originalWidth = w;
        this.originalHeight = h;
        double ratio = 1.0;
        if (pxd != null) {
            ratio = (double)pxd.getSizeX() / (double)pxd.getSizeY();
        }
        if (ratio < 1.0) {
            sizeX = (int)((double)sizeX * ratio);
            this.originalWidth = (int)((double)this.originalWidth * ratio);
        } else if (ratio > 1.0 && ratio != 0.0) {
            sizeY = (int)((double)sizeY * (1.0 / ratio));
            this.originalHeight = (int)((double)this.originalHeight * (1.0 / ratio));
        }
        this.width = sizeX;
        this.height = sizeY;
    }

    private BufferedImage magnifyImage(double f, BufferedImage img) {
        if (img == null) {
            return null;
        }
        int width = img.getWidth();
        int height = img.getHeight();
        if (width <= 0 || height <= 0) {
            return null;
        }
        AffineTransform at = new AffineTransform();
        at.scale(f, f);
        AffineTransformOp biop = new AffineTransformOp(at, 2);
        BufferedImage rescaleBuff = new BufferedImage((int)((double)width * f), (int)((double)height * f), img.getType());
        biop.filter(img, rescaleBuff);
        return rescaleBuff;
    }

    public ThumbnailProvider(ImageData is) {
        if (is == null) {
            throw new IllegalArgumentException("No image.");
        }
        this.imgInfo = is;
        this.scalingFactor = 0.5;
        this.computeDims();
    }

    public void setImageNode(ImageNode node) {
        if (node == null) {
            throw new IllegalArgumentException("No Image node");
        }
        this.display = node;
    }

    public void setFullScaleThumb(BufferedImage t) {
        if (t == null) {
            throw new NullPointerException("No thumbnail.");
        }
        this.fullScaleThumb = t;
        this.scale(this.scalingFactor);
    }

    public BufferedImage getDisplayedImage() {
        return this.displayThumb;
    }

    public void scale(double f) {
        if (f < 0.25 || f > 1.0) {
            return;
        }
        this.scalingFactor = f;
        int w = (int)((double)this.originalWidth * f);
        int h = (int)((double)this.originalHeight * f);
        if (this.fullScaleThumb != null) {
            this.displayThumb = this.magnifyImage(f, this.fullScaleThumb);
            w = this.displayThumb.getWidth();
            h = this.displayThumb.getHeight();
        }
        if (this.display != null) {
            this.display.setCanvasSize(w, h);
            this.display.pack();
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public double getScalingFactor() {
        return this.scalingFactor;
    }

    public BufferedImage getFullScaleThumb() {
        return this.fullScaleThumb;
    }

    public BufferedImage getZoomedFullScaleThumb() {
        return this.magnifyImage(1.5, this.fullScaleThumb);
    }

    public Icon getIcon() {
        if (this.iconThumb != null) {
            return this.iconThumb;
        }
        if (this.fullScaleThumb == null) {
            return null;
        }
        BufferedImage img = this.magnifyImage(0.16, this.fullScaleThumb);
        BufferedImage newImg = new BufferedImage(img.getWidth() + 2, img.getHeight() + 2, img.getType());
        Graphics g = newImg.getGraphics();
        Graphics2D g2D = (Graphics2D)g;
        g2D.setColor(BORDER_COLOR);
        g2D.fillRect(0, 0, newImg.getWidth(), newImg.getHeight());
        g2D.drawImage(img, null, 1, 1);
        this.iconThumb = new ImageIcon(newImg);
        return this.iconThumb;
    }
}

