/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer;

import java.util.Set;
import org.openmicroscopy.shoola.agents.hiviewer.DataLoader;
import org.openmicroscopy.shoola.agents.hiviewer.view.HiViewer;
import org.openmicroscopy.shoola.env.data.events.DSCallFeedbackEvent;
import org.openmicroscopy.shoola.env.data.model.ThumbnailData;
import org.openmicroscopy.shoola.env.data.views.CallHandle;

public class ThumbnailLoader
extends DataLoader {
    private Set images;
    private CallHandle handle;

    public ThumbnailLoader(HiViewer viewer, Set images) {
        super(viewer);
        if (images == null) {
            throw new IllegalArgumentException("Collection shouldn't be null.");
        }
        this.images = images;
    }

    public void load() {
        this.handle = this.hiBrwView.loadThumbnails(this.images, 96, 96, this);
    }

    public void cancel() {
        this.handle.cancel();
    }

    public void update(DSCallFeedbackEvent fe) {
        if (this.viewer.getState() == 6) {
            return;
        }
        String status = fe.getStatus();
        int percDone = fe.getPercentDone();
        if (status == null) {
            status = percDone == 100 ? "Done" : "";
        }
        this.viewer.setStatus(status, percDone);
        ThumbnailData td = (ThumbnailData)fe.getPartialResult();
        if (td != null) {
            this.viewer.setThumbnail(td.getImageID(), td.getThumbnail());
        }
    }

    public void handleNullResult() {
    }

    public void handleException(Throwable exc) {
        String s = "Thumbnail Retrieval Failure: ";
        this.registry.getLogger().error((Object)this, s + exc);
        this.registry.getUserNotifier().notifyError("Thumbnail Retrieval Failure", s, exc);
    }
}

