/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer;

import java.awt.Rectangle;
import org.openmicroscopy.shoola.agents.events.hiviewer.Browse;
import org.openmicroscopy.shoola.agents.hiviewer.view.HiViewer;
import org.openmicroscopy.shoola.agents.hiviewer.view.HiViewerFactory;
import org.openmicroscopy.shoola.env.Agent;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.event.AgentEvent;
import org.openmicroscopy.shoola.env.event.AgentEventListener;
import org.openmicroscopy.shoola.env.event.EventBus;
import pojos.ExperimenterData;

public class HiViewerAgent
implements Agent,
AgentEventListener {
    private static Registry registry;

    public static Registry getRegistry() {
        return registry;
    }

    private void handleBrowse(Browse evt) {
        if (evt == null) {
            return;
        }
        HiViewer viewer = null;
        switch (evt.getEventIndex()) {
            case 4: {
                viewer = HiViewerFactory.getImagesViewer(evt.getObjectIDs(), evt.getExperimenter(), evt.getUserGroupID());
                if (viewer == null) break;
                viewer.activate(evt.getRequesterBounds());
                break;
            }
            case 5: {
                viewer = HiViewerFactory.getDatasetsViewer(evt.getObjectIDs(), evt.getExperimenter(), evt.getUserGroupID());
                if (viewer == null) break;
                viewer.activate(evt.getRequesterBounds());
                break;
            }
            case 6: {
                viewer = HiViewerFactory.getCategoriesViewer(evt.getObjectIDs(), evt.getExperimenter(), evt.getUserGroupID());
                if (viewer == null) break;
                viewer.activate(evt.getRequesterBounds());
                break;
            }
            case 7: {
                viewer = HiViewerFactory.getProjectsViewer(evt.getObjectIDs(), evt.getExperimenter(), evt.getUserGroupID());
                if (viewer == null) break;
                viewer.activate(evt.getRequesterBounds());
                break;
            }
            case 8: {
                viewer = HiViewerFactory.getCategoryGroupsViewer(evt.getObjectIDs(), evt.getExperimenter(), evt.getUserGroupID());
                if (viewer == null) break;
                viewer.activate(evt.getRequesterBounds());
                break;
            }
            default: {
                HiViewerAgent.browse(evt.getEventIndex(), evt.getHierarchyObjectID(), evt.getExperimenter(), evt.getUserGroupID(), evt.getRequesterBounds());
            }
        }
    }

    public void activate() {
    }

    public void terminate() {
    }

    public void setContext(Registry ctx) {
        registry = ctx;
        EventBus bus = registry.getEventBus();
        bus.register((AgentEventListener)this, Browse.class);
    }

    public boolean canTerminate() {
        return true;
    }

    public void eventFired(AgentEvent e) {
        if (e instanceof Browse) {
            this.handleBrowse((Browse)e);
        }
    }

    public static void browse(int eventIndex, long id, ExperimenterData exp, long userGroupID, Rectangle bounds) {
        HiViewer viewer = null;
        switch (eventIndex) {
            case 0: {
                viewer = HiViewerFactory.getProjectViewer(id, exp, userGroupID);
                break;
            }
            case 1: {
                viewer = HiViewerFactory.getDatasetViewer(id, exp, userGroupID);
                break;
            }
            case 2: {
                viewer = HiViewerFactory.getCategoryGroupViewer(id, exp, userGroupID);
                break;
            }
            case 3: {
                viewer = HiViewerFactory.getCategoryViewer(id, exp, userGroupID);
            }
        }
        if (viewer != null) {
            viewer.activate(bounds);
        }
    }
}

