/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer;

import java.sql.Timestamp;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.openmicroscopy.shoola.agents.hiviewer.ThumbnailProvider;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageNode;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageSet;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.clsf.TreeCheckNode;
import pojos.CategoryData;
import pojos.CategoryGroupData;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ImageData;
import pojos.PermissionData;
import pojos.ProjectData;

public class HiTranslator {
    private static final String UNCLASSIFIED = "Wild at heart and free images.";
    private static final String LEFT = "[";
    private static final String RIGHT = "]";

    private static void formatToolTipFor(ImageDisplay node) {
        if (node == null) {
            throw new IllegalArgumentException("No node");
        }
        String toolTip = UIUtilities.formatToolTipText(node.getTitle());
        node.getTitleBar().setToolTipText(toolTip);
    }

    private static ImageDisplay getFirstElement(Set set) {
        if (set == null || set.size() == 0) {
            return null;
        }
        ImageDisplay display = null;
        Iterator i = set.iterator();
        if (i.hasNext()) {
            display = (ImageDisplay)i.next();
        }
        return display;
    }

    private static ImageNode linkImageTo(ImageData is, ImageSet parent) {
        ThumbnailProvider provider = new ThumbnailProvider(is);
        ImageNode node = new ImageNode(is.getName(), is, provider);
        HiTranslator.formatToolTipFor(node);
        provider.setImageNode(node);
        if (parent != null) {
            parent.addChildDisplay(node);
        }
        return node;
    }

    private static void linkImagesTo(Set images, ImageSet parent, long userID, long groupID) {
        if (images == null || parent == null) {
            return;
        }
        for (ImageData child : images) {
            if (!HiTranslator.isReadable((DataObject)child, userID, groupID)) continue;
            HiTranslator.linkImageTo(child, parent);
        }
    }

    private static ImageDisplay linkImages(DataObject uo, long userID, long groupID) {
        ImageSet node = null;
        if (uo instanceof DatasetData) {
            DatasetData ds = (DatasetData)uo;
            Set images = ds.getImages();
            String note = "";
            if (images != null) {
                note = LEFT + images.size() + RIGHT;
            }
            node = new ImageSet(ds.getName(), note, ds);
            HiTranslator.formatToolTipFor(node);
            HiTranslator.linkImagesTo(images, node, userID, groupID);
        } else if (uo instanceof CategoryData) {
            CategoryData data = (CategoryData)uo;
            String note = "";
            Set images = data.getImages();
            if (images != null) {
                note = LEFT + images.size() + RIGHT;
            }
            node = new ImageSet(data.getName(), note, data);
            HiTranslator.formatToolTipFor(node);
            HiTranslator.linkImagesTo(images, node, userID, groupID);
        }
        return node;
    }

    private static Set transformProjects(Set projects, long userID, long groupID) {
        if (projects == null) {
            throw new IllegalArgumentException("No projects.");
        }
        HashSet<ImageSet> results = new HashSet<ImageSet>();
        Iterator i = projects.iterator();
        String note = "";
        while (i.hasNext()) {
            ProjectData ps = (ProjectData)i.next();
            if (!HiTranslator.isReadable((DataObject)ps, userID, groupID)) continue;
            Set datasets = ps.getDatasets();
            if (datasets != null) {
                note = note + LEFT + datasets.size() + RIGHT;
            }
            ImageSet project = new ImageSet(ps.getName(), note, ps);
            HiTranslator.formatToolTipFor(project);
            if (datasets != null) {
                for (DataObject child : datasets) {
                    if (!HiTranslator.isReadable(child, userID, groupID)) continue;
                    project.addChildDisplay(HiTranslator.linkImages(child, userID, groupID));
                }
            }
            results.add(project);
        }
        return results;
    }

    private static Set transformProject(DataObject project, long userID, long groupID) {
        HashSet<DataObject> set = new HashSet<DataObject>(1);
        set.add(project);
        return HiTranslator.transformProjects(set, userID, groupID);
    }

    private static Set transformDatasets(Set datasets, long userID, long groupID) {
        if (datasets == null) {
            throw new IllegalArgumentException("No datasets.");
        }
        HashSet<ImageDisplay> results = new HashSet<ImageDisplay>();
        for (DataObject ho : datasets) {
            if (!HiTranslator.isReadable(ho, userID, groupID)) continue;
            results.add(HiTranslator.linkImages(ho, userID, groupID));
        }
        return results;
    }

    private static Set transformDataset(DataObject dataset, long userID, long groupID) {
        HashSet<DataObject> set = new HashSet<DataObject>(1);
        set.add(dataset);
        return HiTranslator.transformDatasets(set, userID, groupID);
    }

    private static Set transformCategoryGroups(Set groups, long userID, long groupID) {
        if (groups == null) {
            throw new IllegalArgumentException("No groups.");
        }
        HashSet<ImageSet> results = new HashSet<ImageSet>();
        Iterator i = groups.iterator();
        String note = "";
        while (i.hasNext()) {
            CategoryGroupData cgData = (CategoryGroupData)i.next();
            Set categories = cgData.getCategories();
            if (categories != null) {
                note = LEFT + categories.size() + RIGHT;
            }
            ImageSet group = new ImageSet(cgData.getName(), note, cgData);
            HiTranslator.formatToolTipFor(group);
            if (categories != null) {
                for (DataObject child : categories) {
                    if (!HiTranslator.isReadable(child, userID, groupID)) continue;
                    group.addChildDisplay(HiTranslator.linkImages(child, userID, groupID));
                }
            }
            results.add(group);
        }
        return results;
    }

    private static Set transformCategoryGroup(CategoryGroupData data, long userID, long groupID) {
        HashSet<CategoryGroupData> set = new HashSet<CategoryGroupData>(1);
        set.add(data);
        return HiTranslator.transformCategoryGroups(set, userID, groupID);
    }

    private static Set transformCategories(Set categories, long userID, long groupID) {
        if (categories == null) {
            throw new IllegalArgumentException("No categories.");
        }
        HashSet<ImageSet> results = new HashSet<ImageSet>();
        Iterator i = categories.iterator();
        String note = "";
        while (i.hasNext()) {
            CategoryData data = (CategoryData)i.next();
            if (!HiTranslator.isReadable((DataObject)data, userID, groupID)) continue;
            Set images = data.getImages();
            if (images != null) {
                note = LEFT + images.size() + RIGHT;
            }
            ImageSet parent = new ImageSet(data.getName(), note, data);
            HiTranslator.formatToolTipFor(parent);
            HiTranslator.linkImagesTo(images, parent, userID, groupID);
            results.add(parent);
        }
        return results;
    }

    private static Set transformCategory(CategoryData data, long userID, long groupID) {
        HashSet<CategoryData> set = new HashSet<CategoryData>(1);
        set.add(data);
        return HiTranslator.transformCategories(set, userID, groupID);
    }

    private static TreeCheckNode transformCategoryPath(CategoryData data) {
        if (data == null) {
            throw new IllegalArgumentException("Cannot be null");
        }
        IconManager im = IconManager.getInstance();
        TreeCheckNode category = new TreeCheckNode(data, im.getIcon(IconManager.CATEGORY), data.getName(), true);
        return category;
    }

    private static TreeCheckNode transformCategoryGroupPath(CategoryGroupData data, long userID, long groupID) {
        if (data == null) {
            throw new IllegalArgumentException("Cannot be null");
        }
        IconManager im = IconManager.getInstance();
        TreeCheckNode group = new TreeCheckNode(data, im.getIcon(IconManager.CATEGORY_GROUP), data.getName(), false);
        Set categories = data.getCategories();
        for (CategoryData child : categories) {
            if (!HiTranslator.isWritable((DataObject)child, userID, groupID)) continue;
            group.addChildDisplay(HiTranslator.transformCategoryPath(child));
        }
        return group;
    }

    public static Set transformHierarchy(Set dataObjects, long userID, long groupID) {
        if (dataObjects == null) {
            throw new IllegalArgumentException("No objects.");
        }
        HashSet<ImageDisplay> results = new HashSet<ImageDisplay>();
        Iterator i = dataObjects.iterator();
        ImageSet unclassified = null;
        while (i.hasNext()) {
            DataObject ho = (DataObject)i.next();
            if (ho instanceof ProjectData) {
                results.add(HiTranslator.getFirstElement(HiTranslator.transformProject(ho, userID, groupID)));
                continue;
            }
            if (ho instanceof DatasetData) {
                results.add(HiTranslator.getFirstElement(HiTranslator.transformDataset(ho, userID, groupID)));
                continue;
            }
            if (ho instanceof CategoryGroupData) {
                results.add(HiTranslator.getFirstElement(HiTranslator.transformCategoryGroup((CategoryGroupData)ho, userID, groupID)));
                continue;
            }
            if (ho instanceof CategoryData) {
                results.add(HiTranslator.getFirstElement(HiTranslator.transformCategory((CategoryData)ho, userID, groupID)));
                continue;
            }
            if (!(ho instanceof ImageData) || !HiTranslator.isReadable(ho, userID, groupID)) continue;
            if (unclassified == null) {
                unclassified = new ImageSet(UNCLASSIFIED, new Object());
                HiTranslator.formatToolTipFor(unclassified);
            }
            HiTranslator.linkImageTo((ImageData)ho, unclassified);
        }
        if (unclassified != null) {
            results.add(unclassified);
        }
        return results;
    }

    public static Set transformImages(Set dataObjects, long userID, long groupID) {
        if (dataObjects == null) {
            throw new IllegalArgumentException("No objects.");
        }
        HashSet<ImageNode> results = new HashSet<ImageNode>();
        for (DataObject ho : dataObjects) {
            if (!HiTranslator.isReadable(ho, userID, groupID) || !(ho instanceof ImageData)) continue;
            results.add(HiTranslator.linkImageTo((ImageData)ho, null));
        }
        return results;
    }

    public static Set transform(DataObject ho, long userID, long groupID) {
        if (ho == null) {
            throw new IllegalArgumentException("No objects.");
        }
        HashSet<DataObject> s = new HashSet<DataObject>(1);
        s.add(ho);
        return HiTranslator.transformHierarchy(s, userID, groupID);
    }

    public static Set transformClassificationPaths(Set paths, long userID, long groupID) {
        if (paths == null) {
            throw new IllegalArgumentException("No objects.");
        }
        HashSet<TreeCheckNode> results = new HashSet<TreeCheckNode>();
        for (DataObject ho : paths) {
            if (!HiTranslator.isWritable(ho, userID, groupID)) continue;
            if (ho instanceof CategoryGroupData) {
                Set categories = ((CategoryGroupData)ho).getCategories();
                if (categories == null || categories.size() == 0) continue;
                results.add(HiTranslator.transformCategoryGroupPath((CategoryGroupData)ho, userID, groupID));
                continue;
            }
            if (!(ho instanceof CategoryData)) continue;
            results.add(HiTranslator.transformCategoryPath((CategoryData)ho));
        }
        return results;
    }

    public static boolean isReadable(DataObject ho, long userID, long groupID) {
        PermissionData permissions = ho.getPermissions();
        if (userID == ho.getOwner().getId()) {
            return permissions.isUserRead();
        }
        return permissions.isGroupRead();
    }

    public static boolean isWritable(DataObject ho, long userID, long groupID) {
        PermissionData permissions = ho.getPermissions();
        if (userID == ho.getOwner().getId()) {
            return permissions.isUserWrite();
        }
        return permissions.isGroupWrite();
    }

    public static Timestamp getDefaultTimestamp() {
        return new Timestamp(new Date().getTime());
    }
}

