/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import org.openmicroscopy.shoola.agents.hiviewer.HiViewerAgent;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageDisplay;
import org.openmicroscopy.shoola.env.config.Registry;

public class Colors {
    public static final int TITLE_BAR_HIGHLIGHT = 0;
    public static final int TITLE_BAR = 1;
    public static final int REGEX_HIGHLIGHT = 2;
    public static final int ANNOTATED_HIGHLIGHT = 3;
    public static final int ANNOTATED = 4;
    private static Colors singleton;
    private Map<Integer, Color> colorsMap;
    private Registry registry;

    private Colors(Registry registry) {
        if (registry == null) {
            throw new NullPointerException("No registry.");
        }
        this.registry = registry;
        this.colorsMap = new HashMap<Integer, Color>();
        this.initializeColors();
    }

    private void initializeColors() {
        Color c = (Color)this.registry.lookup("/resources/colors/TitleBarHighlight");
        this.colorsMap.put(new Integer(0), c);
        c = (Color)this.registry.lookup("/resources/colors/TitleBar");
        this.colorsMap.put(new Integer(1), c);
        c = (Color)this.registry.lookup("/resources/colors/AnnotatedHighlight");
        this.colorsMap.put(new Integer(3), c);
        c = (Color)this.registry.lookup("/resources/colors/Annotated");
        this.colorsMap.put(new Integer(4), c);
        c = (Color)this.registry.lookup("/resources/colors/RegExHighlight");
        this.colorsMap.put(new Integer(2), c);
    }

    public static Colors getInstance() {
        if (singleton == null) {
            singleton = new Colors(HiViewerAgent.getRegistry());
        }
        return singleton;
    }

    public Color getColor(int id) {
        if (id < 0 || this.colorsMap.size() <= id) {
            this.registry.getLogger().error((Object)this, "color id out of range: " + id + ".");
            return null;
        }
        return this.colorsMap.get(new Integer(id));
    }

    public Color getDeselectedHighLight(ImageDisplay node) {
        if (node == null) {
            return this.getColor(1);
        }
        if (node.getParentDisplay() == null) {
            return this.getColor(1);
        }
        Color c = node.getHighlight();
        if (c == null) {
            return null;
        }
        if (c.equals(this.getColor(0))) {
            Color pc = node.getPreviousHighlight();
            c = this.getColor(2).equals(pc) ? pc : null;
        } else if (c.equals(this.getColor(3))) {
            c = this.getColor(4);
        } else if (c.equals(this.getColor(2))) {
            c = this.getColor(2);
        }
        return c;
    }

    public Color getSelectedHighLight(ImageDisplay node) {
        if (node == null) {
            return this.getColor(1);
        }
        if (node.getParentDisplay() == null) {
            return this.getColor(1);
        }
        Color c = node.getHighlight();
        if (c == null) {
            c = this.getColor(0);
        } else if (c.equals(this.getColor(4))) {
            c = this.getColor(3);
        } else if (c.equals(this.getColor(2))) {
            c = this.getColor(0);
        }
        return c;
    }
}

