/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer;

import org.openmicroscopy.shoola.agents.hiviewer.HiViewerAgent;
import org.openmicroscopy.shoola.agents.hiviewer.clipboard.ClipBoard;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.events.DSCallAdapter;
import org.openmicroscopy.shoola.env.data.views.HierarchyBrowsingView;

public abstract class CBDataLoader
extends DSCallAdapter {
    protected ClipBoard clipBoard;
    protected final Registry registry;
    protected HierarchyBrowsingView hiBrwView;

    public CBDataLoader(ClipBoard clipBoard) {
        if (clipBoard == null) {
            throw new NullPointerException("No clipBoard.");
        }
        this.clipBoard = clipBoard;
        this.registry = HiViewerAgent.getRegistry();
        this.hiBrwView = (HierarchyBrowsingView)this.registry.getDataServicesView(HierarchyBrowsingView.class);
    }

    public void handleNullResult() {
        this.handleException(new Exception("No data available."));
    }

    public void handleCancellation() {
        String info = "The data retrieval has been cancelled.";
        this.registry.getLogger().info((Object)this, info);
        this.registry.getUserNotifier().notifyInfo("Data Retrieval Cancellation", info);
    }

    public void handleException(Throwable exc) {
        String s = "Data Retrieval Failure: ";
        this.registry.getLogger().error((Object)this, s + exc);
        this.registry.getUserNotifier().notifyError("Data Retrieval Failure", s, exc);
        this.clipBoard.discard();
    }

    public abstract void load();

    public abstract void cancel();
}

