/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.events.hiviewer;

import java.awt.Rectangle;
import java.util.Set;
import org.openmicroscopy.shoola.env.event.RequestEvent;
import pojos.ExperimenterData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Browse
extends RequestEvent {
    public static final int PROJECT = 0;
    public static final int DATASET = 1;
    public static final int CATEGORY_GROUP = 2;
    public static final int CATEGORY = 3;
    public static final int IMAGES = 4;
    public static final int DATASETS = 5;
    public static final int CATEGORIES = 6;
    public static final int PROJECTS = 7;
    public static final int CATEGORY_GROUPS = 8;
    private long hierarchyObjectID;
    private Set<Long> objectsIDs;
    private int eventIndex;
    private long userGroupID;
    private Rectangle requesterBounds;
    private ExperimenterData experimenter;

    private void checkEventIndex(int index) {
        switch (index) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return;
            }
        }
        throw new IllegalArgumentException("Event index not valid.");
    }

    private void checkMultiNodesIndex(int index) {
        switch (index) {
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return;
            }
        }
        throw new IllegalArgumentException("Event index not valid.");
    }

    public Browse(long hierarchyObjectID, int index, ExperimenterData experimenter, long userGroupID, Rectangle bounds) {
        this.checkEventIndex(index);
        if (experimenter == null) {
            throw new IllegalArgumentException("No experimenter.");
        }
        this.hierarchyObjectID = hierarchyObjectID;
        this.eventIndex = index;
        this.experimenter = experimenter;
        this.userGroupID = userGroupID;
        this.requesterBounds = bounds;
    }

    public Browse(Set<Long> ids, int index, ExperimenterData experimenter, long userGroupID, Rectangle bounds) {
        this.checkMultiNodesIndex(index);
        if (experimenter == null) {
            throw new IllegalArgumentException("No experimenter.");
        }
        this.eventIndex = index;
        this.experimenter = experimenter;
        this.userGroupID = userGroupID;
        this.objectsIDs = ids;
        this.requesterBounds = bounds;
    }

    public int getEventIndex() {
        return this.eventIndex;
    }

    public long getHierarchyObjectID() {
        return this.hierarchyObjectID;
    }

    public ExperimenterData getExperimenter() {
        return this.experimenter;
    }

    public long getUserGroupID() {
        return this.userGroupID;
    }

    public Set<Long> getObjectIDs() {
        return this.objectsIDs;
    }

    public Rectangle getRequesterBounds() {
        return this.requesterBounds;
    }
}

