/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.stateful;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import javax.ejb.EJBObject;
import javax.ejb.RemoteHome;
import javax.naming.Context;
import javax.naming.NamingException;
import org.jboss.annotation.ejb.RemoteBinding;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.Dispatcher;
import org.jboss.aop.advice.AdviceStack;
import org.jboss.aspects.remoting.Remoting;
import org.jboss.ejb3.JBossProxy;
import org.jboss.ejb3.ProxyFactory;
import org.jboss.ejb3.ProxyFactoryHelper;
import org.jboss.ejb3.remoting.RemoteProxyFactory;
import org.jboss.ejb3.stateful.BaseStatefulProxyFactory;
import org.jboss.ejb3.stateful.StatefulContainer;
import org.jboss.ejb3.stateful.StatefulHandleImpl;
import org.jboss.ejb3.stateful.StatefulHomeRemoteProxy;
import org.jboss.ejb3.stateful.StatefulRemoteProxy;
import org.jboss.logging.Logger;
import org.jboss.naming.Util;
import org.jboss.remoting.InvokerLocator;

public class StatefulRemoteProxyFactory
extends BaseStatefulProxyFactory
implements RemoteProxyFactory {
    private static final Logger log = Logger.getLogger(StatefulRemoteProxyFactory.class);
    private RemoteBinding binding;
    private InvokerLocator locator;

    public void setRemoteBinding(RemoteBinding binding) {
        this.binding = binding;
    }

    protected Class[] getInterfaces() {
        Class[] remoteInterfaces = ProxyFactoryHelper.getRemoteInterfaces(this.container);
        Class[] interfaces = new Class[remoteInterfaces.length + 2];
        System.arraycopy(remoteInterfaces, 0, interfaces, 0, remoteInterfaces.length);
        interfaces[remoteInterfaces.length] = JBossProxy.class;
        interfaces[remoteInterfaces.length + 1] = EJBObject.class;
        return interfaces;
    }

    protected void initializeJndiName() {
        this.jndiName = ProxyFactoryHelper.getRemoteJndiName(this.container, this.binding);
    }

    public void init() throws Exception {
        super.init();
        String clientBindUrl = this.binding.clientBindUrl();
        this.locator = new InvokerLocator(clientBindUrl);
    }

    public void start() throws Exception {
        this.init();
        super.start();
        Class[] interfaces = new Class[]{ProxyFactory.class};
        Object factoryProxy = Remoting.createPojiProxy((Object)(this.jndiName + "StatefulProxyFactory"), (Class[])interfaces, (String)this.binding.clientBindUrl());
        try {
            Util.bind((Context)this.container.getInitialContext(), (String)(this.jndiName + "StatefulProxyFactory"), (Object)factoryProxy);
        }
        catch (NamingException e) {
            NamingException namingException = new NamingException("Could not bind stateful remote proxy with ejb name " + this.container.getEjbName() + " into JNDI under jndiName: " + this.container.getInitialContext().getNameInNamespace() + "/" + this.jndiName + "StatefulProxyFactory");
            namingException.setRootCause(e);
            throw namingException;
        }
        Dispatcher.singleton.registerTarget((Object)(this.jndiName + "StatefulProxyFactory"), (Object)this);
        StatefulContainer statefulContainer = (StatefulContainer)this.container;
        RemoteHome remoteHome = (RemoteHome)statefulContainer.resolveAnnotation(RemoteHome.class);
        if (remoteHome != null) {
            Object homeProxy = this.createHomeProxy(remoteHome.value());
            Util.bind((Context)this.container.getInitialContext(), (String)(this.jndiName + "Home"), (Object)homeProxy);
        }
    }

    public void stop() throws Exception {
        super.stop();
        Util.unbind((Context)this.container.getInitialContext(), (String)(this.jndiName + "StatefulProxyFactory"));
        Dispatcher.singleton.unregisterTarget((Object)(this.jndiName + "StatefulProxyFactory"));
        StatefulContainer statefulContainer = (StatefulContainer)this.container;
        RemoteHome remoteHome = (RemoteHome)statefulContainer.resolveAnnotation(RemoteHome.class);
        if (remoteHome != null) {
            Util.unbind((Context)this.container.getInitialContext(), (String)(this.jndiName + "Home"));
        }
    }

    public Object createHomeProxy(Class homeInterface) {
        try {
            AdviceStack stack;
            String containerId = this.container.getObjectName().getCanonicalName();
            String stackName = "StatefulSessionClientInterceptors";
            if (this.binding.interceptorStack() != null && !this.binding.interceptorStack().equals("")) {
                stackName = this.binding.interceptorStack();
            }
            if ((stack = AspectManager.instance().getAdviceStack(stackName)) == null) {
                throw new RuntimeException("unable to find interceptor stack: " + stackName);
            }
            StatefulHomeRemoteProxy proxy = new StatefulHomeRemoteProxy(containerId, stack.createInterceptors((Advisor)this.container, null), this.locator);
            this.setEjb21Objects(proxy);
            Class[] intfs = new Class[]{homeInterface};
            return Proxy.newProxyInstance(this.container.getBeanClass().getClassLoader(), intfs, (InvocationHandler)proxy);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    public Object createProxy() {
        try {
            AdviceStack stack;
            String containerId = this.container.getObjectName().getCanonicalName();
            String stackName = "StatefulSessionClientInterceptors";
            if (this.binding.interceptorStack() != null && !this.binding.interceptorStack().equals("")) {
                stackName = this.binding.interceptorStack();
            }
            if ((stack = AspectManager.instance().getAdviceStack(stackName)) == null) {
                throw new RuntimeException("unable to find interceptor stack: " + stackName);
            }
            StatefulRemoteProxy proxy = new StatefulRemoteProxy(containerId, stack.createInterceptors((Advisor)this.container, null), this.locator);
            this.setEjb21Objects(proxy);
            Object[] args = new Object[]{proxy};
            return this.proxyConstructor.newInstance(args);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getTargetException());
        }
    }

    protected StatefulHandleImpl getHandle() {
        StatefulHandleImpl handle = new StatefulHandleImpl();
        RemoteBinding remoteBinding = (RemoteBinding)this.advisor.resolveAnnotation(RemoteBinding.class);
        if (remoteBinding != null) {
            handle.jndiName = remoteBinding.jndiBinding();
        }
        return handle;
    }

    public Object createProxy(Object id) {
        try {
            String containerId = this.container.getObjectName().getCanonicalName();
            String stackName = "StatefulSessionClientInterceptors";
            if (this.binding.interceptorStack() != null && !this.binding.interceptorStack().equals("")) {
                stackName = this.binding.interceptorStack();
            }
            AdviceStack stack = AspectManager.instance().getAdviceStack(stackName);
            StatefulRemoteProxy proxy = new StatefulRemoteProxy(containerId, stack.createInterceptors((Advisor)this.container, null), this.locator, id);
            this.setEjb21Objects(proxy);
            Object[] args = new Object[]{proxy};
            return this.proxyConstructor.newInstance(args);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getTargetException());
        }
    }
}

