/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.stateful;

import java.rmi.RemoteException;
import javax.ejb.ApplicationException;
import javax.ejb.EJBException;
import org.jboss.annotation.ejb.SerializedConcurrentAccess;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.dd.ApplicationExceptionList;
import org.jboss.ejb3.dd.AssemblyDescriptor;
import org.jboss.ejb3.stateful.StatefulBeanContext;
import org.jboss.ejb3.stateful.StatefulContainer;
import org.jboss.ejb3.stateful.StatefulContainerInvocation;

public class StatefulInstanceInterceptor
implements Interceptor {
    public String getName() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Invocation invocation) throws Throwable {
        Object object;
        boolean block;
        StatefulContainerInvocation ejb = (StatefulContainerInvocation)invocation;
        Object id = ejb.getId();
        StatefulContainer container = (StatefulContainer)ejb.getAdvisor();
        StatefulBeanContext target = container.getCache().get(id);
        boolean bl = block = container.resolveAnnotation(SerializedConcurrentAccess.class) != null;
        if (block) {
            target.getLock().lockInterruptibly();
        } else {
            object = target;
            synchronized (object) {
                if (target.isInInvocation()) {
                    throw new EJBException("Application Error: no concurrent calls on stateful beans");
                }
                target.setInInvocation(true);
            }
        }
        ejb.setTargetObject(target.getInstance());
        ejb.setBeanContext(target);
        StatefulBeanContext.currentBean.push(target);
        try {
            if (target.isDiscarded()) {
                throw new EJBException("SFSB was discarded by another thread");
            }
            object = ejb.invokeNext();
            return object;
        }
        catch (Exception ex) {
            if (StatefulInstanceInterceptor.isApplicationException(ex.getClass(), container)) {
                throw ex;
            }
            if (ex instanceof RuntimeException || ex instanceof RemoteException) {
                container.getCache().remove(id);
                target.setDiscarded(true);
            }
            throw ex;
        }
        finally {
            StatefulBeanContext.currentBean.pop();
            StatefulBeanContext statefulBeanContext = target;
            synchronized (statefulBeanContext) {
                target.setInInvocation(false);
                if (!target.isTxSynchronized() && !target.isDiscarded()) {
                    container.getCache().finished(target);
                }
                if (block) {
                    target.getLock().unlock();
                }
            }
        }
    }

    public static boolean isApplicationException(Class exceptionClass, EJBContainer container) {
        ApplicationExceptionList exceptionList;
        if (exceptionClass.isAnnotationPresent(ApplicationException.class)) {
            return true;
        }
        AssemblyDescriptor assembly = container.getAssemblyDescriptor();
        if (assembly != null && (exceptionList = assembly.getApplicationExceptionList()) != null) {
            for (String className : exceptionList.getClassList()) {
                if (!className.equals(exceptionClass.getName())) continue;
                return true;
            }
        }
        return false;
    }
}

