/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.mdb;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import javax.ejb.EJBException;
import javax.ejb.Timer;
import javax.ejb.TimerService;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.ServerSessionPool;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.Transaction;
import org.jboss.annotation.ejb.AcknowledgementMode;
import org.jboss.annotation.ejb.Consumer;
import org.jboss.annotation.ejb.DefaultActivationSpecs;
import org.jboss.annotation.ejb.Durability;
import org.jboss.annotation.ejb.Local;
import org.jboss.annotation.ejb.MessageProperties;
import org.jboss.annotation.ejb.MessagePropertiesImpl;
import org.jboss.annotation.ejb.Producer;
import org.jboss.annotation.ejb.Producers;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.MethodInfo;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.InvocationResponse;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.aop.util.MethodHashing;
import org.jboss.aop.util.PayloadKey;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.txtimer.TimedObjectInvoker;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.EJBContainerInvocation;
import org.jboss.ejb3.Ejb3Deployment;
import org.jboss.ejb3.EjbTimerUtil;
import org.jboss.ejb3.ThreadLocalENCFactory;
import org.jboss.ejb3.interceptor.InterceptorInfoRepository;
import org.jboss.ejb3.mdb.ActivationSpec;
import org.jboss.ejb3.mdb.DLQHandler;
import org.jboss.ejb3.mdb.LocalProducerFactory;
import org.jboss.ejb3.mdb.MDBConfig;
import org.jboss.ejb3.mdb.MDBContext;
import org.jboss.ejb3.mdb.ProducerFactory;
import org.jboss.ejb3.mdb.RemoteProducerFactory;
import org.jboss.ejb3.tx.TxUtil;
import org.jboss.jms.ConnectionFactoryHelper;
import org.jboss.jms.asf.ServerSessionPoolFactory;
import org.jboss.jms.asf.StdServerSessionPool;
import org.jboss.jms.jndi.JMSProviderAdapter;
import org.jboss.logging.Logger;
import org.jboss.mx.util.MBeanServerLocator;

public class ConsumerContainer
extends EJBContainer
implements TimedObjectInvoker {
    private static final Logger log = Logger.getLogger(ConsumerContainer.class);
    protected TimerService timerService;
    protected ActivationSpec activationSpec = new ActivationSpec();
    protected boolean isContainerManagedTx;
    protected AcknowledgementMode acknowledgeMode;
    protected Connection connection;
    protected MDBConfig config;
    protected ExceptionListenerImpl exListener;
    protected DLQHandler dlqHandler;
    protected HashMap<Long, ConnectionConsumer> connectionConsumers = new HashMap();
    protected HashMap<Long, ServerSessionPool> serverSessionPools = new HashMap();
    protected ArrayList<ProducerFactory> producers = new ArrayList();
    protected static final String DEFAULT_DESTINATION_TYPE = "javax.jms.Topic";
    protected Method getServerSessionPool;
    public static final String CONSUMER_MESSAGE = "CONSUMER_MESSAGE";

    public ConsumerContainer(String ejbName, AspectManager manager, ClassLoader cl, String beanClassName, Hashtable ctxProperties, InterceptorInfoRepository interceptorRepository, Ejb3Deployment deployment) {
        super("jboss.j2ee:service=EJB3,name=" + ejbName, manager, cl, beanClassName, ejbName, ctxProperties, interceptorRepository, deployment);
        Method[] methods;
        this.beanContextClass = MDBContext.class;
        for (Method m : methods = ServerSessionPoolFactory.class.getMethods()) {
            if (!m.getName().equals("getServerSessionPool")) continue;
            this.getServerSessionPool = m;
            break;
        }
    }

    public void start() throws Exception {
        super.start();
        this.exListener = new ExceptionListenerImpl(this);
        this.populateActivationSpec();
        this.config = MDBConfig.createMDBConfig(this.activationSpec);
        try {
            this.innerCreate();
        }
        catch (JMSException e) {
            log.error((Object)"FAILED INNER CREATE", (Throwable)e);
            new Thread("EJB3 MDB Create Recovery Thread"){

                public void run() {
                    ConsumerContainer.this.exListener.onException(e);
                }
            }.start();
            return;
        }
        if (this.dlqHandler != null) {
            this.dlqHandler.start();
        }
        if (this.connection != null) {
            this.connection.setExceptionListener((ExceptionListener)this.exListener);
            this.connection.start();
        }
        this.timerService = EjbTimerUtil.getTimerService(this, this);
        this.registerProducers();
    }

    public Class[] getProducerInterfaces(Container container1) {
        Producers producersAnnotation;
        Class producer;
        Class beanClass = container1.getBeanClass();
        Class[] interfaces = beanClass.getInterfaces();
        if (interfaces.length == 0) {
            throw new RuntimeException("Bean class must implement at least one interface: " + beanClass.getName());
        }
        if (interfaces.length == 1) {
            return interfaces;
        }
        ArrayList<Class> localInterfaces = new ArrayList<Class>();
        for (int i = 0; i < interfaces.length; ++i) {
            if (!interfaces[i].isAnnotationPresent(Producer.class)) continue;
            localInterfaces.add(interfaces[i]);
        }
        Producer annotation = (Producer)this.resolveAnnotation(Producer.class);
        if (annotation != null && (producer = annotation.producer()) != null) {
            localInterfaces.add(producer);
        }
        if ((producersAnnotation = (Producers)this.resolveAnnotation(Producers.class)) != null) {
            for (Producer producerAnnotation : producersAnnotation.value()) {
                Class producer2 = producerAnnotation.producer();
                if (producer2 == null) continue;
                localInterfaces.add(producer2);
            }
        }
        if (localInterfaces.size() == 0) {
            return null;
        }
        interfaces = localInterfaces.toArray(new Class[localInterfaces.size()]);
        return interfaces;
    }

    protected void registerProducers() throws Exception {
        Destination dest = (Destination)this.getInitialContext().lookup(this.config.getDestination());
        Class[] producers = this.getProducerInterfaces(this);
        MessageProperties props = (MessageProperties)this.resolveAnnotation(MessageProperties.class);
        if (props == null) {
            props = new MessagePropertiesImpl();
        }
        for (Class producer : producers) {
            log.debug((Object)("Producer: " + producer.getName()));
            ProducerFactory producerFactory = null;
            producerFactory = producer.isAnnotationPresent(Local.class) ? new LocalProducerFactory(this, producer, props, dest, this.getInitialContext(), this.initialContextProperties) : new RemoteProducerFactory(this, producer, props, dest, this.getInitialContext(), this.initialContextProperties);
            this.producers.add(producerFactory);
            producerFactory.start();
        }
    }

    protected void unregisterProducers() throws Exception {
        for (ProducerFactory factory : this.producers) {
            factory.stop();
        }
    }

    private void innerCreate() throws Exception {
        log.debug((Object)"Initializing");
        Consumer Consumer2 = (Consumer)this.resolveAnnotation(Consumer.class);
        JMSProviderAdapter adapter = this.getJMSProviderAdapter();
        log.debug((Object)("Provider adapter: " + adapter));
        this.setupDLQ(adapter);
        TransactionManagement transactionManagement = (TransactionManagement)this.resolveAnnotation(TransactionManagement.class);
        this.isContainerManagedTx = transactionManagement == null ? true : transactionManagement.value() == TransactionManagementType.CONTAINER;
        String ackMode = this.config.getAcknowledgeMode();
        this.acknowledgeMode = ackMode != null && (ackMode.equals("DUPS_OK_ACKNOWLEDGE") || ackMode.equals(AcknowledgementMode.AUTO_ACKNOWLEDGE.name()) || ackMode.equals("Dups-ok-acknowledge")) ? AcknowledgementMode.DUPS_OK : AcknowledgementMode.AUTO_ACKNOWLEDGE;
        Context context = adapter.getInitialContext();
        log.debug((Object)("context: " + context));
        if (context == null) {
            throw new RuntimeException("Failed to get the root context");
        }
        String destinationType = this.config.getDestinationType();
        if (destinationType == null) {
            log.warn((Object)"No message-driven-destination given; using; guessing type");
            destinationType = this.getDestinationType(context, this.config.getDestination());
        }
        if (DEFAULT_DESTINATION_TYPE.equals(destinationType)) {
            this.innerCreateTopic(context, adapter);
        } else if ("javax.jms.Queue".equals(destinationType)) {
            this.innerCreateQueue(context, adapter);
        } else {
            throw new DeploymentException("Unknown destination-type " + destinationType);
        }
        log.debug((Object)("Initialized with config " + this.toString()));
        context.close();
    }

    private void innerCreateQueue(Context context, JMSProviderAdapter adapter) throws Exception {
        log.debug((Object)("Got destination type Queue for " + this.ejbName));
        String jndiSuffix = this.parseJndiSuffix(this.config.getDestination(), this.ejbName);
        log.debug((Object)("jndiSuffix: " + jndiSuffix));
        Object qFactory = context.lookup(adapter.getQueueFactoryRef());
        QueueConnection qConnection = null;
        try {
            qConnection = ConnectionFactoryHelper.createQueueConnection((Object)qFactory, (String)this.config.getUser(), (String)this.config.getPassword());
            this.connection = qConnection;
        }
        catch (ClassCastException e) {
            throw new DeploymentException("Expected a QueueConnection check your provider adaptor: " + adapter.getQueueFactoryRef());
        }
        String clientId = this.config.getClientID();
        log.debug((Object)("Using client id: " + clientId));
        if (clientId != null && clientId.length() > 0) {
            this.connection.setClientID(clientId);
        }
        Queue queue = null;
        try {
            if (this.config.getDestination() != null) {
                queue = (Queue)context.lookup(this.config.getDestination());
            }
        }
        catch (NamingException e) {
            log.warn((Object)("Could not find the queue destination-jndi-name=" + this.config.getDestination()));
        }
        catch (ClassCastException e) {
            throw new DeploymentException("Expected a Queue destination-jndi-name=" + this.config.getDestination());
        }
        if (queue == null) {
            queue = (Queue)this.createDestination(Queue.class, context, "queue/" + jndiSuffix, jndiSuffix);
        }
        this.registerQueueListeners(qConnection, queue);
    }

    private void registerQueueListeners(QueueConnection qConnection, Queue queue) throws NamingException, JMSException {
        MessageListenerImpl listener = new MessageListenerImpl(this);
        Class[] producers = this.getProducerInterfaces(this);
        HashSet<Long> visited = new HashSet<Long>();
        for (Class producer : producers) {
            for (Method method : producer.getMethods()) {
                long hash = MethodHashing.calculateHash((Method)method);
                if (visited.contains(hash)) continue;
                visited.add(hash);
                Method methodMessage = (Method)this.advisedMethods.get(hash);
                ServerSessionPool serverSessionPool = this.createSessionPool((Destination)queue, (Connection)qConnection, true, this.acknowledgeMode.ordinal(), listener, methodMessage);
                log.debug((Object)("Server session pool: " + serverSessionPool));
                this.serverSessionPools.put(hash, serverSessionPool);
                ConnectionConsumer connectionConsumer = qConnection.createConnectionConsumer(queue, this.config.getMessageSelector(), serverSessionPool, this.config.getMaxMessages());
                log.debug((Object)("Connection consumer: " + connectionConsumer));
                this.connectionConsumers.put(hash, connectionConsumer);
            }
        }
    }

    private void innerCreateTopic(Context context, JMSProviderAdapter adapter) throws Exception {
        String durability;
        log.debug((Object)("Got destination type Topic for " + this.ejbName));
        String jndiSuffix = this.parseJndiSuffix(this.config.getDestination(), this.ejbName);
        log.debug((Object)("jndiSuffix: " + jndiSuffix));
        Object factory = context.lookup(adapter.getTopicFactoryRef());
        TopicConnection tConnection = null;
        try {
            tConnection = ConnectionFactoryHelper.createTopicConnection((Object)factory, (String)this.config.getUser(), (String)this.config.getPassword());
            this.connection = tConnection;
        }
        catch (ClassCastException e) {
            throw new DeploymentException("Expected a TopicConnection check your provider adaptor: " + adapter.getTopicFactoryRef());
        }
        String clientId = this.config.getClientID();
        log.debug((Object)("Using client id: " + clientId));
        if (clientId != null && clientId.length() > 0) {
            this.connection.setClientID(clientId);
        }
        Topic topic = null;
        try {
            if (this.config.getDestination() != null) {
                topic = (Topic)context.lookup(this.config.getDestination());
            }
        }
        catch (NamingException e) {
            log.warn((Object)("Could not find the topic destination-jndi-name=" + this.config.getDestination()));
        }
        catch (ClassCastException e) {
            throw new DeploymentException("Expected a Topic destination-jndi-name=" + this.config.getDestination());
        }
        if (topic == null) {
            topic = (Topic)this.createDestination(Topic.class, context, "topic/" + jndiSuffix, jndiSuffix);
        }
        Durability subscriptionDurability = (durability = this.config.getDurability()) != null && durability.equals("Durable") ? Durability.DURABLE : Durability.NON_DURABLE;
        this.registerTopicListeners(tConnection, subscriptionDurability, topic);
    }

    private void registerTopicListeners(TopicConnection tConnection, Durability subscriptionDurability, Topic topic) throws NamingException, JMSException {
        MessageListenerImpl listener = new MessageListenerImpl(this);
        Class[] producers = this.getProducerInterfaces(this);
        HashSet<Long> visited = new HashSet<Long>();
        for (Class producer : producers) {
            for (Method method : producer.getMethods()) {
                long hash = MethodHashing.calculateHash((Method)method);
                if (visited.contains(hash)) continue;
                visited.add(hash);
                Method methodMessage = (Method)this.advisedMethods.get(hash);
                ServerSessionPool serverSessionPool = this.createSessionPool((Destination)topic, (Connection)tConnection, true, this.acknowledgeMode.ordinal(), listener, methodMessage);
                this.serverSessionPools.put(hash, serverSessionPool);
                ConnectionConsumer connectionConsumer = null;
                if (subscriptionDurability == Durability.NON_DURABLE) {
                    connectionConsumer = tConnection.createConnectionConsumer(topic, this.config.getMessageSelector(), serverSessionPool, this.config.getMaxMessages());
                } else {
                    String durableName = this.config.getSubscriptionName();
                    connectionConsumer = tConnection.createDurableConnectionConsumer(topic, durableName, this.config.getMessageSelector(), serverSessionPool, this.config.getMaxMessages());
                }
                this.connectionConsumers.put(hash, connectionConsumer);
                log.debug((Object)"Topic connectionConsumer set up");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ServerSessionPool createSessionPool(Destination dest, Connection connection, boolean isTransacted, int ack, MessageListener listener, Method method) throws NamingException, JMSException {
        ServerSessionPool pool;
        block10: {
            InitialContext context = this.getInitialContext();
            try {
                boolean isNotSupportedTx;
                log.debug((Object)("looking up session pool factory: " + this.config.getServerSessionPoolFactoryJNDI()));
                ServerSessionPoolFactory factory = (ServerSessionPoolFactory)context.lookup(this.config.getServerSessionPoolFactoryJNDI());
                TransactionAttribute trans = (TransactionAttribute)this.resolveAnnotation(method, TransactionAttribute.class);
                TransactionAttributeType txType = trans == null ? TransactionAttributeType.REQUIRED : trans.value();
                boolean bl = isNotSupportedTx = txType == TransactionAttributeType.NOT_SUPPORTED;
                if (this.getServerSessionPool.getParameterTypes().length == 9) {
                    try {
                        pool = (ServerSessionPool)this.getServerSessionPool.invoke((Object)factory, dest, connection, this.config.getMinPoolSize(), this.config.getMaxPoolSize(), this.config.getKeepAlive(), isTransacted, ack, !this.isContainerManagedTx || isNotSupportedTx, listener);
                        break block10;
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                    catch (InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                }
                try {
                    pool = (ServerSessionPool)this.getServerSessionPool.invoke((Object)factory, connection, this.config.getMinPoolSize(), this.config.getMaxPoolSize(), this.config.getKeepAlive(), isTransacted, ack, !this.isContainerManagedTx || isNotSupportedTx, listener);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
            finally {
                context.close();
            }
        }
        return pool;
    }

    protected Destination createDestination(Class type, Context ctx, String jndiName, String jndiSuffix) throws Exception {
        try {
            return (Destination)ctx.lookup(jndiName);
        }
        catch (NamingException e) {
            String methodName;
            log.warn((Object)("destination not found: " + jndiName + " reason: " + e));
            log.warn((Object)("creating a new temporary destination: " + jndiName));
            MBeanServer server = MBeanServerLocator.locateJBoss();
            if (type == Topic.class) {
                methodName = "createTopic";
            } else if (type == Queue.class) {
                methodName = "createQueue";
            } else {
                throw new IllegalArgumentException("Expected javax.jms.Queue or javax.jms.Topic: " + type);
            }
            server.invoke(new ObjectName("jboss.mq:service=DestinationManager"), methodName, new Object[]{jndiSuffix}, new String[]{"java.lang.String"});
            return (Destination)ctx.lookup(jndiName);
        }
    }

    protected String parseJndiSuffix(String jndiname, String defautSuffix) {
        int indexOfSlash;
        String jndiSuffix = "";
        jndiSuffix = jndiname != null ? ((indexOfSlash = jndiname.indexOf("/")) != -1 ? jndiname.substring(indexOfSlash + 1) : jndiname) : defautSuffix;
        return jndiSuffix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JMSProviderAdapter getJMSProviderAdapter() throws NamingException {
        InitialContext context = this.getInitialContext();
        String providerAdapterJNDI = this.config.getProviderAdapterJNDI();
        try {
            log.debug((Object)("Looking up provider adapter: " + providerAdapterJNDI));
            JMSProviderAdapter jMSProviderAdapter = (JMSProviderAdapter)context.lookup(providerAdapterJNDI);
            return jMSProviderAdapter;
        }
        finally {
            context.close();
        }
    }

    protected String getDestinationType(Context ctx, String destinationJNDI) {
        String destType = null;
        if (destinationJNDI != null) {
            try {
                Destination dest = (Destination)ctx.lookup(destinationJNDI);
                if (dest instanceof Topic) {
                    destType = DEFAULT_DESTINATION_TYPE;
                } else if (dest instanceof Queue) {
                    destType = "javax.jms.Queue";
                }
            }
            catch (NamingException ex) {
                log.debug((Object)"Could not do heristic lookup of destination ", (Throwable)ex);
            }
        }
        if (destType == null) {
            log.warn((Object)"Could not determine destination type, defaults to: javax.jms.Topic");
            destType = DEFAULT_DESTINATION_TYPE;
        }
        return destType;
    }

    private void setupDLQ(JMSProviderAdapter adapter) throws Exception {
        if (this.config.isUseDLQ()) {
            this.dlqHandler = new DLQHandler(adapter, this.config);
            this.dlqHandler.create();
        }
    }

    private void populateActivationSpec() {
        DefaultActivationSpecs defaultSpecs = (DefaultActivationSpecs)this.resolveAnnotation(DefaultActivationSpecs.class);
        if (defaultSpecs != null) {
            this.activationSpec.merge(defaultSpecs.value());
        }
        Consumer md = (Consumer)this.resolveAnnotation(Consumer.class);
        this.activationSpec.merge(md.activationConfig());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object localInvoke(Method method, Object[] args) throws Throwable {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        ThreadLocalENCFactory.push(this.enc);
        try {
            long hash = MethodHashing.calculateHash((Method)method);
            MethodInfo info = (MethodInfo)this.methodInterceptors.get(hash);
            if (info == null) {
                throw new RuntimeException("Could not resolve beanClass method from proxy call");
            }
            Interceptor[] aspects1 = info.interceptors;
            EJBContainerInvocation nextInvocation = new EJBContainerInvocation(info, aspects1);
            nextInvocation.setAdvisor((Advisor)this);
            nextInvocation.setArguments(args);
            Object object = nextInvocation.invokeNext();
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
            ThreadLocalENCFactory.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InvocationResponse dynamicInvoke(Invocation invocation) throws Throwable {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        EJBContainerInvocation newSi = null;
        ThreadLocalENCFactory.push(this.enc);
        try {
            Thread.currentThread().setContextClassLoader(this.classloader);
            MethodInvocation si = (MethodInvocation)invocation;
            MethodInfo info = (MethodInfo)this.methodInterceptors.get(si.getMethodHash());
            if (info == null) {
                throw new RuntimeException("Could not resolve beanClass method from proxy call");
            }
            Interceptor[] aspects = info.interceptors;
            newSi = new EJBContainerInvocation(info, aspects);
            newSi.setArguments(si.getArguments());
            newSi.setMetaData(si.getMetaData());
            newSi.setAdvisor((Advisor)this);
            InvocationResponse response = new InvocationResponse(newSi.invokeNext());
            response.setContextInfo(newSi.getResponseContextInfo());
            InvocationResponse invocationResponse = response;
            return invocationResponse;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
            ThreadLocalENCFactory.pop();
        }
    }

    public TimerService getTimerService() {
        return this.timerService;
    }

    public void callTimeout(Timer timer) throws Exception {
        Method timeout = this.callbackHandler.getTimeoutCallback();
        if (timeout == null) {
            throw new EJBException("No method has been annotated with @Timeout");
        }
        Object[] args = new Object[]{timer};
        try {
            this.localInvoke(timeout, args);
        }
        catch (Throwable throwable) {
            if (throwable instanceof Exception) {
                throw (Exception)throwable;
            }
            throw new RuntimeException(throwable);
        }
    }

    protected void innerStop() {
        try {
            if (this.connection != null) {
                this.connection.setExceptionListener(null);
                log.debug((Object)"unset exception listener");
            }
        }
        catch (Exception e) {
            log.error((Object)"Could not set ExceptionListener to null", (Throwable)e);
        }
        try {
            if (this.connection != null) {
                this.connection.stop();
                log.debug((Object)"connection stopped");
            }
        }
        catch (Exception e) {
            log.error((Object)"Could not stop JMS connection", (Throwable)e);
        }
    }

    public void stop() throws Exception {
        this.unregisterProducers();
        EjbTimerUtil.removeTimerService(this);
        if (this.exListener != null) {
            this.exListener.stop();
        }
        this.innerStop();
        if (this.dlqHandler != null) {
            this.dlqHandler.stop();
        }
    }

    public void destroy() throws Exception {
        try {
            for (ConnectionConsumer consumer : this.connectionConsumers.values()) {
                consumer.close();
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to close connection consumer", (Throwable)e);
        }
        try {
            for (ServerSessionPool ssp : this.serverSessionPools.values()) {
                if (!(ssp instanceof StdServerSessionPool)) continue;
                StdServerSessionPool p = (StdServerSessionPool)ssp;
                p.clear();
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to clear session pool", (Throwable)e);
        }
        if (this.connection != null) {
            try {
                this.connection.close();
                this.connection = null;
            }
            catch (Exception e) {
                log.error((Object)"Failed to close connection", (Throwable)e);
            }
        }
        try {
            if (this.dlqHandler != null) {
                this.dlqHandler.destroy();
                this.dlqHandler = null;
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to close the dlq handler", (Throwable)e);
        }
    }

    class ExceptionListenerImpl
    implements ExceptionListener {
        ConsumerContainer invoker;
        Thread currentThread;
        boolean notStoped = true;

        ExceptionListenerImpl(ConsumerContainer invoker) {
            this.invoker = invoker;
        }

        public void onException(JMSException ex) {
            this.currentThread = Thread.currentThread();
            log.warn((Object)"JMS provider failure detected: ", (Throwable)ex);
            boolean tryIt = true;
            while (tryIt && this.notStoped) {
                log.info((Object)"Trying to reconnect to JMS provider");
                try {
                    try {
                        Thread.sleep(ConsumerContainer.this.config.getReconnectInterval());
                    }
                    catch (InterruptedException ie) {
                        tryIt = false;
                        return;
                    }
                    this.invoker.innerStop();
                    this.invoker.destroy();
                    this.invoker.start();
                    tryIt = false;
                    log.info((Object)"Reconnected to JMS provider");
                }
                catch (Exception e) {
                    log.error((Object)"Reconnect failed: JMS provider failure detected:", (Throwable)e);
                }
            }
            this.currentThread = null;
        }

        void stop() {
            log.debug((Object)"Stop requested");
            this.notStoped = false;
            if (this.currentThread != null) {
                this.currentThread.interrupt();
                log.debug((Object)"Current thread interrupted");
            }
        }
    }

    class MessageListenerImpl
    implements MessageListener {
        ConsumerContainer invoker;

        MessageListenerImpl(ConsumerContainer invoker) {
            this.invoker = invoker;
        }

        public void onMessage(Message message) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("processing message: " + message));
            }
            try {
                Transaction tx = TxUtil.getTransactionManager().getTransaction();
                if (ConsumerContainer.this.config.isUseDLQ() && message.getJMSRedelivered() && ConsumerContainer.this.dlqHandler.handleRedeliveredMessage(message, tx)) {
                    return;
                }
                Invocation invocation = (Invocation)((ObjectMessage)message).getObject();
                invocation.getMetaData().addMetaData((Object)ConsumerContainer.CONSUMER_MESSAGE, (Object)ConsumerContainer.CONSUMER_MESSAGE, (Object)message, PayloadKey.TRANSIENT);
                this.invoker.dynamicInvoke(invocation);
            }
            catch (Throwable e) {
                log.error((Object)"Exception in JMSCI message listener", e);
            }
        }
    }
}

