/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.injection;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import javax.annotation.Resource;
import javax.annotation.Resources;
import javax.ejb.EJBContext;
import javax.ejb.TimerService;
import javax.naming.Context;
import javax.transaction.UserTransaction;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.dd.Injectable;
import org.jboss.ejb3.dd.MessageDestinationRef;
import org.jboss.ejb3.dd.ResourceEnvRef;
import org.jboss.ejb3.dd.ResourceRef;
import org.jboss.ejb3.injection.EJBContextFieldInjector;
import org.jboss.ejb3.injection.EJBContextMethodInjector;
import org.jboss.ejb3.injection.InjectionUtil;
import org.jboss.ejb3.injection.Injector;
import org.jboss.ejb3.injection.JndiFieldInjector;
import org.jboss.ejb3.injection.JndiMethodInjector;
import org.jboss.ejb3.injection.TimerServiceFieldInjector;
import org.jboss.ejb3.injection.TimerServiceMethodInjector;
import org.jboss.ejb3.injection.UserTransactionFieldInjector;
import org.jboss.ejb3.injection.UserTransactionMethodInjector;
import org.jboss.ejb3.interceptor.InterceptorInjector;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceHandler {
    private static final Logger log = Logger.getLogger(ResourceHandler.class);

    private static void loadXmlResourceRefs(EJBContainer container, Collection<ResourceRef> refs, Class clazz, HashMap<AccessibleObject, Injector> injectors) {
        for (ResourceRef envRef : refs) {
            if (envRef.getMappedName() == null || envRef.getMappedName().equals("")) {
                throw new RuntimeException("mapped-name is required for " + envRef.getResRefName() + " of EJB " + container.getEjbName());
            }
            container.addEncLinkRefEntry("env/" + envRef.getResRefName(), envRef.getMappedName());
            if (envRef.getInjectionTarget() == null) continue;
            AccessibleObject ao = InjectionUtil.findInjectionTarget(clazz, envRef.getInjectionTarget());
            if (ao instanceof Field) {
                injectors.put(ao, new JndiFieldInjector((Field)ao, "env/" + envRef.getResRefName(), container.getEnc()));
                continue;
            }
            injectors.put(ao, new JndiMethodInjector((Method)ao, "env/" + envRef.getResRefName(), container.getEnc()));
        }
    }

    private static void loadXmlResourceEnvRefs(EJBContainer container, Collection<ResourceEnvRef> refs, Class clazz, HashMap<AccessibleObject, Injector> injectors) {
        for (ResourceEnvRef envRef : refs) {
            if (envRef.getMappedName() == null || envRef.getMappedName().equals("")) {
                log.warn((Object)("mapped-name is required for " + envRef.getResRefName() + " of EJB " + container.getEjbName()));
            } else {
                container.addEncLinkRefEntry("env/" + envRef.getResRefName(), envRef.getMappedName());
            }
            if (envRef.getInjectionTarget() == null) continue;
            AccessibleObject ao = InjectionUtil.findInjectionTarget(clazz, envRef.getInjectionTarget());
            if (ao instanceof Field) {
                injectors.put(ao, new JndiFieldInjector((Field)ao, "env/" + envRef.getResRefName(), container.getEnc()));
                continue;
            }
            injectors.put(ao, new JndiMethodInjector((Method)ao, "env/" + envRef.getResRefName(), container.getEnc()));
        }
    }

    private static void loadXmlMessageDestinationRefs(EJBContainer container, Collection<MessageDestinationRef> refs, Class clazz, HashMap<AccessibleObject, Injector> injectors) {
        for (MessageDestinationRef envRef : refs) {
            if (envRef.getMappedName() == null || envRef.getMappedName().equals("")) {
                log.warn((Object)("mapped-name is required for " + envRef.getMessageDestinationRefName() + " of EJB " + container.getEjbName()));
            } else {
                container.addEncLinkRefEntry("env/" + envRef.getMessageDestinationRefName(), envRef.getMappedName());
            }
            if (envRef.getInjectionTarget() == null) continue;
            AccessibleObject ao = InjectionUtil.findInjectionTarget(clazz, envRef.getInjectionTarget());
            if (ao instanceof Field) {
                injectors.put(ao, new JndiFieldInjector((Field)ao, "env/" + envRef.getMessageDestinationRefName(), container.getEnc()));
                continue;
            }
            injectors.put(ao, new JndiMethodInjector((Method)ao, "env/" + envRef.getMessageDestinationRefName(), container.getEnc()));
        }
    }

    private static void loadClassRefs(EJBContainer container, Class clazz, boolean isContainer) throws Exception {
        Resources resources = (Resources)InjectionUtil.getAnnotation(Resources.class, container, clazz, isContainer);
        if (resources == null) {
            return;
        }
        for (Resource ref : resources.value()) {
            String encName = ref.name();
            if (encName == null || encName.equals("")) {
                throw new RuntimeException("JBoss requires name() for class level @Resource");
            }
            String mappedName = ref.mappedName();
            if (mappedName == null || mappedName.equals("")) {
                if (container.getEncLinkRefEntries().containsKey(encName)) continue;
                throw new RuntimeException("You did not specify a @Resource.mappedName() on " + clazz.getName() + " and there is no binding for that enc name in XML");
            }
            if (container.hasEncEntry(encName)) continue;
            container.addEncLinkRefEntry(encName, mappedName);
        }
    }

    private static void loadMethodInjectors(HashSet<String> methods, EJBContainer container, Class clazz, HashMap<AccessibleObject, Injector> injectors, Context ctx, boolean isContainer) {
        if (clazz == null || clazz.equals(Object.class)) {
            return;
        }
        for (Method method : clazz.getDeclaredMethods()) {
            String mappedName;
            String encName;
            Resource ref = (Resource)InjectionUtil.getAnnotation(Resource.class, container, method, isContainer);
            if (ref == null) continue;
            if (!Modifier.isPrivate(method.getModifiers())) {
                if (methods.contains(method.getName())) continue;
                methods.add(method.getName());
            }
            method.setAccessible(true);
            if (injectors.containsKey(method)) continue;
            if (!method.getName().startsWith("set")) {
                throw new RuntimeException("@Resource can only be used with a set method: " + method);
            }
            if (method.getParameterTypes().length != 1) {
                throw new RuntimeException("@Resource can only be used with a set method of one parameter: " + method);
            }
            Class type = method.getParameterTypes()[0];
            if (!ref.type().equals(Object.class)) {
                type = ref.type();
            }
            if (type.equals(UserTransaction.class)) {
                injectors.put(method, new UserTransactionMethodInjector(method, container));
                continue;
            }
            if (type.equals(TimerService.class)) {
                injectors.put(method, new TimerServiceMethodInjector(method, container));
                continue;
            }
            if (EJBContext.class.isAssignableFrom(type)) {
                injectors.put(method, new EJBContextMethodInjector(method));
                continue;
            }
            if (type.equals(String.class) || type.equals(Character.class) || type.equals(Byte.class) || type.equals(Short.class) || type.equals(Integer.class) || type.equals(Long.class) || type.equals(Boolean.class) || type.equals(Double.class) || type.equals(Float.class) || type.isPrimitive()) {
                encName = ref.name();
                encName = encName == null || encName.equals("") ? InjectionUtil.getEncName(method) : "env/" + encName;
                if (!container.hasEnvEntry(encName.substring(4))) continue;
                injectors.put(method, new JndiMethodInjector(method, encName, ctx));
                continue;
            }
            encName = ref.name();
            encName = encName == null || encName.equals("") ? InjectionUtil.getEncName(method) : "env/" + encName;
            if (!injectors.containsKey(method)) {
                injectors.put(method, new JndiMethodInjector(method, encName, ctx));
            }
            if ((mappedName = ref.mappedName()) == null || mappedName.equals("")) {
                if (container.getEncLinkRefEntries().containsKey(encName)) continue;
                throw new RuntimeException("You did not specify a @Resource.mappedName() on " + method + " and there is no binding for that enc name in XML");
            }
            if (container.hasEncEntry(encName)) continue;
            container.addEncLinkRefEntry(encName, mappedName);
        }
        if (clazz != null && !clazz.equals(Object.class)) {
            ResourceHandler.loadMethodInjectors(methods, container, clazz.getSuperclass(), injectors, ctx, isContainer);
        }
    }

    private static void loadFieldInjectors(EJBContainer container, Class clazz, HashMap<AccessibleObject, Injector> injectors, Context ctx, boolean isContainer) {
        if (clazz != null && !clazz.equals(Object.class)) {
            ResourceHandler.loadFieldInjectors(container, clazz.getSuperclass(), injectors, ctx, isContainer);
        }
        for (Field field : clazz.getDeclaredFields()) {
            String mappedName;
            String encName;
            Resource ref = (Resource)InjectionUtil.getAnnotation(Resource.class, container, field, isContainer);
            if (ref == null) continue;
            field.setAccessible(true);
            if (injectors.containsKey(field)) continue;
            Class type = field.getType();
            if (!ref.type().equals(Object.class)) {
                type = ref.type();
            }
            if (type.equals(UserTransaction.class)) {
                if (!isContainer) {
                    log.debug((Object)("Skipping UserTransaction for interceptor " + clazz));
                    continue;
                }
                injectors.put(field, new UserTransactionFieldInjector(field, container));
                continue;
            }
            if (type.equals(TimerService.class)) {
                if (!isContainer) {
                    log.debug((Object)("Skipping TimerService for interceptor " + clazz));
                    continue;
                }
                injectors.put(field, new TimerServiceFieldInjector(field, container));
                continue;
            }
            if (EJBContext.class.isAssignableFrom(type)) {
                injectors.put(field, new EJBContextFieldInjector(field));
                continue;
            }
            if (type.equals(String.class) || type.equals(Character.class) || type.equals(Byte.class) || type.equals(Short.class) || type.equals(Integer.class) || type.equals(Long.class) || type.equals(Boolean.class) || type.equals(Double.class) || type.equals(Float.class) || type.isPrimitive()) {
                encName = ref.name();
                encName = encName == null || encName.equals("") ? InjectionUtil.getEncName(field) : "env/" + encName;
                if (!container.hasEnvEntry(encName.substring(4))) continue;
                injectors.put(field, new JndiFieldInjector(field, encName, ctx));
                continue;
            }
            encName = ref.name();
            encName = encName == null || encName.equals("") ? InjectionUtil.getEncName(field) : "env/" + encName;
            if (!injectors.containsKey(field)) {
                injectors.put(field, new JndiFieldInjector(field, encName, ctx));
            }
            if ((mappedName = ref.mappedName()) == null || mappedName.equals("")) {
                if (container.getEncLinkRefEntries().containsKey(encName)) continue;
                throw new RuntimeException("You did not specify a @Resource.mappedName() on " + field + " and there is no binding for that enc name in XML");
            }
            if (container.hasEncEntry(encName)) continue;
            container.addEncLinkRefEntry(encName, mappedName);
        }
    }

    public static void loadInjectors(Container container) throws Exception {
        Class clazz = container.getBeanClass();
        EJBContainer ejb = (EJBContainer)container;
        ResourceHandler.loadInjectors(clazz, ejb.getXml(), ejb, ejb.getEncInjections(), true);
    }

    public static void loadInjectors(InterceptorInjector injector) throws Exception {
        ResourceHandler.loadInjectors(injector.getClazz(), injector.getXml(), (EJBContainer)injector.getContainer(), injector.getEncInjections(), false);
    }

    private static void loadInjectors(Class clazz, Injectable xml, EJBContainer ejb, HashMap<AccessibleObject, Injector> injectors, boolean isContainer) throws Exception {
        Context resourceCtx = ejb.getEnc();
        if (xml != null) {
            ResourceHandler.loadXmlResourceRefs(ejb, xml.getResourceRefs(), clazz, injectors);
            ResourceHandler.loadXmlResourceEnvRefs(ejb, xml.getResourceEnvRefs(), clazz, injectors);
            ResourceHandler.loadXmlMessageDestinationRefs(ejb, xml.getMessageDestinationRefs(), clazz, injectors);
        }
        ResourceHandler.loadClassRefs(ejb, clazz, isContainer);
        HashSet<String> visitedMethods = new HashSet<String>();
        ResourceHandler.loadMethodInjectors(visitedMethods, ejb, clazz, injectors, resourceCtx, isContainer);
        ResourceHandler.loadFieldInjectors(ejb, clazz, injectors, resourceCtx, isContainer);
    }
}

