/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.injection;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.naming.InitialContext;
import org.jboss.annotation.JndiInject;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.injection.InjectionUtil;
import org.jboss.ejb3.injection.JndiFieldInjector;
import org.jboss.ejb3.injection.JndiMethodInjector;
import org.jboss.ejb3.interceptor.InterceptorInjector;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JndiInjectHandler {
    private static final Logger log = Logger.getLogger(JndiInjectHandler.class);

    public static List loadInjectors(Container container) throws Exception {
        Class clazz = container.getBeanClass();
        return JndiInjectHandler.loadInjectors(clazz, (EJBContainer)container, true);
    }

    public static List loadInjectors(InterceptorInjector injector) throws Exception {
        return JndiInjectHandler.loadInjectors(injector.getClazz(), (EJBContainer)injector.getContainer(), false);
    }

    private static List loadInjectors(Class clazz, EJBContainer container, boolean isContainer) throws Exception {
        ArrayList list = new ArrayList();
        HashSet<String> visitedMethods = new HashSet<String>();
        JndiInjectHandler.loadMethodInjectors(visitedMethods, clazz, container, list, isContainer);
        JndiInjectHandler.loadFieldInjectors(clazz, container, list, isContainer);
        return list;
    }

    private static void loadMethodInjectors(HashSet<String> visitedMethods, Class clazz, EJBContainer container, ArrayList list, boolean isContainer) throws Exception {
        if (clazz == null || clazz.equals(Object.class)) {
            return;
        }
        Method[] methods = clazz.getDeclaredMethods();
        InitialContext ctx = container.getInitialContext();
        for (int i = 0; i < methods.length; ++i) {
            JndiInject ref = (JndiInject)InjectionUtil.getAnnotation(JndiInject.class, container, methods[i], isContainer);
            if (ref == null) continue;
            if (!Modifier.isPrivate(methods[i].getModifiers())) {
                if (visitedMethods.contains(methods[i].getName())) continue;
                visitedMethods.add(methods[i].getName());
            }
            if (!methods[i].getName().startsWith("set")) {
                throw new RuntimeException("@JndiInject can only be used with a set method: " + methods[i]);
            }
            if (methods[i].getParameterTypes().length != 1) {
                throw new RuntimeException("@JndiInject can only be used with a set method of one parameter: " + methods[i]);
            }
            String jndiName = methods[i].getName().substring(3);
            if (ref.jndiName() != null && !ref.jndiName().equals("")) {
                jndiName = ref.jndiName();
            }
            list.add(new JndiMethodInjector(methods[i], jndiName, ctx));
        }
        if (clazz != null && !clazz.equals(Object.class)) {
            JndiInjectHandler.loadMethodInjectors(visitedMethods, clazz.getSuperclass(), container, list, isContainer);
        }
    }

    private static void loadFieldInjectors(Class clazz, EJBContainer container, ArrayList list, boolean isContainer) throws Exception {
        if (clazz == null || clazz.equals(Object.class)) {
            return;
        }
        JndiInjectHandler.loadFieldInjectors(clazz.getSuperclass(), container, list, isContainer);
        Field[] fields = clazz.getDeclaredFields();
        InitialContext ctx = container.getInitialContext();
        for (int i = 0; i < fields.length; ++i) {
            JndiInject ref = (JndiInject)InjectionUtil.getAnnotation(JndiInject.class, container, fields[i], isContainer);
            if (ref == null) continue;
            String jndiName = fields[i].getName();
            if (ref.jndiName() != null && !ref.jndiName().equals("")) {
                jndiName = ref.jndiName();
            }
            list.add(new JndiFieldInjector(fields[i], jndiName, ctx));
        }
    }
}

