/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.injection;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.dd.InjectionTarget;
import org.jboss.logging.Logger;

public class InjectionUtil {
    private static final Logger log = Logger.getLogger(InjectionUtil.class);

    public static AccessibleObject findInjectionTarget(Class injectionClass, InjectionTarget target) {
        Class clazz = injectionClass;
        if (clazz == null) {
            throw new NullPointerException("clazz was null???");
        }
        System.out.println(clazz.getName());
        String targetClass = target.getTargetClass();
        String targetName = target.getTargetName();
        String className = clazz.getName();
        if (targetClass == null) {
            throw new NullPointerException("injection-target-class was null");
        }
        if (className == null) {
            throw new NullPointerException("className was null");
        }
        while (!className.equals(targetClass)) {
            if (clazz.equals(Object.class)) {
                throw new RuntimeException("invocation target class not found: " + targetClass + " of class: " + injectionClass);
            }
            clazz = clazz.getSuperclass();
        }
        for (Field field : clazz.getDeclaredFields()) {
            if (!target.getTargetName().equals(field.getName())) continue;
            return field;
        }
        for (AccessibleObject accessibleObject : clazz.getDeclaredMethods()) {
            if (!((Method)accessibleObject).getName().equals(target.getTargetName())) continue;
            return accessibleObject;
        }
        throw new RuntimeException("invocation target could not be found: " + target.getTargetClass() + "." + target.getTargetName() + " of class: " + injectionClass);
    }

    public static String getEncName(Method method) {
        String encName = method.getName().substring(3);
        encName = encName.length() > 1 ? encName.substring(0, 1).toLowerCase() + encName.substring(1) : encName.toLowerCase();
        encName = "env/" + method.getDeclaringClass().getName() + "/" + encName;
        return encName;
    }

    public static String getEncName(Field field) {
        return "env/" + field.getDeclaringClass().getName() + "/" + field.getName();
    }

    public static Object getAnnotation(Class annotation, EJBContainer container, Class annotatedClass, boolean isContainer) {
        if (isContainer) {
            return container.resolveAnnotation(annotation);
        }
        return annotatedClass.getAnnotation(annotation);
    }

    public static Object getAnnotation(Class annotation, EJBContainer container, Method method, boolean isContainer) {
        if (isContainer) {
            return container.resolveAnnotation(method, annotation);
        }
        return method.getAnnotation(annotation);
    }

    public static Object getAnnotation(Class annotation, EJBContainer container, Field field, boolean isContainer) {
        if (isContainer) {
            return container.resolveAnnotation(field, annotation);
        }
        return field.getAnnotation(annotation);
    }
}

