/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.injection;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import javax.annotation.EJB;
import javax.annotation.EJBs;
import javax.naming.Context;
import javax.naming.NameNotFoundException;
import org.jboss.annotation.IgnoreDependency;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.dd.EjbLocalRef;
import org.jboss.ejb3.dd.EjbRef;
import org.jboss.ejb3.dd.Injectable;
import org.jboss.ejb3.injection.InjectionUtil;
import org.jboss.ejb3.injection.Injector;
import org.jboss.ejb3.injection.JndiFieldInjector;
import org.jboss.ejb3.injection.JndiMethodInjector;
import org.jboss.ejb3.interceptor.InterceptorInjector;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJBHandler {
    private static final Logger log = Logger.getLogger(EJBHandler.class);

    public static void loadDependencies(Injectable xml, EJBContainer container, Class clazz, boolean isContainer) {
        if (xml != null) {
            EJBHandler.loadEjbLocalRefXmlDependencies(xml.getEjbLocalRefs(), container);
            EJBHandler.loadEjbRefXmlDependencies(xml.getEjbRefs(), container);
        }
        EJBHandler.loadClassDependencies(container, clazz, isContainer);
        HashSet<String> visitedMethods = new HashSet<String>();
        EJBHandler.loadMethodDependencies(visitedMethods, clazz, container, isContainer);
        EJBHandler.loadFieldDependencies(clazz, container, isContainer);
    }

    private static void loadEjbLocalRefXmlDependencies(Collection<EjbLocalRef> refs, EJBContainer container) {
        for (EjbLocalRef ref : refs) {
            EJBContainer refcon;
            block11: {
                if (ref.isIgnoreDependency()) {
                    container.getEjbRefDependencies().put("env/" + ref.getEjbRefName(), "env/" + ref.getEjbRefName());
                    continue;
                }
                refcon = null;
                String link = ref.getEjbLink();
                try {
                    if (ref.getLocal() == null) break block11;
                    Class<?> refClass = container.getClassloader().loadClass(ref.getLocal());
                    if (link != null && !"".equals(link)) {
                        refcon = container.getDeployment().getEjbContainer(link, refClass);
                        if (refcon == null) {
                            log.warn((Object)("unable to find <ejb-local-ref> of interface " + ref.getLocal() + " and ejbLink of " + link + " in ejb-jar.xml of " + container.getEjbName()));
                        }
                        break block11;
                    }
                    try {
                        refcon = container.getDeployment().getEjbContainer(refClass);
                        if (refcon == null) {
                            log.warn((Object)("unable to find <ejb-local-ref> of interface " + ref.getLocal() + " and ejbLink of " + link + " in ejb-jar.xml of " + container.getEjbName()));
                        }
                    }
                    catch (NameNotFoundException e) {
                        throw new RuntimeException("could not find <ejb-local-ref> by local interface " + ref.getLocal() + " only in ejb-jar.xml of " + container.getEjbName() + " " + e.getMessage());
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("could not find ejb-local-ref's local interface " + ref.getLocal() + " in ejb-jar.xml of " + container.getEjbName());
                }
            }
            if (ref.getMappedName() == null || ref.getMappedName().equals("")) {
                if (container.getEjbRefDependencies().containsKey("env/" + ref.getEjbRefName())) {
                    return;
                }
                if (refcon == null) continue;
                EJBHandler.addDependency("env/" + ref.getEjbRefName(), refcon, container);
                continue;
            }
            container.getEjbRefDependencies().put("env/" + ref.getEjbRefName(), "env/" + ref.getEjbRefName());
            if (refcon == null) continue;
            EJBHandler.addDependency(ref.getEjbRefName(), refcon, container);
        }
    }

    private static void loadEjbRefXmlDependencies(Collection<EjbRef> refs, EJBContainer container) {
        for (EjbRef ref : refs) {
            EJBContainer refcon;
            block11: {
                if (ref.isIgnoreDependency()) {
                    container.getEjbRefDependencies().put("env/" + ref.getEjbRefName(), "env/" + ref.getEjbRefName());
                    continue;
                }
                refcon = null;
                String link = ref.getEjbLink();
                try {
                    if (ref.getRemote() == null) break block11;
                    Class<?> refClass = container.getClassloader().loadClass(ref.getRemote());
                    if (link != null && !"".equals(link)) {
                        refcon = container.getDeployment().getEjbContainer(link, refClass);
                        if (refcon == null) {
                            log.warn((Object)("unable to find <ejb-ref> of interface " + ref.getRemote() + " and ejbLink of " + link + " in ejb-jar.xml of " + container.getEjbName()));
                        }
                        break block11;
                    }
                    try {
                        refcon = container.getDeployment().getEjbContainer(refClass);
                        if (refcon == null) {
                            log.warn((Object)("unable to find <ejb-ref> of interface " + ref.getRemote() + " and ejbLink of " + link + " in ejb-jar.xml of " + container.getEjbName()));
                        }
                    }
                    catch (NameNotFoundException e) {
                        log.warn((Object)("could not find <ejb-ref> by remote` interface " + ref.getRemote() + " only in ejb-jar.xml of " + container.getEjbName() + ":" + e.getMessage()));
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("could not find ejb-ref's remote interface " + ref.getRemote() + " in ejb-jar.xml of " + container.getEjbName());
                }
            }
            if (ref.getMappedName() == null || ref.getMappedName().equals("")) {
                if (container.getEjbRefDependencies().containsKey("env/" + ref.getEjbRefName())) {
                    return;
                }
                if (refcon == null) continue;
                EJBHandler.addDependency("env/" + ref.getEjbRefName(), refcon, container);
                continue;
            }
            container.getEjbRefDependencies().put("env/" + ref.getEjbRefName(), "env/" + ref.getEjbRefName());
            if (refcon == null) continue;
            EJBHandler.addDependency(ref.getEjbRefName(), refcon, container);
        }
    }

    private static void loadClassDependencies(EJBContainer container, Class clazz, boolean isContainer) {
        EJB ejb;
        EJBs resources = (EJBs)InjectionUtil.getAnnotation(EJBs.class, container, clazz, isContainer);
        if (resources != null) {
            for (EJB ref : resources.value()) {
                EJBHandler.loadRefDependency(ref, container, null);
            }
        }
        if ((ejb = (EJB)InjectionUtil.getAnnotation(EJB.class, container, clazz, isContainer)) != null) {
            EJBHandler.loadRefDependency(ejb, container, null);
        }
    }

    private static void loadRefDependency(EJB ref, EJBContainer container, AccessibleObject member) {
        String encName = ref.name();
        Class<?> memberType = null;
        if (member != null) {
            if (member instanceof Method) {
                encName = InjectionUtil.getEncName((Method)member);
                memberType = ((Method)member).getParameterTypes()[0];
            } else {
                encName = InjectionUtil.getEncName((Field)member);
                memberType = ((Field)member).getType();
            }
        } else if (encName == null || encName.equals("")) {
            throw new RuntimeException("JBoss requires name() for class level @EJB");
        }
        if (container.getEjbRefDependencies().containsKey("env/" + encName)) {
            return;
        }
        EJBContainer refContainer = EJBHandler.getEjbContainer(ref, container, memberType);
        if (refContainer != null) {
            EJBHandler.addDependency(encName, refContainer, container);
        }
    }

    public static void addDependency(String refName, EJBContainer refcon, EJBContainer container) {
        container.getEjbRefDependencies().put(refName, refName);
        container.getDependencyPolicy().addDependency(refcon.getObjectName().getCanonicalName());
    }

    private static void loadMethodDependencies(HashSet<String> visitedMethods, Class clazz, EJBContainer container, boolean isContainer) {
        if (clazz == null || clazz.equals(Object.class)) {
            return;
        }
        Method[] methods = clazz.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            EJB ref = (EJB)InjectionUtil.getAnnotation(EJB.class, container, methods[i], isContainer);
            if (ref == null || container.resolveAnnotation(methods[i], IgnoreDependency.class) != null || ref.mappedName() == null || ref.mappedName().equals("")) continue;
            if (!Modifier.isPrivate(methods[i].getModifiers())) {
                if (visitedMethods.contains(methods[i].getName())) continue;
                visitedMethods.add(methods[i].getName());
            }
            if (!methods[i].getName().startsWith("set")) {
                throw new RuntimeException("@EJB can only be used with a set method: " + methods[i]);
            }
            String encName = ref.name();
            encName = encName == null || encName.equals("") ? InjectionUtil.getEncName(methods[i]) : "env/" + encName;
            if (container.getEjbRefDependencies().containsKey(encName)) continue;
            EJBHandler.loadRefDependency(ref, container, methods[i]);
        }
        EJBHandler.loadMethodDependencies(visitedMethods, clazz.getSuperclass(), container, isContainer);
    }

    private static void loadFieldDependencies(Class clazz, EJBContainer container, boolean isContainer) {
        Field[] fields;
        if (clazz == null || clazz.equals(Object.class)) {
            return;
        }
        EJBHandler.loadFieldDependencies(clazz.getSuperclass(), container, isContainer);
        for (Field field : fields = clazz.getDeclaredFields()) {
            EJB ref = (EJB)InjectionUtil.getAnnotation(EJB.class, container, field, isContainer);
            if (ref == null || container.resolveAnnotation(field, IgnoreDependency.class) != null) continue;
            if (ref.mappedName() == null || ref.mappedName().equals("")) {
                EJBHandler.loadRefDependency(ref, container, field);
                continue;
            }
            String encName = ref.name();
            encName = encName == null || encName.equals("") ? InjectionUtil.getEncName(field) : "env/" + encName;
            if (container.getEjbRefDependencies().containsKey(encName)) continue;
            EJBHandler.loadRefDependency(ref, container, field);
        }
    }

    public static void loadInjectors(Container container) throws Exception {
        EJBContainer ejb = (EJBContainer)container;
        Class clazz = container.getBeanClass();
        EJBHandler.loadInjectors(clazz, ejb.getXml(), ejb, ejb.getEncInjections(), true);
    }

    public static void loadInjectors(InterceptorInjector injector) throws Exception {
        EJBHandler.loadInjectors(injector.getClazz(), injector.getXml(), (EJBContainer)injector.getContainer(), injector.getEncInjections(), false);
    }

    private static void loadInjectors(Class clazz, Injectable xml, EJBContainer container, HashMap<AccessibleObject, Injector> encInjections, boolean isContainer) throws Exception {
        if (xml != null) {
            EJBHandler.loadEjbLocalXml(xml.getEjbLocalRefs(), container, clazz, encInjections);
            EJBHandler.loadEjbRefXml(xml.getEjbRefs(), container, clazz, encInjections);
        }
        Context ctx = container.getEnc();
        EJBHandler.loadClassLevelEnc(clazz, container, ctx, isContainer);
        HashSet<String> visitedMethods = new HashSet<String>();
        EJBHandler.loadMethodInjectors(visitedMethods, clazz, container, encInjections, isContainer);
        EJBHandler.loadFieldInjectors(clazz, container, encInjections, isContainer);
    }

    private static void loadEjbLocalXml(Collection<EjbLocalRef> refs, EJBContainer container, Class clazz, HashMap<AccessibleObject, Injector> injectors) {
        for (EjbLocalRef ref : refs) {
            if (container.hasEncEntry("env/" + ref.getEjbRefName())) continue;
            String jndiName = ref.getMappedName();
            if (jndiName == null || jndiName.equals("")) {
                if (ref.getLocal() == null) continue;
                String link = ref.getEjbLink();
                Class<?> refClass = null;
                try {
                    refClass = container.getClassloader().loadClass(ref.getLocal());
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("could not find ejb-ref's remote interface " + ref.getLocal() + " in ejb-jar.xml of " + container.getEjbName());
                }
                if (link != null && !"".equals(link)) {
                    jndiName = container.getDeployment().getEjbJndiName(link, refClass);
                } else {
                    try {
                        jndiName = container.getDeployment().getEjbJndiName(refClass);
                    }
                    catch (NameNotFoundException e) {
                        throw new RuntimeException("could not find <ejb-ref> by remote interface " + ref.getLocal() + " only " + e.getMessage());
                    }
                }
            }
            container.addEncLinkRefEntry("env/" + ref.getEjbRefName(), jndiName);
            if (ref.getInjectionTarget() == null) continue;
            AccessibleObject ao = InjectionUtil.findInjectionTarget(clazz, ref.getInjectionTarget());
            if (ao instanceof Field) {
                injectors.put(ao, new JndiFieldInjector((Field)ao, "env/" + ref.getEjbRefName(), container.getEnc()));
                continue;
            }
            injectors.put(ao, new JndiMethodInjector((Method)ao, "env/" + ref.getEjbRefName(), container.getEnc()));
        }
    }

    private static void loadEjbRefXml(Collection<EjbRef> refs, EJBContainer container, Class clazz, HashMap<AccessibleObject, Injector> injectors) {
        for (EjbRef ref : refs) {
            if (container.hasEncEntry("env/" + ref.getEjbRefName())) continue;
            String jndiName = ref.getMappedName();
            if (jndiName == null || jndiName.equals("")) {
                if (ref.getRemote() == null) continue;
                String link = ref.getEjbLink();
                Class<?> refClass = null;
                try {
                    refClass = container.getClassloader().loadClass(ref.getRemote());
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("could not find ejb-ref's remote interface " + ref.getRemote() + " in ejb-jar.xml of " + container.getEjbName());
                }
                if (link != null && !"".equals(link)) {
                    jndiName = container.getDeployment().getEjbJndiName(link, refClass);
                } else {
                    try {
                        jndiName = container.getDeployment().getEjbJndiName(refClass);
                    }
                    catch (NameNotFoundException e) {
                        throw new RuntimeException("could not find <ejb-ref> by remote interface " + ref.getRemote() + " only " + e.getMessage());
                    }
                }
            }
            container.addEncLinkRefEntry("env/" + ref.getEjbRefName(), jndiName);
            if (ref.getInjectionTarget() == null) continue;
            AccessibleObject ao = InjectionUtil.findInjectionTarget(clazz, ref.getInjectionTarget());
            if (ao instanceof Field) {
                injectors.put(ao, new JndiFieldInjector((Field)ao, "env/" + ref.getEjbRefName(), container.getEnc()));
                continue;
            }
            injectors.put(ao, new JndiMethodInjector((Method)ao, "env/" + ref.getEjbRefName(), container.getEnc()));
        }
    }

    public static EJBContainer getEjbContainer(EJB ref, EJBContainer container, Class memberType) {
        EJBContainer rtn = null;
        if (ref.mappedName() != null && !"".equals(ref.mappedName())) {
            return null;
        }
        if (ref.beanName().equals("") && memberType == null) {
            throw new RuntimeException("For EJB " + container.getEjbName() + "not enough information for @EJB.  Please fill out the beanName and/or businessInterface attributes");
        }
        Class businessInterface = memberType;
        if (!ref.businessInterface().getName().equals(Object.class.getName())) {
            businessInterface = ref.businessInterface();
        }
        if (ref.beanName().equals("")) {
            try {
                rtn = container.getDeployment().getEjbContainer(businessInterface);
            }
            catch (NameNotFoundException e) {
                log.warn((Object)("For EJB " + container.getEjbName() + " could not find jndi binding based on interface only for @EJB(" + businessInterface.getName() + ") " + e.getMessage()));
            }
        } else {
            rtn = container.getDeployment().getEjbContainer(ref.beanName(), businessInterface);
        }
        return rtn;
    }

    public static String getJndiName(EJB ref, EJBContainer container, Class memberType) {
        String jndiName;
        if (ref.mappedName() != null && !"".equals(ref.mappedName())) {
            return ref.mappedName();
        }
        if (ref.beanName().equals("") && memberType == null) {
            throw new RuntimeException("For EJB " + container.getEjbName() + "not enough information for @EJB.  Please fill out the beanName and/or businessInterface attributes");
        }
        Class businessInterface = memberType;
        if (!ref.businessInterface().getName().equals(Object.class.getName())) {
            businessInterface = ref.businessInterface();
        }
        if (ref.beanName().equals("")) {
            try {
                jndiName = container.getDeployment().getEjbJndiName(businessInterface);
            }
            catch (NameNotFoundException e) {
                throw new RuntimeException("For EJB " + container.getEjbName() + " could not find jndi binding based on interface only for @EJB(" + businessInterface.getName() + ") " + e.getMessage());
            }
            if (jndiName == null) {
                throw new RuntimeException("For EJB " + container.getEjbName() + " could not find jndi binding based on interface only for @EJB(" + businessInterface.getName() + ")");
            }
        } else {
            jndiName = container.getDeployment().getEjbJndiName(ref.beanName(), businessInterface);
            if (jndiName == null) {
                throw new RuntimeException("For EJB " + container.getEjbName() + "could not find jndi binding based on beanName and business interface for @EJB(" + ref.beanName() + ", " + businessInterface.getName() + ")");
            }
        }
        return jndiName;
    }

    private static void loadClassLevelEnc(Class clazz, EJBContainer container, Context ctx, boolean isContainer) throws Exception {
        EJB ejbref;
        EJBs ref = (EJBs)InjectionUtil.getAnnotation(EJBs.class, container, clazz, isContainer);
        if (ref != null) {
            EJB[] ejbs;
            for (EJB ejb : ejbs = ref.value()) {
                EJBHandler.loadClassAnnotation(ejb, clazz, container);
            }
        }
        if ((ejbref = (EJB)InjectionUtil.getAnnotation(EJB.class, container, clazz, isContainer)) != null) {
            EJBHandler.loadClassAnnotation(ejbref, clazz, container);
        }
    }

    private static void loadClassAnnotation(EJB ejb, Class clazz, EJBContainer container) {
        String encName = ejb.name();
        if (encName == null || encName.equals("")) {
            throw new RuntimeException("JBoss requires the name of the @EJB in the @EJBs: " + clazz);
        }
        encName = "env/" + encName;
        if (!container.hasEncEntry(encName)) {
            String jndiName = EJBHandler.getJndiName(ejb, container, null);
            container.addEncLinkRefEntry(encName, jndiName);
        }
    }

    private static void loadMethodInjectors(HashSet<String> visitedMethods, Class clazz, EJBContainer container, HashMap<AccessibleObject, Injector> injectors, boolean isContainer) throws Exception {
        if (clazz == null || clazz.equals(Object.class)) {
            return;
        }
        Method[] methods = clazz.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            EJB ref = (EJB)InjectionUtil.getAnnotation(EJB.class, container, methods[i], isContainer);
            if (ref == null) continue;
            if (!Modifier.isPrivate(methods[i].getModifiers())) {
                if (visitedMethods.contains(methods[i].getName())) continue;
                visitedMethods.add(methods[i].getName());
            }
            if (!methods[i].getName().startsWith("set")) {
                throw new RuntimeException("@EJB can only be used with a set method: " + methods[i]);
            }
            EJBContainer ejb = container;
            String encName = ref.name();
            encName = encName == null || encName.equals("") ? InjectionUtil.getEncName(methods[i]) : "env/" + encName;
            if (!ejb.hasEncEntry(encName)) {
                String jndiName = EJBHandler.getJndiName(ref, container, methods[i].getParameterTypes()[0]);
                ejb.addEncLinkRefEntry(encName, jndiName);
            }
            if (injectors.containsKey(methods[i])) continue;
            injectors.put(methods[i], new JndiMethodInjector(methods[i], encName, container.getEnc()));
        }
        EJBHandler.loadMethodInjectors(visitedMethods, clazz.getSuperclass(), container, injectors, isContainer);
    }

    private static void loadFieldInjectors(Class clazz, EJBContainer container, HashMap<AccessibleObject, Injector> injectors, boolean isContainer) throws Exception {
        Field[] fields;
        if (clazz == null || clazz.equals(Object.class)) {
            return;
        }
        EJBHandler.loadFieldInjectors(clazz.getSuperclass(), container, injectors, isContainer);
        for (Field field : fields = clazz.getDeclaredFields()) {
            EJB ref = (EJB)InjectionUtil.getAnnotation(EJB.class, container, field, isContainer);
            if (ref == null) continue;
            EJBContainer ejb = container;
            String encName = ref.name();
            encName = encName == null || encName.equals("") ? InjectionUtil.getEncName(field) : "env/" + encName;
            if (!ejb.hasEncEntry(encName)) {
                String jndiName = EJBHandler.getJndiName(ref, container, field.getType());
                ejb.addEncLinkRefEntry(encName, jndiName);
            }
            if (injectors.containsKey(field)) continue;
            injectors.put(field, new JndiFieldInjector(field, encName, container.getEnc()));
        }
    }
}

