/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transporter;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import org.jboss.logging.Logger;
import org.jboss.remoting.CannotConnectException;
import org.jboss.remoting.Client;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.detection.Detector;
import org.jboss.remoting.detection.ServerInvokerMetadata;
import org.jboss.remoting.detection.multicast.MulticastDetector;
import org.jboss.remoting.invocation.NameBasedInvocation;
import org.jboss.remoting.network.NetworkInstance;
import org.jboss.remoting.network.NetworkRegistry;

public class TransporterClient
implements InvocationHandler,
Serializable {
    private Client remotingClient = null;
    private boolean isClustered = false;
    private String subSystem = null;
    private final Logger log = Logger.getLogger((Class)(class$org$jboss$remoting$transporter$TransporterClient == null ? (class$org$jboss$remoting$transporter$TransporterClient = TransporterClient.class$("org.jboss.remoting.transporter.TransporterClient")) : class$org$jboss$remoting$transporter$TransporterClient));
    private static MBeanServer server = null;
    private static Detector detector = null;
    private static NetworkRegistry registry = null;
    static /* synthetic */ Class class$org$jboss$remoting$transporter$TransporterClient;

    private TransporterClient(InvokerLocator locator) throws Exception {
        this.remotingClient = new Client(locator);
        this.remotingClient.connect();
    }

    private TransporterClient(InvokerLocator locator, String targetSubsystem) throws Exception {
        this(locator);
        this.isClustered = true;
        this.subSystem = targetSubsystem;
    }

    private void disconnect() {
        if (this.remotingClient != null) {
            this.remotingClient.disconnect();
        }
    }

    private static void setupDetector() throws Exception {
        server = MBeanServerFactory.createMBeanServer();
        registry = NetworkRegistry.getInstance();
        server.registerMBean(registry, new ObjectName("remoting:type=NetworkRegistry"));
        detector = new MulticastDetector();
        server.registerMBean(detector, new ObjectName("remoting:type=MulticastDetector"));
        detector.start();
    }

    public static Object createTransporterClient(String locatorURI, Class targetClass, boolean clustered) throws Exception {
        if (!clustered) {
            return TransporterClient.createTransporterClient(locatorURI, targetClass);
        }
        if (registry == null) {
            TransporterClient.setupDetector();
        }
        InvokerLocator locator = new InvokerLocator(locatorURI);
        TransporterClient client = new TransporterClient(locator, targetClass.getName());
        return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{targetClass}, (InvocationHandler)client);
    }

    public static Object createTransporterClient(String locatorURI, Class targetClass) throws Exception {
        InvokerLocator locator = new InvokerLocator(locatorURI);
        return TransporterClient.createTransporterClient(locator, targetClass);
    }

    public static Object createTransporterClient(InvokerLocator locator, Class targetClass) throws Exception {
        TransporterClient client = new TransporterClient(locator);
        return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{targetClass}, (InvocationHandler)client);
    }

    public static void destroyTransporterClient(Object transporterClient) {
        InvocationHandler handler;
        if (transporterClient instanceof Proxy) {
            handler = Proxy.getInvocationHandler(transporterClient);
            if (!(handler instanceof TransporterClient)) {
                throw new IllegalArgumentException("Object is not a transporter client.");
            }
        } else {
            throw new IllegalArgumentException("Object is not a transporter client.");
        }
        TransporterClient client = (TransporterClient)handler;
        client.disconnect();
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        String[] paramSig = this.createParamSignature(method.getParameterTypes());
        NameBasedInvocation request = new NameBasedInvocation(methodName, args, paramSig);
        Object response = null;
        boolean failOver = false;
        do {
            try {
                failOver = false;
                response = this.remotingClient.invoke(request);
            }
            catch (CannotConnectException cnc) {
                failOver = this.findAlternativeTarget();
                if (failOver) continue;
                throw cnc;
            }
            catch (InvocationTargetException itex) {
                Throwable rootEx = itex.getCause();
                throw rootEx;
            }
        } while (failOver);
        return response;
    }

    private boolean findAlternativeTarget() {
        NetworkInstance[] instances;
        boolean failover = false;
        if (registry != null && (instances = registry.getServers()) != null) {
            for (int x = 0; x < instances.length; ++x) {
                NetworkInstance netInstance = instances[x];
                ServerInvokerMetadata[] metadata = netInstance.getServerInvokers();
                for (int i = 0; i < metadata.length; ++i) {
                    ServerInvokerMetadata data = metadata[i];
                    String[] subsystems = data.getSubSystems();
                    for (int z = 0; z < subsystems.length; ++z) {
                        if (!this.subSystem.equalsIgnoreCase(subsystems[z])) continue;
                        InvokerLocator newLocator = data.getInvokerLocator();
                        if (this.remotingClient.getInvoker().getLocator().equals(newLocator)) continue;
                        try {
                            this.remotingClient = new Client(newLocator);
                            this.remotingClient.connect();
                            return true;
                        }
                        catch (Exception e) {
                            this.log.warn((Object)"Problem connecting to newly found alternate target.", (Throwable)e);
                        }
                    }
                }
            }
        }
        return failover;
    }

    private String[] createParamSignature(Class[] args) {
        if (args == null || args.length == 0) {
            return new String[0];
        }
        String[] paramSig = new String[args.length];
        for (int x = 0; x < args.length; ++x) {
            paramSig[x] = args[x].getName();
        }
        return paramSig;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

