/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.marshal.http;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.remoting.marshal.UnMarshaller;
import org.jboss.remoting.marshal.serializable.SerializableUnMarshaller;
import org.jboss.remoting.transport.web.WebUtil;

public class HTTPUnMarshaller
extends SerializableUnMarshaller {
    static final long serialVersionUID = 1085086661310576768L;
    public static final String DATATYPE = "http";
    protected final Logger log = Logger.getLogger(this.getClass());

    public Object read(InputStream inputStream, Map metadata) throws IOException, ClassNotFoundException {
        int contentLength = -1;
        String ret = null;
        int bufferSize = 1024;
        byte[] byteBuffer = new byte[bufferSize];
        ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
        if (metadata != null) {
            Object value = metadata.get("Content-Length");
            if (value == null) {
                value = metadata.get("content-length");
            }
            if (value != null) {
                List valueList;
                if (value instanceof List && (valueList = (List)value) != null && valueList.size() > 0) {
                    value = valueList.get(0);
                }
                if (value instanceof String) {
                    try {
                        contentLength = Integer.parseInt((String)value);
                    }
                    catch (NumberFormatException e) {
                        this.log.warn((Object)("Error converting Content-Length value (" + value + ") from metadata into int value."));
                    }
                } else {
                    this.log.warn((Object)"Can not get Content-Length from header for http unmarshalling.");
                }
            }
        }
        int pointer = 0;
        int amtRead = inputStream.read(byteBuffer);
        while (amtRead > 0) {
            byteOutputStream.write(byteBuffer, pointer, amtRead);
            if (amtRead < bufferSize && byteOutputStream.size() >= contentLength) break;
            amtRead = inputStream.read(byteBuffer);
        }
        byteOutputStream.flush();
        byte[] totalByteArray = byteOutputStream.toByteArray();
        if (totalByteArray.length == 0) {
            return null;
        }
        boolean isBinary = this.isBinaryData(metadata);
        boolean isError = this.isErrorReturn(metadata);
        if (isBinary || isError) {
            return super.read(new ByteArrayInputStream(totalByteArray), metadata);
        }
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(totalByteArray)));
            StringBuffer buffer = new StringBuffer();
            String str = null;
            while ((str = reader.readLine()) != null) {
                buffer.append(str);
            }
            reader.close();
            ret = buffer.toString();
        }
        catch (Exception e) {
            this.log.error((Object)"Can not unmarshall inputstream.  Tried to unmarshall as both an object and string type.", (Throwable)e);
            throw new IOException("Can not unmarshall inputstream.");
        }
        return ret;
    }

    public UnMarshaller cloneUnMarshaller() throws CloneNotSupportedException {
        HTTPUnMarshaller unmarshaller = new HTTPUnMarshaller();
        unmarshaller.setClassLoader(this.customClassLoader);
        return unmarshaller;
    }

    private boolean isErrorReturn(Map metadata) {
        int responseCode;
        Object value;
        boolean isError = false;
        if (metadata != null && (value = metadata.get("ResponseCode")) != null && value instanceof Integer && (responseCode = ((Integer)value).intValue()) > 400) {
            isError = true;
        }
        return isError;
    }

    private boolean isBinaryData(Map metadata) throws IOException {
        boolean isBinary = false;
        if (metadata != null) {
            Object value = metadata.get("Content-Type");
            if (value == null) {
                value = metadata.get("content-type");
            }
            if (value != null) {
                List valueList;
                if (value instanceof List && (valueList = (List)value) != null && valueList.size() > 0) {
                    value = valueList.get(0);
                }
                isBinary = WebUtil.isBinary((String)value);
            } else {
                throw new IOException("Can not not determine data type because content-type not specified.");
            }
        }
        return isBinary;
    }
}

