/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.util;

import java.util.LinkedList;

public class ConcurrentDispatcher {
    private int priority;
    private final LinkedList queue = new LinkedList();
    private int threadCount;
    private int maxThreadCount;
    public static int ENQUEUE_WHEN_BLOCKED = 0;
    public static int RUN_WHEN_BLOCKED = 1;
    private int blockingPolicy = ENQUEUE_WHEN_BLOCKED;

    public ConcurrentDispatcher() {
        this(5, 5);
    }

    public ConcurrentDispatcher(int priority, int maxThreadCount) {
        this.priority = priority;
        this.maxThreadCount = maxThreadCount;
    }

    public void setMaxThreadCount(int maxThreadCount) {
        this.maxThreadCount = maxThreadCount;
    }

    public int getMaxThreadCount() {
        return this.maxThreadCount;
    }

    public void dispatch(Runnable runner) {
        this.dispatch(runner, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatch(Runnable runner, boolean isLIFO) {
        isLIFO = false;
        LinkedList linkedList = this.queue;
        synchronized (linkedList) {
            if (this.threadCount < this.maxThreadCount) {
                if (isLIFO) {
                    this.queue.addFirst(runner);
                } else {
                    this.queue.addLast(runner);
                }
                Thread processor = new Thread(this + " Processor"){

                    public void run() {
                        ConcurrentDispatcher.this.processEvents();
                    }
                };
                ++this.threadCount;
                try {
                    processor.setDaemon(false);
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                try {
                    processor.setPriority(this.priority);
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                processor.start();
                return;
            }
            if (this.blockingPolicy == ENQUEUE_WHEN_BLOCKED) {
                if (isLIFO) {
                    this.queue.addFirst(runner);
                } else {
                    this.queue.addLast(runner);
                }
                return;
            }
        }
        runner.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processEvents() {
        while (true) {
            Object runner;
            LinkedList linkedList = this.queue;
            synchronized (linkedList) {
                if (this.queue.isEmpty()) {
                    --this.threadCount;
                    break;
                }
                runner = this.queue.removeFirst();
            }
            try {
                ((Runnable)runner).run();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }
}

