/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.BrowserUI;
import ch.randelshofer.quaqua.JBrowser;
import ch.randelshofer.quaqua.ViewportPainter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JViewport;
import javax.swing.plaf.ComponentUI;

public class QuaquaBrowserUI
extends BrowserUI
implements ViewportPainter {
    private static QuaquaBrowserUI instance = new QuaquaBrowserUI();
    private static JScrollBar scrollBar = new JScrollBar(1, 0, 1, 0, 1){

        public boolean isShowing() {
            return true;
        }

        protected void paintChildren(Graphics g) {
            Component[] c = this.getComponents();
            for (int i = 0; i < c.length; ++i) {
                Graphics cg = g.create(c[i].getX(), c[i].getY(), c[i].getWidth(), c[i].getHeight());
                c[i].paint(cg);
                cg.dispose();
            }
        }
    };
    private static CellRendererPane cellRendererPane = new CellRendererPane();

    public static ComponentUI createUI(JComponent c) {
        return instance;
    }

    public void paintViewport(Graphics g, JViewport c) {
        JBrowser browser = (JBrowser)c.getView();
        Dimension vs = c.getSize();
        Dimension bs = browser.getSize();
        Point p = browser.getLocation();
        g.setColor(Color.black);
        Dimension ss = scrollBar.getPreferredSize();
        if (bs.width < vs.width) {
            int fixedCellWidth = browser.getFixedCellWidth();
            try {
                scrollBar.setSize(ss.width, vs.height);
                scrollBar.doLayout();
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            for (int x = browser.getWidth() + fixedCellWidth; x < vs.width; x += fixedCellWidth + ss.width) {
                cellRendererPane.paintComponent(g, scrollBar, c, x, 0, ss.width, vs.height, false);
            }
        }
    }
}

