/*
 * Decompiled with CFR 0.152.
 */
package ome.util.tasks.admin;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Properties;
import ome.annotations.RevisionDate;
import ome.annotations.RevisionNumber;
import ome.api.IQuery;
import ome.model.IObject;
import ome.model.meta.Experimenter;
import ome.model.meta.ExperimenterGroup;
import ome.model.meta.GroupExperimenterMap;
import ome.system.ServiceFactory;
import ome.util.CBlock;
import ome.util.tasks.SimpleTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RevisionDate(value="$Date: 2007-01-24 17:23:09 +0100 (Wed, 24 Jan 2007) $")
@RevisionNumber(value="$Revision: 1208 $")
public class ListUsersAndGroupsTask
extends SimpleTask {
    public static final String OUT = "out";
    public static final String ERR = "err";

    public ListUsersAndGroupsTask(ServiceFactory sf, Properties p) {
        super(sf, p);
    }

    @Override
    public void doTask() {
        super.doTask();
        IQuery query = this.getServiceFactory().getQueryService();
        String u_format = "%s:%d:%s:%s:%s\n";
        String U = this.enumValue(Keys.users);
        PrintWriter u_pw = this.getWriter(U);
        if (u_pw != null) {
            List exps = query.findAllByQuery("select e from Experimenter e left outer join fetch e.groupExperimenterMap m left outer join fetch m.parent g", null);
            for (Experimenter e : exps) {
                u_pw.format(u_format, e.getOmeName(), e.getId(), e.getFirstName(), e.getLastName(), this.groupNames(e));
            }
            u_pw.flush();
        }
        String g_format = "%s:%d:%s:%s:%s\n";
        String G = this.enumValue(Keys.groups);
        PrintWriter g_pw = this.getWriter(G);
        if (g_pw != null) {
            List grps = query.findAllByQuery("select g from ExperimenterGroup g left outer join fetch g.groupExperimenterMap m left outer join fetch m.child e left outer join fetch g.details.owner", null);
            for (ExperimenterGroup g : grps) {
                String desc = null == g.getDescription() ? "" : g.getDescription();
                Experimenter e = g.getDetails().getOwner();
                String owner = null == e ? "null" : e.getOmeName();
                g_pw.format(g_format, g.getName(), g.getId(), desc, owner, this.userNames(g));
            }
            g_pw.flush();
        }
    }

    private PrintWriter getWriter(String name) {
        PrintWriter pw;
        if (null == name) {
            return null;
        }
        if (OUT.equals(name)) {
            pw = new PrintWriter(System.out);
        } else if (ERR.equals(name)) {
            pw = new PrintWriter(System.err);
        } else {
            File file = new File(name);
            try {
                FileWriter fw = new FileWriter(file, true);
                pw = new PrintWriter(fw);
            }
            catch (IOException e) {
                System.out.println("Cannot create file " + name);
                pw = null;
            }
        }
        return pw;
    }

    private List<String> userNames(ExperimenterGroup g) {
        return g.collectGroupExperimenterMap(new CBlock<String>(){

            @Override
            public String call(IObject object) {
                GroupExperimenterMap m = (GroupExperimenterMap)object;
                StringBuilder name = new StringBuilder(m.child().getOmeName());
                if (Boolean.TRUE.equals(m.getDefaultGroupLink())) {
                    name.append(" (=default)");
                }
                return name.toString();
            }
        });
    }

    private List<String> groupNames(Experimenter e) {
        return e.collectGroupExperimenterMap(new CBlock<String>(){

            @Override
            public String call(IObject object) {
                GroupExperimenterMap m = (GroupExperimenterMap)object;
                StringBuilder name = new StringBuilder(m.parent().getName());
                if (Boolean.TRUE.equals(m.getDefaultGroupLink())) {
                    name.append(" (=default)");
                }
                return name.toString();
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Keys {
        users,
        groups;

    }
}

