/*
 * Decompiled with CFR 0.152.
 */
package ome.util.tasks.admin;

import java.util.Properties;
import ome.annotations.RevisionDate;
import ome.annotations.RevisionNumber;
import ome.api.IAdmin;
import ome.model.meta.Experimenter;
import ome.model.meta.ExperimenterGroup;
import ome.system.ServiceFactory;
import ome.util.tasks.admin.AdminTask;

@RevisionDate(value="$Date: 2007-02-15 17:13:20 +0000 (Thu, 15 Feb 2007) $")
@RevisionNumber(value="$Revision: 1282 $")
public class AddGroupTask
extends AdminTask {
    public AddGroupTask(ServiceFactory sf, Properties p) {
        super(sf, p);
    }

    public void doTask() {
        super.doTask();
        IAdmin admin = this.getServiceFactory().getAdminService();
        ExperimenterGroup g = new ExperimenterGroup();
        g.setName(this.enumValue(Keys.name));
        g.setDescription(this.enumValue(Keys.description));
        long gid = admin.createGroup(g);
        this.getLogger().info((Object)String.format("Added group %s with id %d", g.getName(), gid));
        String leaderName = this.enumValue(Keys.leader);
        if (leaderName != null && leaderName.trim().length() > 0) {
            Experimenter e = admin.lookupExperimenter(leaderName);
            admin.setGroupOwner(new ExperimenterGroup(gid, false), e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Keys {
        name,
        description,
        leader;

    }
}

