/*
 * Decompiled with CFR 0.152.
 */
package ome.util.tasks;

import java.util.Properties;
import ome.annotations.RevisionDate;
import ome.annotations.RevisionNumber;
import ome.conditions.ApiUsageException;
import ome.system.ServiceFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@RevisionDate(value="$Date: 2007-05-30 20:03:03 +0100 (Wed, 30 May 2007) $")
@RevisionNumber(value="$Revision: 1568 $")
public abstract class Task
implements Runnable {
    private final ServiceFactory sf;
    private final Properties props;
    private final Log log = LogFactory.getLog(this.getClass());
    private boolean completedSuccessfully = false;

    protected Task(Properties properties) {
        this.sf = null;
        this.props = properties == null ? System.getProperties() : properties;
    }

    public Task(ServiceFactory serviceFactory, Properties properties) {
        if (serviceFactory == null) {
            throw new IllegalArgumentException("ServiceFactory cannot be null.");
        }
        this.sf = serviceFactory;
        this.props = properties == null ? System.getProperties() : properties;
    }

    public final ServiceFactory getServiceFactory() {
        return this.sf;
    }

    public final Properties getProperties() {
        return this.props;
    }

    public final Log getLogger() {
        return this.log;
    }

    public final boolean completedSuccessfully() {
        return this.completedSuccessfully;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        this.init();
        try {
            this.doTask();
            this.completedSuccessfully = true;
        }
        catch (RuntimeException re) {
            this.handleException(re);
        }
        finally {
            this.close();
        }
    }

    public abstract void init();

    public abstract void doTask() throws RuntimeException;

    public abstract void handleException(RuntimeException var1);

    public abstract void close();

    protected String enumValue(Enum e) {
        if (e == null) {
            throw new ApiUsageException("Enum cannot be null.");
        }
        return this.getProperties().getProperty(e.toString());
    }
}

