/*
 * Decompiled with CFR 0.152.
 */
package ome.util.tasks;

import java.lang.reflect.Constructor;
import java.util.Properties;
import ome.annotations.RevisionDate;
import ome.annotations.RevisionNumber;
import ome.system.ServiceFactory;
import ome.util.tasks.Task;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RevisionDate(value="$Date: 2007-02-15 17:13:20 +0000 (Thu, 15 Feb 2007) $")
@RevisionNumber(value="$Revision: 1282 $")
public class Configuration {
    public static final String DEFAULTPKG = "ome.util.tasks";
    final Properties properties;
    Class<Task> taskClass;

    public Configuration(Properties props) {
        if (props == null) {
            throw new IllegalArgumentException("Argument cannot be null.");
        }
        this.properties = props;
        if (this.p(Keys.task) == null) {
            throw new IllegalArgumentException("task must be provided.");
        }
        this.taskClass = this.parseTask(this.p(Keys.task), "");
        if (this.taskClass == null) {
            this.taskClass = this.parseTask(this.p(Keys.task), DEFAULTPKG);
        }
        if (this.taskClass == null) {
            throw new IllegalArgumentException("Cannot find task class for:" + this.p(Keys.task));
        }
    }

    public Properties getProperties() {
        return this.properties;
    }

    public Class<Task> getTaskClass() {
        return this.taskClass;
    }

    public ServiceFactory createServiceFactory() {
        return new ServiceFactory(this.getProperties());
    }

    public Task createTask() {
        try {
            Constructor<Task> ctor = this.getTaskClass().getConstructor(ServiceFactory.class, Properties.class);
            Task newTask = ctor.newInstance(this.createServiceFactory(), this.getProperties());
            return newTask;
        }
        catch (Exception e) {
            if (RuntimeException.class.isAssignableFrom(e.getClass())) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    protected String p(Keys key) {
        return this.properties.getProperty(key.toString());
    }

    protected Class<Task> parseTask(String task, String pkg) {
        StringBuilder fqn = new StringBuilder(64);
        if (pkg != null && pkg.length() > 0) {
            fqn.append(pkg);
            fqn.append(".");
        }
        fqn.append(task);
        try {
            return Class.forName(fqn.toString());
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Keys {
        task;

    }
}

