/*
 * Decompiled with CFR 0.152.
 */
package ome.testing;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.sql.DataSource;
import ome.testing.SqlPropertiesParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.jdbc.support.rowset.SqlRowSetMetaData;

public class OMEData {
    static final String emptyColl = "Collections may not be empty.\nYou are currently trying to run a test on an OME database\nthat does not appear to have the needed data.\n\nThere must be at least one:\nproject,dataset,image,experimenter,classification,category,category group,image annotation and dataset annotation\n\nTesting results would be unpredictable without test data.\nPlease fill your database and retry.";
    private static Log log = LogFactory.getLog(OMEData.class);
    boolean initialized = false;
    DataSource ds;
    Map properties;
    Map values = new HashMap();
    long seed;
    Random rnd;
    String[] files = new String[]{"test_data.properties"};

    public void setDataSource(DataSource dataSource) {
        this.ds = dataSource;
    }

    public OMEData() {
        this.init();
    }

    public OMEData(String[] files) {
        this.files = files;
        this.init();
    }

    void init() {
        this.properties = SqlPropertiesParser.parse(this.files);
        this.seed = new Random().nextLong();
        this.rnd = new Random(this.seed);
    }

    public void put(String propertyKey, Object value) {
        this.toCache(propertyKey, value);
    }

    public List get(String propertyKey) {
        if (this.inCache(propertyKey)) {
            return (List)this.fromCache(propertyKey);
        }
        Object obj = this.properties.get(propertyKey);
        if (obj == null) {
            return null;
        }
        if (obj instanceof List) {
            this.toCache(propertyKey, obj);
            return (List)obj;
        }
        if (obj instanceof String) {
            String sql = (String)obj;
            List result = this.runSql(sql);
            this.toCache(propertyKey, result);
            return result;
        }
        throw new RuntimeException("Error in properties. Not expecting " + obj == null ? null : obj.getClass().getName());
    }

    List getRandomNumber(List l, Number number) {
        if (number == null) {
            return null;
        }
        if (l == null || l.size() == 0) {
            log.warn((Object)emptyColl);
            return null;
        }
        ArrayList ordered = new ArrayList(l);
        ArrayList result = new ArrayList();
        while (ordered.size() > 0 && (long)result.size() < number.longValue()) {
            int choice = this.randomChoice(ordered.size());
            result.add(ordered.remove(choice));
        }
        return result;
    }

    public List getMax(String propertyKey, int maximum) {
        List l = this.get(propertyKey);
        return this.getRandomNumber(l, new Integer(maximum));
    }

    public List getPercent(String propertyKey, double percent) {
        List l = this.get(propertyKey);
        return this.getRandomNumber(l, new Double((double)l.size() * percent));
    }

    public Object getRandom(String propertyKey) {
        List l = this.get(propertyKey);
        List result = this.getRandomNumber(l, new Integer(1));
        if (result == null || result.size() < 1) {
            return null;
        }
        return result.get(0);
    }

    public Object getFirst(String propertyKey) {
        List l = this.get(propertyKey);
        if (l == null || l.size() == 0) {
            log.warn((Object)emptyColl);
            return null;
        }
        return l.get(0);
    }

    boolean inCache(String key) {
        return this.values.containsKey(key);
    }

    void toCache(String key, Object value) {
        this.values.put(key, value);
    }

    Object fromCache(String key) {
        return this.values.get(key);
    }

    List runSql(String sql) {
        JdbcTemplate jt = new JdbcTemplate(this.ds);
        SqlRowSet rows = jt.queryForRowSet(sql);
        ArrayList<Object> result = new ArrayList<Object>();
        while (rows.next()) {
            SqlRowSetMetaData meta = rows.getMetaData();
            int count = meta.getColumnCount();
            if (count > 1) {
                HashMap<String, Object> cols = new HashMap<String, Object>();
                String[] names = meta.getColumnNames();
                for (int i = 0; i < names.length; ++i) {
                    cols.put(names[i], rows.getObject(names[i]));
                }
                result.add(cols);
                continue;
            }
            result.add(rows.getObject(1));
        }
        log.debug((Object)("SQL:" + sql + "\n\nResult:" + result));
        return result;
    }

    public int randomChoice(int size) {
        double value = (double)(size - 1) * this.rnd.nextDouble();
        return new Double(value).intValue();
    }
}

