/*
 * Decompiled with CFR 0.152.
 */
package ome.parameters;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ome.conditions.ApiUsageException;
import ome.parameters.Filter;
import ome.parameters.QueryParameter;

public class Parameters
implements Serializable {
    public static final String ID = "id";
    public static final String IDS = "ids";
    public static final String CLASS = "class";
    public static final String OPTIONS = "options";
    public static final String ALGORITHM = "algorithm";
    public static final String OWNER_ID = "ownerId";
    public static final String GROUP_ID = "groupId";
    private Filter filter;
    private transient Map queryParameters = new HashMap();
    private static final long serialVersionUID = 6428983610525830551L;

    public Parameters() {
    }

    public Parameters(Filter filter) {
        this.filter = filter;
    }

    public Parameters(Parameters old) {
        if (old == null) {
            return;
        }
        this.addAll(old);
    }

    public Parameters(QueryParameter[] queryParameters) {
        this.addAll(queryParameters);
    }

    public Filter getFilter() {
        if (this.filter == null) {
            this.filter = new Filter();
        }
        return this.filter;
    }

    public QueryParameter[] queryParameters() {
        return this.queryParameters.values().toArray(new QueryParameter[this.queryParameters.size()]);
    }

    public QueryParameter get(String name) {
        return (QueryParameter)this.queryParameters.get(name);
    }

    public Set keySet() {
        return new HashSet(this.queryParameters.keySet());
    }

    public Parameters setFilter(Filter filter) {
        this.filter = filter;
        return this;
    }

    public Parameters add(QueryParameter parameter) {
        if (parameter == null) {
            throw new ApiUsageException("Parameter argument may not be null.");
        }
        this.queryParameters.put(parameter.name, parameter);
        return this;
    }

    public Parameters addAll(Parameters old) {
        if (old == null) {
            throw new ApiUsageException("Parameters argument may not be null.");
        }
        if (old.filter != null) {
            if (this.filter != null) {
                throw new ApiUsageException("Two filters not allowed during copy constructor.");
            }
            this.filter = old.filter;
        }
        return this.addAll(old.queryParameters());
    }

    public Parameters addAll(QueryParameter[] queryParameters) {
        if (queryParameters == null) {
            throw new ApiUsageException("Array of QueryParameters may not be null.");
        }
        for (int i = 0; i < queryParameters.length; ++i) {
            this.add(queryParameters[i]);
        }
        return this;
    }

    public Parameters addClass(Class klass) {
        this.addClass(CLASS, klass);
        return this;
    }

    public Parameters addClass(String name, Class value) {
        this.add(new QueryParameter(name, Class.class, value));
        return this;
    }

    public Parameters addBoolean(String name, Boolean value) {
        this.add(new QueryParameter(name, Boolean.class, value));
        return this;
    }

    public Parameters addInteger(String name, Integer value) {
        this.add(new QueryParameter(name, Integer.class, value));
        return this;
    }

    public Parameters addLong(String name, Long value) {
        this.add(new QueryParameter(name, Long.class, value));
        return this;
    }

    public Parameters addSet(String name, Set value) {
        this.add(new QueryParameter(name, Set.class, value));
        return this;
    }

    public Parameters addList(String name, List value) {
        this.add(new QueryParameter(name, List.class, value));
        return this;
    }

    public Parameters addMap(String name, Map value) {
        this.add(new QueryParameter(name, Map.class, value));
        return this;
    }

    public Parameters addString(String name, String value) {
        this.add(new QueryParameter(name, String.class, value));
        return this;
    }

    public Parameters addId(Long id) {
        this.add(new QueryParameter(ID, Long.class, id));
        return this;
    }

    public Parameters addIds(Collection ids) {
        this.add(new QueryParameter(IDS, Collection.class, ids));
        return this;
    }

    public Parameters addOptions(Map options) {
        this.addMap(OPTIONS, options);
        return this;
    }

    public Parameters addAlgorithm(String algo) {
        this.addString(ALGORITHM, algo);
        return this;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int size = s.readInt();
        this.queryParameters = new HashMap();
        for (int i = 0; i < size; ++i) {
            this.add((QueryParameter)s.readObject());
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        Set keySet = this.queryParameters.keySet();
        s.writeInt(keySet.size());
        for (String key : keySet) {
            s.writeObject(this.queryParameters.get(key));
        }
    }
}

