/*
 * Decompiled with CFR 0.152.
 */
package ome.model.uroi;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import ome.conditions.ApiUsageException;
import ome.model.IMutable;
import ome.model.IObject;
import ome.model.uroi.BoundingBox;
import ome.model.uroi.Specification;
import ome.model.uroi.USlice;
import ome.util.CBlock;
import ome.util.EmptyIterator;
import ome.util.Filter;
import ome.util.Filterable;
import ome.util.Validation;
import ome.util.Validator;

public class URoi
extends Specification
implements IMutable,
IObject,
Serializable {
    private BoundingBox box;
    private Set slices = new HashSet(0);
    public static final String OWNER_FILTER = "uroi_owner_filter";
    public static final String GROUP_FILTER = "uroi_group_filter";
    public static final String EVENT_FILTER = "uroi_event_filter";
    public static final String PERMS_FILTER = "uroi_perms_filter";
    public static final String OWNER_FILTER_SLICES = "uroi_owner_filter_SLICES";
    public static final String GROUP_FILTER_SLICES = "uroi_group_filter_SLICES";
    public static final String EVENT_FILTER_SLICES = "uroi_event_filter_SLICES";
    public static final String PERMS_FILTER_SLICES = "uroi_perms_filter_SLICES";
    private static final long serialVersionUID = 0xC00010C1L;
    public static final String BOX = "URoi_box";
    public static final String SLICES = "URoi_slices";
    public static final Set FIELDS;

    public URoi() {
    }

    public URoi(Long id) {
        this.setId(id);
        this.getDetails().setContext(this);
    }

    public URoi(Long id, boolean loaded) {
        this(id);
        if (!loaded) {
            this.unload();
        }
    }

    protected void preGetter(String field) {
        this.errorIfUnloaded();
    }

    protected void postGetter(String field) {
    }

    protected void preSetter(String field, Object value) {
        this.errorIfUnloaded();
    }

    protected void postSetter(String field, Object value) {
    }

    protected void throwNullCollectionException(String propertyName) {
        throw new ApiUsageException("Error updating collection:" + propertyName + "\n" + "Collection is currently null. This can be seen\n" + "by testing \"sizeOf" + propertyName + " < 0\". This implies\n" + "that this collection was unloaded. Please refresh this object\n" + "in order to update this collection.\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BoundingBox getBox() {
        try {
            this.preGetter(BOX);
            BoundingBox boundingBox = this.box;
            return boundingBox;
        }
        finally {
            this.postGetter(BOX);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBox(BoundingBox box) {
        try {
            this.preSetter(BOX, box);
            this.box = box;
        }
        finally {
            this.postSetter(BOX, box);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set getSlices() {
        try {
            this.preGetter(SLICES);
            Set set = this.slices;
            return set;
        }
        finally {
            this.postGetter(SLICES);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setSlices(Set slices) {
        try {
            this.preSetter(SLICES, slices);
            this.slices = slices;
        }
        finally {
            this.postSetter(SLICES, slices);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sizeOfSlices() {
        try {
            this.preGetter(SLICES);
            int n = this.slices == null ? -1 : this.slices.size();
            return n;
        }
        finally {
            this.postGetter(SLICES);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iterateSlices() {
        try {
            this.preGetter(SLICES);
            if (this.getSlices() == null) {
                EmptyIterator emptyIterator = new EmptyIterator();
                return emptyIterator;
            }
            Iterator iterator = this.getSlices().iterator();
            return iterator;
        }
        finally {
            this.postGetter(SLICES);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List collectSlices(CBlock block) {
        try {
            this.preGetter(SLICES);
            ArrayList result = new ArrayList();
            Iterator it = this.iterateSlices();
            while (it.hasNext()) {
                IObject obj = (IObject)it.next();
                if (block != null) {
                    result.add(block.call(obj));
                    continue;
                }
                result.add(obj);
            }
            ArrayList arrayList = result;
            return arrayList;
        }
        finally {
            this.postGetter(SLICES);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUSlice(USlice target) {
        try {
            this.preSetter(SLICES, target);
            if (this.getSlices() == null) {
                this.throwNullCollectionException("Slices");
            }
            this.getSlices().add(target);
            target.setUroi(this);
        }
        finally {
            this.postSetter(SLICES, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUSliceSet(Set targets) {
        try {
            this.preSetter(SLICES, targets);
            if (this.getSlices() == null) {
                this.throwNullCollectionException("Slices");
            }
            this.getSlices().addAll(targets);
            for (USlice target : targets) {
                target.setUroi(this);
            }
        }
        finally {
            this.postSetter(SLICES, targets);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUSlice(USlice target) {
        try {
            this.preSetter(SLICES, target);
            if (this.getSlices() == null) {
                this.throwNullCollectionException("Slices");
            }
            this.getSlices().remove(target);
            target.setUroi(null);
        }
        finally {
            this.postSetter(SLICES, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUSliceSet(Set targets) {
        try {
            this.preSetter(SLICES, targets);
            if (this.getSlices() == null) {
                this.throwNullCollectionException("Slices");
            }
            this.getSlices().removeAll(targets);
            for (USlice target : targets) {
                target.setUroi(null);
            }
        }
        finally {
            this.postSetter(SLICES, targets);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSlices() {
        try {
            this.preSetter(SLICES, null);
            if (this.getSlices() == null) {
                this.throwNullCollectionException("Slices");
            }
            this.getSlices().clear();
            Iterator it = this.iterateSlices();
            while (it.hasNext()) {
                USlice target = (USlice)it.next();
                target.setUroi(null);
            }
        }
        finally {
            this.postSetter(SLICES, null);
        }
    }

    public boolean isValid() {
        return Validator.validate(this).isValid();
    }

    public Validation validate() {
        return Validator.validate(this);
    }

    public Filterable newInstance() {
        return new URoi();
    }

    public boolean acceptFilter(Filter __filter) {
        this.box = (BoundingBox)__filter.filter(BOX, this.box);
        this.slices = (Set)__filter.filter(SLICES, this.slices);
        return super.acceptFilter(__filter);
    }

    public String toString() {
        return "URoi" + (this.getId() == null ? ":Hash_" + this.hashCode() : ":Id_" + this.getId());
    }

    public Set fields() {
        return FIELDS;
    }

    public Object retrieve(String field) {
        if (field == null) {
            return null;
        }
        if (field.equals(BOX)) {
            return this.getBox();
        }
        if (field.equals(SLICES)) {
            return this.getSlices();
        }
        return super.retrieve(field);
    }

    public void putAt(String field, Object value) {
        if (field == null) {
            return;
        }
        if (field.equals(BOX)) {
            this.setBox((BoundingBox)value);
        } else if (field.equals(SLICES)) {
            this.setSlices((Set)value);
        } else {
            super.putAt(field, value);
        }
    }

    public boolean isLoaded() {
        return this._loaded;
    }

    public void unload() {
        this._loaded = false;
        this.box = null;
        this.slices = null;
        super.unload();
    }

    protected void errorIfUnloaded() {
        if (!this._loaded) {
            throw new IllegalStateException("Object unloaded:" + this);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
    }

    static {
        HashSet<String> raw = new HashSet<String>();
        raw.add(BOX);
        raw.addAll(Specification.FIELDS);
        raw.add(SLICES);
        raw.addAll(Specification.FIELDS);
        FIELDS = Collections.unmodifiableSet(raw);
    }
}

