/*
 * Decompiled with CFR 0.152.
 */
package ome.model.roi;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import ome.conditions.ApiUsageException;
import ome.model.IMutable;
import ome.model.IObject;
import ome.model.internal.Details;
import ome.model.internal.GraphHolder;
import ome.model.roi.Roi5D;
import ome.model.roi.RoiMap;
import ome.util.CBlock;
import ome.util.EmptyIterator;
import ome.util.Filter;
import ome.util.Filterable;
import ome.util.Validation;
import ome.util.Validator;

public class RoiSet
implements IMutable,
IObject,
Serializable {
    private Long id;
    private Details details = new Details();
    private Integer version = new Integer(0);
    private Set roiMaps = new HashSet(0);
    private String sourceType;
    private Integer sourceId;
    public static final String OWNER_FILTER = "roiset_owner_filter";
    public static final String GROUP_FILTER = "roiset_group_filter";
    public static final String EVENT_FILTER = "roiset_event_filter";
    public static final String PERMS_FILTER = "roiset_perms_filter";
    public static final String OWNER_FILTER_ROIMAPS = "roiset_owner_filter_ROIMAPS";
    public static final String GROUP_FILTER_ROIMAPS = "roiset_group_filter_ROIMAPS";
    public static final String EVENT_FILTER_ROIMAPS = "roiset_event_filter_ROIMAPS";
    public static final String PERMS_FILTER_ROIMAPS = "roiset_perms_filter_ROIMAPS";
    private static final long serialVersionUID = 0xC00010C1L;
    public static final String ID = "RoiSet_id";
    public static final String DETAILS = "RoiSet_details";
    public static final String VERSION = "RoiSet_version";
    public static final String ROIMAPS = "RoiSet_roiMaps";
    public static final String SOURCETYPE = "RoiSet_sourceType";
    public static final String SOURCEID = "RoiSet_sourceId";
    public static final Set FIELDS;
    protected Map _dynamicFields;
    protected boolean _loaded = true;
    private transient GraphHolder _graphHolder;

    public RoiSet() {
    }

    public RoiSet(Long id) {
        this.setId(id);
        this.getDetails().setContext(this);
    }

    public RoiSet(Long id, boolean loaded) {
        this(id);
        if (!loaded) {
            this.unload();
        }
    }

    protected void preGetter(String field) {
        this.errorIfUnloaded();
    }

    protected void postGetter(String field) {
    }

    protected void preSetter(String field, Object value) {
        this.errorIfUnloaded();
    }

    protected void postSetter(String field, Object value) {
    }

    protected void throwNullCollectionException(String propertyName) {
        throw new ApiUsageException("Error updating collection:" + propertyName + "\n" + "Collection is currently null. This can be seen\n" + "by testing \"sizeOf" + propertyName + " < 0\". This implies\n" + "that this collection was unloaded. Please refresh this object\n" + "in order to update this collection.\n");
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Details getDetails() {
        try {
            this.preGetter(DETAILS);
            Details details = this.details;
            return details;
        }
        finally {
            this.postGetter(DETAILS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDetails(Details details) {
        try {
            this.preSetter(DETAILS, details);
            this.details = details;
        }
        finally {
            this.postSetter(DETAILS, details);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getVersion() {
        try {
            this.preGetter(VERSION);
            Integer n = this.version;
            return n;
        }
        finally {
            this.postGetter(VERSION);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVersion(Integer version) {
        try {
            this.preSetter(VERSION, version);
            this.version = version;
        }
        finally {
            this.postSetter(VERSION, version);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set getRoiMaps() {
        try {
            this.preGetter(ROIMAPS);
            Set set = this.roiMaps;
            return set;
        }
        finally {
            this.postGetter(ROIMAPS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setRoiMaps(Set roiMaps) {
        try {
            this.preSetter(ROIMAPS, roiMaps);
            this.roiMaps = roiMaps;
        }
        finally {
            this.postSetter(ROIMAPS, roiMaps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sizeOfRoiMaps() {
        try {
            this.preGetter(ROIMAPS);
            int n = this.roiMaps == null ? -1 : this.roiMaps.size();
            return n;
        }
        finally {
            this.postGetter(ROIMAPS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iterateRoiMaps() {
        try {
            this.preGetter(ROIMAPS);
            if (this.getRoiMaps() == null) {
                EmptyIterator emptyIterator = new EmptyIterator();
                return emptyIterator;
            }
            Iterator iterator = this.getRoiMaps().iterator();
            return iterator;
        }
        finally {
            this.postGetter(ROIMAPS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List collectRoiMaps(CBlock block) {
        try {
            this.preGetter(ROIMAPS);
            ArrayList result = new ArrayList();
            Iterator it = this.iterateRoiMaps();
            while (it.hasNext()) {
                IObject obj = (IObject)it.next();
                if (block != null) {
                    result.add(block.call(obj));
                    continue;
                }
                result.add(obj);
            }
            ArrayList arrayList = result;
            return arrayList;
        }
        finally {
            this.postGetter(ROIMAPS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void linkRoi5D(Roi5D addition) {
        try {
            this.preSetter(ROIMAPS, addition);
            RoiMap link = new RoiMap();
            link.link(this, addition);
            this.addRoiMap(link, true);
        }
        finally {
            this.postSetter(ROIMAPS, addition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRoiMap(RoiMap link, boolean bothSides) {
        try {
            this.preSetter(ROIMAPS, link);
            if (this.getRoiMaps() == null) {
                this.throwNullCollectionException("RoiMaps");
            }
            this.getRoiMaps().add(link);
            if (bothSides && link.child().isLoaded()) {
                link.child().addRoiMap(link, false);
            }
        }
        finally {
            this.postSetter(ROIMAPS, link);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator linkedRoi5DIterator() {
        try {
            this.preGetter(ROIMAPS);
            if (this.getRoiMaps() == null) {
                EmptyIterator emptyIterator = new EmptyIterator();
                return emptyIterator;
            }
            final Iterator it = this.getRoiMaps().iterator();
            Iterator iterator = new Iterator(){

                public boolean hasNext() {
                    return it == null ? false : it.hasNext();
                }

                public Object next() {
                    if (it == null) {
                        throw new NoSuchElementException("roiMaps is null; no elements.");
                    }
                    RoiMap link = (RoiMap)it.next();
                    return link.child();
                }

                public void remove() {
                    throw new UnsupportedOperationException("Cannot call remove on this iterator.");
                }
            };
            return iterator;
        }
        finally {
            this.postGetter(ROIMAPS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set findRoiMap(Roi5D target) {
        try {
            this.preGetter(ROIMAPS);
            Iterator it = this.iterateRoiMaps();
            HashSet<RoiMap> result = new HashSet<RoiMap>();
            while (it.hasNext()) {
                RoiMap link = (RoiMap)it.next();
                if (link.child() != target) continue;
                result.add(link);
            }
            HashSet<RoiMap> hashSet = result;
            return hashSet;
        }
        finally {
            this.postGetter(ROIMAPS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List linkedRoi5DList() {
        try {
            this.preGetter(ROIMAPS);
            Iterator it = this.linkedRoi5DIterator();
            ArrayList list = new ArrayList();
            while (it.hasNext()) {
                list.add(it.next());
            }
            ArrayList arrayList = list;
            return arrayList;
        }
        finally {
            this.postGetter(ROIMAPS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List eachLinkedRoi5D(CBlock block) {
        try {
            this.preGetter(ROIMAPS);
            ArrayList result = new ArrayList();
            Iterator it = this.linkedRoi5DIterator();
            while (it.hasNext()) {
                IObject obj = (IObject)it.next();
                if (block != null) {
                    result.add(block.call(obj));
                    continue;
                }
                result.add(obj);
            }
            ArrayList arrayList = result;
            return arrayList;
        }
        finally {
            this.postGetter(ROIMAPS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlinkRoi5D(Roi5D removal) {
        try {
            this.preSetter(ROIMAPS, removal);
            Set toRemove = this.findRoiMap(removal);
            Iterator it = toRemove.iterator();
            while (it.hasNext()) {
                this.removeRoiMap((RoiMap)it.next(), true);
            }
        }
        finally {
            this.postSetter(ROIMAPS, removal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRoiMap(RoiMap link, boolean bothSides) {
        try {
            this.preSetter(ROIMAPS, link);
            if (this.getRoiMaps() == null) {
                this.throwNullCollectionException("RoiMaps");
            }
            this.getRoiMaps().remove(link);
            if (bothSides && link.child().isLoaded()) {
                link.child().removeRoiMap(link, false);
            }
        }
        finally {
            this.postSetter(ROIMAPS, link);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearRoi5DLinks() {
        try {
            this.preSetter(ROIMAPS, null);
            ArrayList list = new ArrayList(this.getRoiMaps());
            for (Object object : list) {
                RoiMap link = (RoiMap)object;
                this.removeRoiMap(link, true);
            }
        }
        finally {
            this.postSetter(ROIMAPS, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSourceType() {
        try {
            this.preGetter(SOURCETYPE);
            String string = this.sourceType;
            return string;
        }
        finally {
            this.postGetter(SOURCETYPE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSourceType(String sourceType) {
        try {
            this.preSetter(SOURCETYPE, sourceType);
            this.sourceType = sourceType;
        }
        finally {
            this.postSetter(SOURCETYPE, sourceType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getSourceId() {
        try {
            this.preGetter(SOURCEID);
            Integer n = this.sourceId;
            return n;
        }
        finally {
            this.postGetter(SOURCEID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSourceId(Integer sourceId) {
        try {
            this.preSetter(SOURCEID, sourceId);
            this.sourceId = sourceId;
        }
        finally {
            this.postSetter(SOURCEID, sourceId);
        }
    }

    public boolean isValid() {
        return Validator.validate(this).isValid();
    }

    public Validation validate() {
        return Validator.validate(this);
    }

    public Filterable newInstance() {
        return new RoiSet();
    }

    public boolean acceptFilter(Filter __filter) {
        this.id = (Long)__filter.filter(ID, this.id);
        this.details = (Details)__filter.filter(DETAILS, this.details);
        this.version = (Integer)__filter.filter(VERSION, this.version);
        this.roiMaps = (Set)__filter.filter(ROIMAPS, this.roiMaps);
        this.sourceType = (String)__filter.filter(SOURCETYPE, this.sourceType);
        this.sourceId = (Integer)__filter.filter(SOURCEID, this.sourceId);
        return true;
    }

    public String toString() {
        return "RoiSet" + (this.getId() == null ? ":Hash_" + this.hashCode() : ":Id_" + this.getId());
    }

    public Set fields() {
        return FIELDS;
    }

    public Object retrieve(String field) {
        if (field == null) {
            return null;
        }
        if (field.equals(ID)) {
            return this.getId();
        }
        if (field.equals(DETAILS)) {
            return this.getDetails();
        }
        if (field.equals(VERSION)) {
            return this.getVersion();
        }
        if (field.equals(ROIMAPS)) {
            return this.getRoiMaps();
        }
        if (field.equals(SOURCETYPE)) {
            return this.getSourceType();
        }
        if (field.equals(SOURCEID)) {
            return this.getSourceId();
        }
        if (this._dynamicFields != null) {
            return this._dynamicFields.get(field);
        }
        return null;
    }

    public void putAt(String field, Object value) {
        if (field == null) {
            return;
        }
        if (field.equals(ID)) {
            this.setId((Long)value);
        } else if (field.equals(DETAILS)) {
            this.setDetails((Details)value);
        } else if (field.equals(VERSION)) {
            this.setVersion((Integer)value);
        } else if (field.equals(ROIMAPS)) {
            this.setRoiMaps((Set)value);
        } else if (field.equals(SOURCETYPE)) {
            this.setSourceType((String)value);
        } else if (field.equals(SOURCEID)) {
            this.setSourceId((Integer)value);
        } else {
            if (this._dynamicFields == null) {
                this._dynamicFields = new HashMap();
            }
            this._dynamicFields.put(field, value);
        }
    }

    public boolean isLoaded() {
        return this._loaded;
    }

    public void unload() {
        this._loaded = false;
        this.details = null;
        this.version = null;
        this.roiMaps = null;
        this.sourceType = null;
        this.sourceId = null;
    }

    protected void errorIfUnloaded() {
        if (!this._loaded) {
            throw new IllegalStateException("Object unloaded:" + this);
        }
    }

    public final GraphHolder getGraphHolder() {
        if (this._graphHolder == null) {
            this._graphHolder = new GraphHolder();
        }
        return this._graphHolder;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
    }

    static {
        HashSet<String> raw = new HashSet<String>();
        raw.add(ID);
        raw.add(DETAILS);
        raw.add(VERSION);
        raw.add(ROIMAPS);
        raw.add(SOURCETYPE);
        raw.add(SOURCEID);
        FIELDS = Collections.unmodifiableSet(raw);
    }
}

