/*
 * Decompiled with CFR 0.152.
 */
package ome.model.roi;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import ome.conditions.ApiUsageException;
import ome.model.IMutable;
import ome.model.IObject;
import ome.model.core.Pixels;
import ome.model.internal.Details;
import ome.model.internal.GraphHolder;
import ome.model.roi.RoiExtent;
import ome.model.roi.RoiMap;
import ome.model.roi.RoiSet;
import ome.util.CBlock;
import ome.util.EmptyIterator;
import ome.util.Filter;
import ome.util.Filterable;
import ome.util.Validation;
import ome.util.Validator;

public class Roi5D
implements IMutable,
IObject,
Serializable {
    private Long id;
    private Details details = new Details();
    private Integer version = new Integer(0);
    private Set roiMaps = new HashSet(0);
    private Pixels pixels;
    private Set extents = new HashSet(0);
    public static final String OWNER_FILTER = "roi5d_owner_filter";
    public static final String GROUP_FILTER = "roi5d_group_filter";
    public static final String EVENT_FILTER = "roi5d_event_filter";
    public static final String PERMS_FILTER = "roi5d_perms_filter";
    public static final String OWNER_FILTER_ROIMAPS = "roi5d_owner_filter_ROIMAPS";
    public static final String GROUP_FILTER_ROIMAPS = "roi5d_group_filter_ROIMAPS";
    public static final String EVENT_FILTER_ROIMAPS = "roi5d_event_filter_ROIMAPS";
    public static final String PERMS_FILTER_ROIMAPS = "roi5d_perms_filter_ROIMAPS";
    public static final String OWNER_FILTER_EXTENTS = "roi5d_owner_filter_EXTENTS";
    public static final String GROUP_FILTER_EXTENTS = "roi5d_group_filter_EXTENTS";
    public static final String EVENT_FILTER_EXTENTS = "roi5d_event_filter_EXTENTS";
    public static final String PERMS_FILTER_EXTENTS = "roi5d_perms_filter_EXTENTS";
    private static final long serialVersionUID = 0xC00010C1L;
    public static final String ID = "Roi5D_id";
    public static final String DETAILS = "Roi5D_details";
    public static final String VERSION = "Roi5D_version";
    public static final String ROIMAPS = "Roi5D_roiMaps";
    public static final String PIXELS = "Roi5D_pixels";
    public static final String EXTENTS = "Roi5D_extents";
    public static final Set FIELDS;
    protected Map _dynamicFields;
    protected boolean _loaded = true;
    private transient GraphHolder _graphHolder;

    public Roi5D() {
    }

    public Roi5D(Long id) {
        this.setId(id);
        this.getDetails().setContext(this);
    }

    public Roi5D(Long id, boolean loaded) {
        this(id);
        if (!loaded) {
            this.unload();
        }
    }

    protected void preGetter(String field) {
        this.errorIfUnloaded();
    }

    protected void postGetter(String field) {
    }

    protected void preSetter(String field, Object value) {
        this.errorIfUnloaded();
    }

    protected void postSetter(String field, Object value) {
    }

    protected void throwNullCollectionException(String propertyName) {
        throw new ApiUsageException("Error updating collection:" + propertyName + "\n" + "Collection is currently null. This can be seen\n" + "by testing \"sizeOf" + propertyName + " < 0\". This implies\n" + "that this collection was unloaded. Please refresh this object\n" + "in order to update this collection.\n");
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Details getDetails() {
        try {
            this.preGetter(DETAILS);
            Details details = this.details;
            return details;
        }
        finally {
            this.postGetter(DETAILS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDetails(Details details) {
        try {
            this.preSetter(DETAILS, details);
            this.details = details;
        }
        finally {
            this.postSetter(DETAILS, details);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getVersion() {
        try {
            this.preGetter(VERSION);
            Integer n = this.version;
            return n;
        }
        finally {
            this.postGetter(VERSION);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVersion(Integer version) {
        try {
            this.preSetter(VERSION, version);
            this.version = version;
        }
        finally {
            this.postSetter(VERSION, version);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set getRoiMaps() {
        try {
            this.preGetter(ROIMAPS);
            Set set = this.roiMaps;
            return set;
        }
        finally {
            this.postGetter(ROIMAPS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setRoiMaps(Set roiMaps) {
        try {
            this.preSetter(ROIMAPS, roiMaps);
            this.roiMaps = roiMaps;
        }
        finally {
            this.postSetter(ROIMAPS, roiMaps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sizeOfRoiMaps() {
        try {
            this.preGetter(ROIMAPS);
            int n = this.roiMaps == null ? -1 : this.roiMaps.size();
            return n;
        }
        finally {
            this.postGetter(ROIMAPS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iterateRoiMaps() {
        try {
            this.preGetter(ROIMAPS);
            if (this.getRoiMaps() == null) {
                EmptyIterator emptyIterator = new EmptyIterator();
                return emptyIterator;
            }
            Iterator iterator = this.getRoiMaps().iterator();
            return iterator;
        }
        finally {
            this.postGetter(ROIMAPS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List collectRoiMaps(CBlock block) {
        try {
            this.preGetter(ROIMAPS);
            ArrayList result = new ArrayList();
            Iterator it = this.iterateRoiMaps();
            while (it.hasNext()) {
                IObject obj = (IObject)it.next();
                if (block != null) {
                    result.add(block.call(obj));
                    continue;
                }
                result.add(obj);
            }
            ArrayList arrayList = result;
            return arrayList;
        }
        finally {
            this.postGetter(ROIMAPS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void linkRoiSet(RoiSet addition) {
        try {
            this.preSetter(ROIMAPS, addition);
            RoiMap link = new RoiMap();
            link.link(addition, this);
            this.addRoiMap(link, true);
        }
        finally {
            this.postSetter(ROIMAPS, addition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRoiMap(RoiMap link, boolean bothSides) {
        try {
            this.preSetter(ROIMAPS, link);
            if (this.getRoiMaps() == null) {
                this.throwNullCollectionException("RoiMaps");
            }
            this.getRoiMaps().add(link);
            if (bothSides && link.parent().isLoaded()) {
                link.parent().addRoiMap(link, false);
            }
        }
        finally {
            this.postSetter(ROIMAPS, link);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator linkedRoiSetIterator() {
        try {
            this.preGetter(ROIMAPS);
            if (this.getRoiMaps() == null) {
                EmptyIterator emptyIterator = new EmptyIterator();
                return emptyIterator;
            }
            final Iterator it = this.getRoiMaps().iterator();
            Iterator iterator = new Iterator(){

                public boolean hasNext() {
                    return it == null ? false : it.hasNext();
                }

                public Object next() {
                    if (it == null) {
                        throw new NoSuchElementException("roiMaps is null; no elements.");
                    }
                    RoiMap link = (RoiMap)it.next();
                    return link.parent();
                }

                public void remove() {
                    throw new UnsupportedOperationException("Cannot call remove on this iterator.");
                }
            };
            return iterator;
        }
        finally {
            this.postGetter(ROIMAPS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set findRoiMap(RoiSet target) {
        try {
            this.preGetter(ROIMAPS);
            Iterator it = this.iterateRoiMaps();
            HashSet<RoiMap> result = new HashSet<RoiMap>();
            while (it.hasNext()) {
                RoiMap link = (RoiMap)it.next();
                if (link.parent() != target) continue;
                result.add(link);
            }
            HashSet<RoiMap> hashSet = result;
            return hashSet;
        }
        finally {
            this.postGetter(ROIMAPS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List linkedRoiSetList() {
        try {
            this.preGetter(ROIMAPS);
            Iterator it = this.linkedRoiSetIterator();
            ArrayList list = new ArrayList();
            while (it.hasNext()) {
                list.add(it.next());
            }
            ArrayList arrayList = list;
            return arrayList;
        }
        finally {
            this.postGetter(ROIMAPS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List eachLinkedRoiSet(CBlock block) {
        try {
            this.preGetter(ROIMAPS);
            ArrayList result = new ArrayList();
            Iterator it = this.linkedRoiSetIterator();
            while (it.hasNext()) {
                IObject obj = (IObject)it.next();
                if (block != null) {
                    result.add(block.call(obj));
                    continue;
                }
                result.add(obj);
            }
            ArrayList arrayList = result;
            return arrayList;
        }
        finally {
            this.postGetter(ROIMAPS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlinkRoiSet(RoiSet removal) {
        try {
            this.preSetter(ROIMAPS, removal);
            Set toRemove = this.findRoiMap(removal);
            Iterator it = toRemove.iterator();
            while (it.hasNext()) {
                this.removeRoiMap((RoiMap)it.next(), true);
            }
        }
        finally {
            this.postSetter(ROIMAPS, removal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRoiMap(RoiMap link, boolean bothSides) {
        try {
            this.preSetter(ROIMAPS, link);
            if (this.getRoiMaps() == null) {
                this.throwNullCollectionException("RoiMaps");
            }
            this.getRoiMaps().remove(link);
            if (bothSides && link.parent().isLoaded()) {
                link.parent().removeRoiMap(link, false);
            }
        }
        finally {
            this.postSetter(ROIMAPS, link);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearRoiSetLinks() {
        try {
            this.preSetter(ROIMAPS, null);
            ArrayList list = new ArrayList(this.getRoiMaps());
            for (Object object : list) {
                RoiMap link = (RoiMap)object;
                this.removeRoiMap(link, true);
            }
        }
        finally {
            this.postSetter(ROIMAPS, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pixels getPixels() {
        try {
            this.preGetter(PIXELS);
            Pixels pixels = this.pixels;
            return pixels;
        }
        finally {
            this.postGetter(PIXELS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPixels(Pixels pixels) {
        try {
            this.preSetter(PIXELS, pixels);
            this.pixels = pixels;
        }
        finally {
            this.postSetter(PIXELS, pixels);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set getExtents() {
        try {
            this.preGetter(EXTENTS);
            Set set = this.extents;
            return set;
        }
        finally {
            this.postGetter(EXTENTS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setExtents(Set extents) {
        try {
            this.preSetter(EXTENTS, extents);
            this.extents = extents;
        }
        finally {
            this.postSetter(EXTENTS, extents);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sizeOfExtents() {
        try {
            this.preGetter(EXTENTS);
            int n = this.extents == null ? -1 : this.extents.size();
            return n;
        }
        finally {
            this.postGetter(EXTENTS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iterateExtents() {
        try {
            this.preGetter(EXTENTS);
            if (this.getExtents() == null) {
                EmptyIterator emptyIterator = new EmptyIterator();
                return emptyIterator;
            }
            Iterator iterator = this.getExtents().iterator();
            return iterator;
        }
        finally {
            this.postGetter(EXTENTS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List collectExtents(CBlock block) {
        try {
            this.preGetter(EXTENTS);
            ArrayList result = new ArrayList();
            Iterator it = this.iterateExtents();
            while (it.hasNext()) {
                IObject obj = (IObject)it.next();
                if (block != null) {
                    result.add(block.call(obj));
                    continue;
                }
                result.add(obj);
            }
            ArrayList arrayList = result;
            return arrayList;
        }
        finally {
            this.postGetter(EXTENTS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRoiExtent(RoiExtent target) {
        try {
            this.preSetter(EXTENTS, target);
            if (this.getExtents() == null) {
                this.throwNullCollectionException("Extents");
            }
            this.getExtents().add(target);
            target.setRoi5d(this);
        }
        finally {
            this.postSetter(EXTENTS, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRoiExtentSet(Set targets) {
        try {
            this.preSetter(EXTENTS, targets);
            if (this.getExtents() == null) {
                this.throwNullCollectionException("Extents");
            }
            this.getExtents().addAll(targets);
            for (RoiExtent target : targets) {
                target.setRoi5d(this);
            }
        }
        finally {
            this.postSetter(EXTENTS, targets);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRoiExtent(RoiExtent target) {
        try {
            this.preSetter(EXTENTS, target);
            if (this.getExtents() == null) {
                this.throwNullCollectionException("Extents");
            }
            this.getExtents().remove(target);
            target.setRoi5d(null);
        }
        finally {
            this.postSetter(EXTENTS, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRoiExtentSet(Set targets) {
        try {
            this.preSetter(EXTENTS, targets);
            if (this.getExtents() == null) {
                this.throwNullCollectionException("Extents");
            }
            this.getExtents().removeAll(targets);
            for (RoiExtent target : targets) {
                target.setRoi5d(null);
            }
        }
        finally {
            this.postSetter(EXTENTS, targets);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearExtents() {
        try {
            this.preSetter(EXTENTS, null);
            if (this.getExtents() == null) {
                this.throwNullCollectionException("Extents");
            }
            this.getExtents().clear();
            Iterator it = this.iterateExtents();
            while (it.hasNext()) {
                RoiExtent target = (RoiExtent)it.next();
                target.setRoi5d(null);
            }
        }
        finally {
            this.postSetter(EXTENTS, null);
        }
    }

    public boolean isValid() {
        return Validator.validate(this).isValid();
    }

    public Validation validate() {
        return Validator.validate(this);
    }

    public Filterable newInstance() {
        return new Roi5D();
    }

    public boolean acceptFilter(Filter __filter) {
        this.id = (Long)__filter.filter(ID, this.id);
        this.details = (Details)__filter.filter(DETAILS, this.details);
        this.version = (Integer)__filter.filter(VERSION, this.version);
        this.roiMaps = (Set)__filter.filter(ROIMAPS, this.roiMaps);
        this.pixels = (Pixels)__filter.filter(PIXELS, this.pixels);
        this.extents = (Set)__filter.filter(EXTENTS, this.extents);
        return true;
    }

    public String toString() {
        return "Roi5D" + (this.getId() == null ? ":Hash_" + this.hashCode() : ":Id_" + this.getId());
    }

    public Set fields() {
        return FIELDS;
    }

    public Object retrieve(String field) {
        if (field == null) {
            return null;
        }
        if (field.equals(ID)) {
            return this.getId();
        }
        if (field.equals(DETAILS)) {
            return this.getDetails();
        }
        if (field.equals(VERSION)) {
            return this.getVersion();
        }
        if (field.equals(ROIMAPS)) {
            return this.getRoiMaps();
        }
        if (field.equals(PIXELS)) {
            return this.getPixels();
        }
        if (field.equals(EXTENTS)) {
            return this.getExtents();
        }
        if (this._dynamicFields != null) {
            return this._dynamicFields.get(field);
        }
        return null;
    }

    public void putAt(String field, Object value) {
        if (field == null) {
            return;
        }
        if (field.equals(ID)) {
            this.setId((Long)value);
        } else if (field.equals(DETAILS)) {
            this.setDetails((Details)value);
        } else if (field.equals(VERSION)) {
            this.setVersion((Integer)value);
        } else if (field.equals(ROIMAPS)) {
            this.setRoiMaps((Set)value);
        } else if (field.equals(PIXELS)) {
            this.setPixels((Pixels)value);
        } else if (field.equals(EXTENTS)) {
            this.setExtents((Set)value);
        } else {
            if (this._dynamicFields == null) {
                this._dynamicFields = new HashMap();
            }
            this._dynamicFields.put(field, value);
        }
    }

    public boolean isLoaded() {
        return this._loaded;
    }

    public void unload() {
        this._loaded = false;
        this.details = null;
        this.version = null;
        this.roiMaps = null;
        this.pixels = null;
        this.extents = null;
    }

    protected void errorIfUnloaded() {
        if (!this._loaded) {
            throw new IllegalStateException("Object unloaded:" + this);
        }
    }

    public final GraphHolder getGraphHolder() {
        if (this._graphHolder == null) {
            this._graphHolder = new GraphHolder();
        }
        return this._graphHolder;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
    }

    static {
        HashSet<String> raw = new HashSet<String>();
        raw.add(ID);
        raw.add(DETAILS);
        raw.add(VERSION);
        raw.add(ROIMAPS);
        raw.add(PIXELS);
        raw.add(EXTENTS);
        FIELDS = Collections.unmodifiableSet(raw);
    }
}

