/*
 * Decompiled with CFR 0.152.
 */
package ome.model.meta;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ome.conditions.ApiUsageException;
import ome.model.IObject;
import ome.model.enums.EventType;
import ome.model.internal.Details;
import ome.model.internal.GraphHolder;
import ome.model.meta.EventLog;
import ome.model.meta.Experimenter;
import ome.model.meta.ExperimenterGroup;
import ome.util.CBlock;
import ome.util.EmptyIterator;
import ome.util.Filter;
import ome.util.Filterable;
import ome.util.Validation;
import ome.util.Validator;

public class Event
implements IObject,
Serializable {
    private Long id;
    private Details details = new Details();
    private String status;
    private Timestamp time;
    private Experimenter experimenter;
    private ExperimenterGroup experimenterGroup;
    private EventType type;
    private Event containingEvent;
    private Set logs = new HashSet(0);
    private static final long serialVersionUID = 0xC00010C1L;
    public static final String ID = "Event_id";
    public static final String DETAILS = "Event_details";
    public static final String STATUS = "Event_status";
    public static final String TIME = "Event_time";
    public static final String EXPERIMENTER = "Event_experimenter";
    public static final String EXPERIMENTERGROUP = "Event_experimenterGroup";
    public static final String TYPE = "Event_type";
    public static final String CONTAININGEVENT = "Event_containingEvent";
    public static final String LOGS = "Event_logs";
    public static final Set FIELDS;
    protected Map _dynamicFields;
    protected boolean _loaded = true;
    private transient GraphHolder _graphHolder;

    public Event() {
    }

    public Event(Long id) {
        this.setId(id);
        this.getDetails().setContext(this);
    }

    public Event(Long id, boolean loaded) {
        this(id);
        if (!loaded) {
            this.unload();
        }
    }

    protected void preGetter(String field) {
        this.errorIfUnloaded();
    }

    protected void postGetter(String field) {
    }

    protected void preSetter(String field, Object value) {
        this.errorIfUnloaded();
    }

    protected void postSetter(String field, Object value) {
    }

    protected void throwNullCollectionException(String propertyName) {
        throw new ApiUsageException("Error updating collection:" + propertyName + "\n" + "Collection is currently null. This can be seen\n" + "by testing \"sizeOf" + propertyName + " < 0\". This implies\n" + "that this collection was unloaded. Please refresh this object\n" + "in order to update this collection.\n");
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Details getDetails() {
        try {
            this.preGetter(DETAILS);
            Details details = this.details;
            return details;
        }
        finally {
            this.postGetter(DETAILS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDetails(Details details) {
        try {
            this.preSetter(DETAILS, details);
            this.details = details;
        }
        finally {
            this.postSetter(DETAILS, details);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStatus() {
        try {
            this.preGetter(STATUS);
            String string = this.status;
            return string;
        }
        finally {
            this.postGetter(STATUS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatus(String status) {
        try {
            this.preSetter(STATUS, status);
            this.status = status;
        }
        finally {
            this.postSetter(STATUS, status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp getTime() {
        try {
            this.preGetter(TIME);
            Timestamp timestamp = this.time;
            return timestamp;
        }
        finally {
            this.postGetter(TIME);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTime(Timestamp time) {
        try {
            this.preSetter(TIME, time);
            this.time = time;
        }
        finally {
            this.postSetter(TIME, time);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Experimenter getExperimenter() {
        try {
            this.preGetter(EXPERIMENTER);
            Experimenter experimenter = this.experimenter;
            return experimenter;
        }
        finally {
            this.postGetter(EXPERIMENTER);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExperimenter(Experimenter experimenter) {
        try {
            this.preSetter(EXPERIMENTER, experimenter);
            this.experimenter = experimenter;
        }
        finally {
            this.postSetter(EXPERIMENTER, experimenter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExperimenterGroup getExperimenterGroup() {
        try {
            this.preGetter(EXPERIMENTERGROUP);
            ExperimenterGroup experimenterGroup = this.experimenterGroup;
            return experimenterGroup;
        }
        finally {
            this.postGetter(EXPERIMENTERGROUP);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExperimenterGroup(ExperimenterGroup experimenterGroup) {
        try {
            this.preSetter(EXPERIMENTERGROUP, experimenterGroup);
            this.experimenterGroup = experimenterGroup;
        }
        finally {
            this.postSetter(EXPERIMENTERGROUP, experimenterGroup);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventType getType() {
        try {
            this.preGetter(TYPE);
            EventType eventType = this.type;
            return eventType;
        }
        finally {
            this.postGetter(TYPE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setType(EventType type) {
        try {
            this.preSetter(TYPE, type);
            this.type = type;
        }
        finally {
            this.postSetter(TYPE, type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Event getContainingEvent() {
        try {
            this.preGetter(CONTAININGEVENT);
            Event event = this.containingEvent;
            return event;
        }
        finally {
            this.postGetter(CONTAININGEVENT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContainingEvent(Event containingEvent) {
        try {
            this.preSetter(CONTAININGEVENT, containingEvent);
            this.containingEvent = containingEvent;
        }
        finally {
            this.postSetter(CONTAININGEVENT, containingEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set getLogs() {
        try {
            this.preGetter(LOGS);
            Set set = this.logs;
            return set;
        }
        finally {
            this.postGetter(LOGS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setLogs(Set logs) {
        try {
            this.preSetter(LOGS, logs);
            this.logs = logs;
        }
        finally {
            this.postSetter(LOGS, logs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sizeOfLogs() {
        try {
            this.preGetter(LOGS);
            int n = this.logs == null ? -1 : this.logs.size();
            return n;
        }
        finally {
            this.postGetter(LOGS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iterateLogs() {
        try {
            this.preGetter(LOGS);
            if (this.getLogs() == null) {
                EmptyIterator emptyIterator = new EmptyIterator();
                return emptyIterator;
            }
            Iterator iterator = this.getLogs().iterator();
            return iterator;
        }
        finally {
            this.postGetter(LOGS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List collectLogs(CBlock block) {
        try {
            this.preGetter(LOGS);
            ArrayList result = new ArrayList();
            Iterator it = this.iterateLogs();
            while (it.hasNext()) {
                IObject obj = (IObject)it.next();
                if (block != null) {
                    result.add(block.call(obj));
                    continue;
                }
                result.add(obj);
            }
            ArrayList arrayList = result;
            return arrayList;
        }
        finally {
            this.postGetter(LOGS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventLog(EventLog target) {
        try {
            this.preSetter(LOGS, target);
            if (this.getLogs() == null) {
                this.throwNullCollectionException("Logs");
            }
            this.getLogs().add(target);
            target.setEvent(this);
        }
        finally {
            this.postSetter(LOGS, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventLogSet(Set targets) {
        try {
            this.preSetter(LOGS, targets);
            if (this.getLogs() == null) {
                this.throwNullCollectionException("Logs");
            }
            this.getLogs().addAll(targets);
            for (EventLog target : targets) {
                target.setEvent(this);
            }
        }
        finally {
            this.postSetter(LOGS, targets);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEventLog(EventLog target) {
        try {
            this.preSetter(LOGS, target);
            if (this.getLogs() == null) {
                this.throwNullCollectionException("Logs");
            }
            this.getLogs().remove(target);
            target.setEvent(null);
        }
        finally {
            this.postSetter(LOGS, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEventLogSet(Set targets) {
        try {
            this.preSetter(LOGS, targets);
            if (this.getLogs() == null) {
                this.throwNullCollectionException("Logs");
            }
            this.getLogs().removeAll(targets);
            for (EventLog target : targets) {
                target.setEvent(null);
            }
        }
        finally {
            this.postSetter(LOGS, targets);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearLogs() {
        try {
            this.preSetter(LOGS, null);
            if (this.getLogs() == null) {
                this.throwNullCollectionException("Logs");
            }
            this.getLogs().clear();
            Iterator it = this.iterateLogs();
            while (it.hasNext()) {
                EventLog target = (EventLog)it.next();
                target.setEvent(null);
            }
        }
        finally {
            this.postSetter(LOGS, null);
        }
    }

    public boolean isValid() {
        return Validator.validate(this).isValid();
    }

    public Validation validate() {
        return Validator.validate(this);
    }

    public Filterable newInstance() {
        return new Event();
    }

    public boolean acceptFilter(Filter __filter) {
        this.id = (Long)__filter.filter(ID, this.id);
        this.details = (Details)__filter.filter(DETAILS, this.details);
        this.status = (String)__filter.filter(STATUS, this.status);
        this.time = (Timestamp)__filter.filter(TIME, this.time);
        this.experimenter = (Experimenter)__filter.filter(EXPERIMENTER, this.experimenter);
        this.experimenterGroup = (ExperimenterGroup)__filter.filter(EXPERIMENTERGROUP, this.experimenterGroup);
        this.type = (EventType)__filter.filter(TYPE, this.type);
        this.containingEvent = (Event)__filter.filter(CONTAININGEVENT, this.containingEvent);
        this.logs = (Set)__filter.filter(LOGS, this.logs);
        return true;
    }

    public String toString() {
        return "Event" + (this.getId() == null ? ":Hash_" + this.hashCode() : ":Id_" + this.getId());
    }

    public Set fields() {
        return FIELDS;
    }

    public Object retrieve(String field) {
        if (field == null) {
            return null;
        }
        if (field.equals(ID)) {
            return this.getId();
        }
        if (field.equals(DETAILS)) {
            return this.getDetails();
        }
        if (field.equals(STATUS)) {
            return this.getStatus();
        }
        if (field.equals(TIME)) {
            return this.getTime();
        }
        if (field.equals(EXPERIMENTER)) {
            return this.getExperimenter();
        }
        if (field.equals(EXPERIMENTERGROUP)) {
            return this.getExperimenterGroup();
        }
        if (field.equals(TYPE)) {
            return this.getType();
        }
        if (field.equals(CONTAININGEVENT)) {
            return this.getContainingEvent();
        }
        if (field.equals(LOGS)) {
            return this.getLogs();
        }
        if (this._dynamicFields != null) {
            return this._dynamicFields.get(field);
        }
        return null;
    }

    public void putAt(String field, Object value) {
        if (field == null) {
            return;
        }
        if (field.equals(ID)) {
            this.setId((Long)value);
        } else if (field.equals(DETAILS)) {
            this.setDetails((Details)value);
        } else if (field.equals(STATUS)) {
            this.setStatus((String)value);
        } else if (field.equals(TIME)) {
            this.setTime((Timestamp)value);
        } else if (field.equals(EXPERIMENTER)) {
            this.setExperimenter((Experimenter)value);
        } else if (field.equals(EXPERIMENTERGROUP)) {
            this.setExperimenterGroup((ExperimenterGroup)value);
        } else if (field.equals(TYPE)) {
            this.setType((EventType)value);
        } else if (field.equals(CONTAININGEVENT)) {
            this.setContainingEvent((Event)value);
        } else if (field.equals(LOGS)) {
            this.setLogs((Set)value);
        } else {
            if (this._dynamicFields == null) {
                this._dynamicFields = new HashMap();
            }
            this._dynamicFields.put(field, value);
        }
    }

    public boolean isLoaded() {
        return this._loaded;
    }

    public void unload() {
        this._loaded = false;
        this.details = null;
        this.status = null;
        this.time = null;
        this.experimenter = null;
        this.experimenterGroup = null;
        this.type = null;
        this.containingEvent = null;
        this.logs = null;
    }

    protected void errorIfUnloaded() {
        if (!this._loaded) {
            throw new IllegalStateException("Object unloaded:" + this);
        }
    }

    public final GraphHolder getGraphHolder() {
        if (this._graphHolder == null) {
            this._graphHolder = new GraphHolder();
        }
        return this._graphHolder;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
    }

    static {
        HashSet<String> raw = new HashSet<String>();
        raw.add(ID);
        raw.add(DETAILS);
        raw.add(STATUS);
        raw.add(TIME);
        raw.add(EXPERIMENTER);
        raw.add(EXPERIMENTERGROUP);
        raw.add(TYPE);
        raw.add(CONTAININGEVENT);
        raw.add(LOGS);
        FIELDS = Collections.unmodifiableSet(raw);
    }
}

