/*
 * Decompiled with CFR 0.152.
 */
package ome.model.core;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import ome.conditions.ApiUsageException;
import ome.model.IMutable;
import ome.model.IObject;
import ome.model.core.Pixels;
import ome.model.core.PixelsOriginalFileMap;
import ome.model.enums.Format;
import ome.model.internal.Details;
import ome.model.internal.GraphHolder;
import ome.util.CBlock;
import ome.util.EmptyIterator;
import ome.util.Filter;
import ome.util.Filterable;
import ome.util.Validation;
import ome.util.Validator;

public class OriginalFile
implements IMutable,
IObject,
Serializable {
    private Long id;
    private Details details = new Details();
    private Integer version = new Integer(0);
    private Set pixelsFileMaps = new HashSet(0);
    private String path;
    private String name;
    private Long size;
    private Timestamp atime;
    private Timestamp mtime;
    private Timestamp ctime;
    private String sha1;
    private Format format;
    public static final String OWNER_FILTER = "originalfile_owner_filter";
    public static final String GROUP_FILTER = "originalfile_group_filter";
    public static final String EVENT_FILTER = "originalfile_event_filter";
    public static final String PERMS_FILTER = "originalfile_perms_filter";
    public static final String OWNER_FILTER_PIXELSFILEMAPS = "originalfile_owner_filter_PIXELSFILEMAPS";
    public static final String GROUP_FILTER_PIXELSFILEMAPS = "originalfile_group_filter_PIXELSFILEMAPS";
    public static final String EVENT_FILTER_PIXELSFILEMAPS = "originalfile_event_filter_PIXELSFILEMAPS";
    public static final String PERMS_FILTER_PIXELSFILEMAPS = "originalfile_perms_filter_PIXELSFILEMAPS";
    private static final long serialVersionUID = 0xC00010C1L;
    public static final String ID = "OriginalFile_id";
    public static final String DETAILS = "OriginalFile_details";
    public static final String VERSION = "OriginalFile_version";
    public static final String PIXELSFILEMAPS = "OriginalFile_pixelsFileMaps";
    public static final String PATH = "OriginalFile_path";
    public static final String NAME = "OriginalFile_name";
    public static final String SIZE = "OriginalFile_size";
    public static final String ATIME = "OriginalFile_atime";
    public static final String MTIME = "OriginalFile_mtime";
    public static final String CTIME = "OriginalFile_ctime";
    public static final String SHA1 = "OriginalFile_sha1";
    public static final String FORMAT = "OriginalFile_format";
    public static final Set FIELDS;
    protected Map _dynamicFields;
    protected boolean _loaded = true;
    private transient GraphHolder _graphHolder;

    public OriginalFile() {
    }

    public OriginalFile(Long id) {
        this.setId(id);
        this.getDetails().setContext(this);
    }

    public OriginalFile(Long id, boolean loaded) {
        this(id);
        if (!loaded) {
            this.unload();
        }
    }

    protected void preGetter(String field) {
        this.errorIfUnloaded();
    }

    protected void postGetter(String field) {
    }

    protected void preSetter(String field, Object value) {
        this.errorIfUnloaded();
    }

    protected void postSetter(String field, Object value) {
    }

    protected void throwNullCollectionException(String propertyName) {
        throw new ApiUsageException("Error updating collection:" + propertyName + "\n" + "Collection is currently null. This can be seen\n" + "by testing \"sizeOf" + propertyName + " < 0\". This implies\n" + "that this collection was unloaded. Please refresh this object\n" + "in order to update this collection.\n");
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Details getDetails() {
        try {
            this.preGetter(DETAILS);
            Details details = this.details;
            return details;
        }
        finally {
            this.postGetter(DETAILS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDetails(Details details) {
        try {
            this.preSetter(DETAILS, details);
            this.details = details;
        }
        finally {
            this.postSetter(DETAILS, details);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getVersion() {
        try {
            this.preGetter(VERSION);
            Integer n = this.version;
            return n;
        }
        finally {
            this.postGetter(VERSION);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVersion(Integer version) {
        try {
            this.preSetter(VERSION, version);
            this.version = version;
        }
        finally {
            this.postSetter(VERSION, version);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set getPixelsFileMaps() {
        try {
            this.preGetter(PIXELSFILEMAPS);
            Set set = this.pixelsFileMaps;
            return set;
        }
        finally {
            this.postGetter(PIXELSFILEMAPS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setPixelsFileMaps(Set pixelsFileMaps) {
        try {
            this.preSetter(PIXELSFILEMAPS, pixelsFileMaps);
            this.pixelsFileMaps = pixelsFileMaps;
        }
        finally {
            this.postSetter(PIXELSFILEMAPS, pixelsFileMaps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sizeOfPixelsFileMaps() {
        try {
            this.preGetter(PIXELSFILEMAPS);
            int n = this.pixelsFileMaps == null ? -1 : this.pixelsFileMaps.size();
            return n;
        }
        finally {
            this.postGetter(PIXELSFILEMAPS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iteratePixelsFileMaps() {
        try {
            this.preGetter(PIXELSFILEMAPS);
            if (this.getPixelsFileMaps() == null) {
                EmptyIterator emptyIterator = new EmptyIterator();
                return emptyIterator;
            }
            Iterator iterator = this.getPixelsFileMaps().iterator();
            return iterator;
        }
        finally {
            this.postGetter(PIXELSFILEMAPS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List collectPixelsFileMaps(CBlock block) {
        try {
            this.preGetter(PIXELSFILEMAPS);
            ArrayList result = new ArrayList();
            Iterator it = this.iteratePixelsFileMaps();
            while (it.hasNext()) {
                IObject obj = (IObject)it.next();
                if (block != null) {
                    result.add(block.call(obj));
                    continue;
                }
                result.add(obj);
            }
            ArrayList arrayList = result;
            return arrayList;
        }
        finally {
            this.postGetter(PIXELSFILEMAPS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void linkPixels(Pixels addition) {
        try {
            this.preSetter(PIXELSFILEMAPS, addition);
            PixelsOriginalFileMap link = new PixelsOriginalFileMap();
            link.link(this, addition);
            this.addPixelsOriginalFileMap(link, true);
        }
        finally {
            this.postSetter(PIXELSFILEMAPS, addition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPixelsOriginalFileMap(PixelsOriginalFileMap link, boolean bothSides) {
        try {
            this.preSetter(PIXELSFILEMAPS, link);
            if (this.getPixelsFileMaps() == null) {
                this.throwNullCollectionException("PixelsFileMaps");
            }
            this.getPixelsFileMaps().add(link);
            if (bothSides && link.child().isLoaded()) {
                link.child().addPixelsOriginalFileMap(link, false);
            }
        }
        finally {
            this.postSetter(PIXELSFILEMAPS, link);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator linkedPixelsIterator() {
        try {
            this.preGetter(PIXELSFILEMAPS);
            if (this.getPixelsFileMaps() == null) {
                EmptyIterator emptyIterator = new EmptyIterator();
                return emptyIterator;
            }
            final Iterator it = this.getPixelsFileMaps().iterator();
            Iterator iterator = new Iterator(){

                public boolean hasNext() {
                    return it == null ? false : it.hasNext();
                }

                public Object next() {
                    if (it == null) {
                        throw new NoSuchElementException("pixelsFileMaps is null; no elements.");
                    }
                    PixelsOriginalFileMap link = (PixelsOriginalFileMap)it.next();
                    return link.child();
                }

                public void remove() {
                    throw new UnsupportedOperationException("Cannot call remove on this iterator.");
                }
            };
            return iterator;
        }
        finally {
            this.postGetter(PIXELSFILEMAPS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set findPixelsOriginalFileMap(Pixels target) {
        try {
            this.preGetter(PIXELSFILEMAPS);
            Iterator it = this.iteratePixelsFileMaps();
            HashSet<PixelsOriginalFileMap> result = new HashSet<PixelsOriginalFileMap>();
            while (it.hasNext()) {
                PixelsOriginalFileMap link = (PixelsOriginalFileMap)it.next();
                if (link.child() != target) continue;
                result.add(link);
            }
            HashSet<PixelsOriginalFileMap> hashSet = result;
            return hashSet;
        }
        finally {
            this.postGetter(PIXELSFILEMAPS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List linkedPixelsList() {
        try {
            this.preGetter(PIXELSFILEMAPS);
            Iterator it = this.linkedPixelsIterator();
            ArrayList list = new ArrayList();
            while (it.hasNext()) {
                list.add(it.next());
            }
            ArrayList arrayList = list;
            return arrayList;
        }
        finally {
            this.postGetter(PIXELSFILEMAPS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List eachLinkedPixels(CBlock block) {
        try {
            this.preGetter(PIXELSFILEMAPS);
            ArrayList result = new ArrayList();
            Iterator it = this.linkedPixelsIterator();
            while (it.hasNext()) {
                IObject obj = (IObject)it.next();
                if (block != null) {
                    result.add(block.call(obj));
                    continue;
                }
                result.add(obj);
            }
            ArrayList arrayList = result;
            return arrayList;
        }
        finally {
            this.postGetter(PIXELSFILEMAPS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlinkPixels(Pixels removal) {
        try {
            this.preSetter(PIXELSFILEMAPS, removal);
            Set toRemove = this.findPixelsOriginalFileMap(removal);
            Iterator it = toRemove.iterator();
            while (it.hasNext()) {
                this.removePixelsOriginalFileMap((PixelsOriginalFileMap)it.next(), true);
            }
        }
        finally {
            this.postSetter(PIXELSFILEMAPS, removal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePixelsOriginalFileMap(PixelsOriginalFileMap link, boolean bothSides) {
        try {
            this.preSetter(PIXELSFILEMAPS, link);
            if (this.getPixelsFileMaps() == null) {
                this.throwNullCollectionException("PixelsFileMaps");
            }
            this.getPixelsFileMaps().remove(link);
            if (bothSides && link.child().isLoaded()) {
                link.child().removePixelsOriginalFileMap(link, false);
            }
        }
        finally {
            this.postSetter(PIXELSFILEMAPS, link);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearPixelsLinks() {
        try {
            this.preSetter(PIXELSFILEMAPS, null);
            ArrayList list = new ArrayList(this.getPixelsFileMaps());
            for (Object object : list) {
                PixelsOriginalFileMap link = (PixelsOriginalFileMap)object;
                this.removePixelsOriginalFileMap(link, true);
            }
        }
        finally {
            this.postSetter(PIXELSFILEMAPS, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPath() {
        try {
            this.preGetter(PATH);
            String string = this.path;
            return string;
        }
        finally {
            this.postGetter(PATH);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPath(String path) {
        try {
            this.preSetter(PATH, path);
            this.path = path;
        }
        finally {
            this.postSetter(PATH, path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() {
        try {
            this.preGetter(NAME);
            String string = this.name;
            return string;
        }
        finally {
            this.postGetter(NAME);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String name) {
        try {
            this.preSetter(NAME, name);
            this.name = name;
        }
        finally {
            this.postSetter(NAME, name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getSize() {
        try {
            this.preGetter(SIZE);
            Long l = this.size;
            return l;
        }
        finally {
            this.postGetter(SIZE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSize(Long size) {
        try {
            this.preSetter(SIZE, size);
            this.size = size;
        }
        finally {
            this.postSetter(SIZE, size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp getAtime() {
        try {
            this.preGetter(ATIME);
            Timestamp timestamp = this.atime;
            return timestamp;
        }
        finally {
            this.postGetter(ATIME);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAtime(Timestamp atime) {
        try {
            this.preSetter(ATIME, atime);
            this.atime = atime;
        }
        finally {
            this.postSetter(ATIME, atime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp getMtime() {
        try {
            this.preGetter(MTIME);
            Timestamp timestamp = this.mtime;
            return timestamp;
        }
        finally {
            this.postGetter(MTIME);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMtime(Timestamp mtime) {
        try {
            this.preSetter(MTIME, mtime);
            this.mtime = mtime;
        }
        finally {
            this.postSetter(MTIME, mtime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp getCtime() {
        try {
            this.preGetter(CTIME);
            Timestamp timestamp = this.ctime;
            return timestamp;
        }
        finally {
            this.postGetter(CTIME);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCtime(Timestamp ctime) {
        try {
            this.preSetter(CTIME, ctime);
            this.ctime = ctime;
        }
        finally {
            this.postSetter(CTIME, ctime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSha1() {
        try {
            this.preGetter(SHA1);
            String string = this.sha1;
            return string;
        }
        finally {
            this.postGetter(SHA1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSha1(String sha1) {
        try {
            this.preSetter(SHA1, sha1);
            this.sha1 = sha1;
        }
        finally {
            this.postSetter(SHA1, sha1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Format getFormat() {
        try {
            this.preGetter(FORMAT);
            Format format = this.format;
            return format;
        }
        finally {
            this.postGetter(FORMAT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFormat(Format format) {
        try {
            this.preSetter(FORMAT, format);
            this.format = format;
        }
        finally {
            this.postSetter(FORMAT, format);
        }
    }

    public boolean isValid() {
        return Validator.validate(this).isValid();
    }

    public Validation validate() {
        return Validator.validate(this);
    }

    public Filterable newInstance() {
        return new OriginalFile();
    }

    public boolean acceptFilter(Filter __filter) {
        this.id = (Long)__filter.filter(ID, this.id);
        this.details = (Details)__filter.filter(DETAILS, this.details);
        this.version = (Integer)__filter.filter(VERSION, this.version);
        this.pixelsFileMaps = (Set)__filter.filter(PIXELSFILEMAPS, this.pixelsFileMaps);
        this.path = (String)__filter.filter(PATH, this.path);
        this.name = (String)__filter.filter(NAME, this.name);
        this.size = (Long)__filter.filter(SIZE, this.size);
        this.atime = (Timestamp)__filter.filter(ATIME, this.atime);
        this.mtime = (Timestamp)__filter.filter(MTIME, this.mtime);
        this.ctime = (Timestamp)__filter.filter(CTIME, this.ctime);
        this.sha1 = (String)__filter.filter(SHA1, this.sha1);
        this.format = (Format)__filter.filter(FORMAT, this.format);
        return true;
    }

    public String toString() {
        return "OriginalFile" + (this.getId() == null ? ":Hash_" + this.hashCode() : ":Id_" + this.getId());
    }

    public Set fields() {
        return FIELDS;
    }

    public Object retrieve(String field) {
        if (field == null) {
            return null;
        }
        if (field.equals(ID)) {
            return this.getId();
        }
        if (field.equals(DETAILS)) {
            return this.getDetails();
        }
        if (field.equals(VERSION)) {
            return this.getVersion();
        }
        if (field.equals(PIXELSFILEMAPS)) {
            return this.getPixelsFileMaps();
        }
        if (field.equals(PATH)) {
            return this.getPath();
        }
        if (field.equals(NAME)) {
            return this.getName();
        }
        if (field.equals(SIZE)) {
            return this.getSize();
        }
        if (field.equals(ATIME)) {
            return this.getAtime();
        }
        if (field.equals(MTIME)) {
            return this.getMtime();
        }
        if (field.equals(CTIME)) {
            return this.getCtime();
        }
        if (field.equals(SHA1)) {
            return this.getSha1();
        }
        if (field.equals(FORMAT)) {
            return this.getFormat();
        }
        if (this._dynamicFields != null) {
            return this._dynamicFields.get(field);
        }
        return null;
    }

    public void putAt(String field, Object value) {
        if (field == null) {
            return;
        }
        if (field.equals(ID)) {
            this.setId((Long)value);
        } else if (field.equals(DETAILS)) {
            this.setDetails((Details)value);
        } else if (field.equals(VERSION)) {
            this.setVersion((Integer)value);
        } else if (field.equals(PIXELSFILEMAPS)) {
            this.setPixelsFileMaps((Set)value);
        } else if (field.equals(PATH)) {
            this.setPath((String)value);
        } else if (field.equals(NAME)) {
            this.setName((String)value);
        } else if (field.equals(SIZE)) {
            this.setSize((Long)value);
        } else if (field.equals(ATIME)) {
            this.setAtime((Timestamp)value);
        } else if (field.equals(MTIME)) {
            this.setMtime((Timestamp)value);
        } else if (field.equals(CTIME)) {
            this.setCtime((Timestamp)value);
        } else if (field.equals(SHA1)) {
            this.setSha1((String)value);
        } else if (field.equals(FORMAT)) {
            this.setFormat((Format)value);
        } else {
            if (this._dynamicFields == null) {
                this._dynamicFields = new HashMap();
            }
            this._dynamicFields.put(field, value);
        }
    }

    public boolean isLoaded() {
        return this._loaded;
    }

    public void unload() {
        this._loaded = false;
        this.details = null;
        this.version = null;
        this.pixelsFileMaps = null;
        this.path = null;
        this.name = null;
        this.size = null;
        this.atime = null;
        this.mtime = null;
        this.ctime = null;
        this.sha1 = null;
        this.format = null;
    }

    protected void errorIfUnloaded() {
        if (!this._loaded) {
            throw new IllegalStateException("Object unloaded:" + this);
        }
    }

    public final GraphHolder getGraphHolder() {
        if (this._graphHolder == null) {
            this._graphHolder = new GraphHolder();
        }
        return this._graphHolder;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
    }

    static {
        HashSet<String> raw = new HashSet<String>();
        raw.add(ID);
        raw.add(DETAILS);
        raw.add(VERSION);
        raw.add(PIXELSFILEMAPS);
        raw.add(PATH);
        raw.add(NAME);
        raw.add(SIZE);
        raw.add(ATIME);
        raw.add(MTIME);
        raw.add(CTIME);
        raw.add(SHA1);
        raw.add(FORMAT);
        FIELDS = Collections.unmodifiableSet(raw);
    }
}

