/*
 * Decompiled with CFR 0.152.
 */
package ome.model.core;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import ome.conditions.ApiUsageException;
import ome.model.IMutable;
import ome.model.IObject;
import ome.model.acquisition.DetectorSettings;
import ome.model.acquisition.LightSettings;
import ome.model.acquisition.OTF;
import ome.model.enums.AcquisitionMode;
import ome.model.enums.ContrastMethod;
import ome.model.enums.Illumination;
import ome.model.enums.PhotometricInterpretation;
import ome.model.internal.Details;
import ome.model.internal.GraphHolder;
import ome.util.Filter;
import ome.util.Filterable;
import ome.util.Validation;
import ome.util.Validator;

public class LogicalChannel
implements IMutable,
IObject,
Serializable {
    private Long id;
    private Details details = new Details();
    private Integer version = new Integer(0);
    private String name;
    private Integer pinHoleSize;
    private Illumination illumination;
    private ContrastMethod contrastMethod;
    private Integer excitationWave;
    private Integer emissionWave;
    private String fluor;
    private Float ndFilter;
    private OTF otf;
    private DetectorSettings detectorSettings;
    private LightSettings lightSource;
    private LightSettings auxLightSource;
    private PhotometricInterpretation photometricInterpretation;
    private AcquisitionMode mode;
    private String pockelCellSetting;
    public static final String OWNER_FILTER = "logicalchannel_owner_filter";
    public static final String GROUP_FILTER = "logicalchannel_group_filter";
    public static final String EVENT_FILTER = "logicalchannel_event_filter";
    public static final String PERMS_FILTER = "logicalchannel_perms_filter";
    private static final long serialVersionUID = 0xC00010C1L;
    public static final String ID = "LogicalChannel_id";
    public static final String DETAILS = "LogicalChannel_details";
    public static final String VERSION = "LogicalChannel_version";
    public static final String NAME = "LogicalChannel_name";
    public static final String PINHOLESIZE = "LogicalChannel_pinHoleSize";
    public static final String ILLUMINATION = "LogicalChannel_illumination";
    public static final String CONTRASTMETHOD = "LogicalChannel_contrastMethod";
    public static final String EXCITATIONWAVE = "LogicalChannel_excitationWave";
    public static final String EMISSIONWAVE = "LogicalChannel_emissionWave";
    public static final String FLUOR = "LogicalChannel_fluor";
    public static final String NDFILTER = "LogicalChannel_ndFilter";
    public static final String OTF = "LogicalChannel_otf";
    public static final String DETECTORSETTINGS = "LogicalChannel_detectorSettings";
    public static final String LIGHTSOURCE = "LogicalChannel_lightSource";
    public static final String AUXLIGHTSOURCE = "LogicalChannel_auxLightSource";
    public static final String PHOTOMETRICINTERPRETATION = "LogicalChannel_photometricInterpretation";
    public static final String MODE = "LogicalChannel_mode";
    public static final String POCKELCELLSETTING = "LogicalChannel_pockelCellSetting";
    public static final Set FIELDS;
    protected Map _dynamicFields;
    protected boolean _loaded = true;
    private transient GraphHolder _graphHolder;

    public LogicalChannel() {
    }

    public LogicalChannel(Long id) {
        this.setId(id);
        this.getDetails().setContext(this);
    }

    public LogicalChannel(Long id, boolean loaded) {
        this(id);
        if (!loaded) {
            this.unload();
        }
    }

    protected void preGetter(String field) {
        this.errorIfUnloaded();
    }

    protected void postGetter(String field) {
    }

    protected void preSetter(String field, Object value) {
        this.errorIfUnloaded();
    }

    protected void postSetter(String field, Object value) {
    }

    protected void throwNullCollectionException(String propertyName) {
        throw new ApiUsageException("Error updating collection:" + propertyName + "\n" + "Collection is currently null. This can be seen\n" + "by testing \"sizeOf" + propertyName + " < 0\". This implies\n" + "that this collection was unloaded. Please refresh this object\n" + "in order to update this collection.\n");
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Details getDetails() {
        try {
            this.preGetter(DETAILS);
            Details details = this.details;
            return details;
        }
        finally {
            this.postGetter(DETAILS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDetails(Details details) {
        try {
            this.preSetter(DETAILS, details);
            this.details = details;
        }
        finally {
            this.postSetter(DETAILS, details);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getVersion() {
        try {
            this.preGetter(VERSION);
            Integer n = this.version;
            return n;
        }
        finally {
            this.postGetter(VERSION);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVersion(Integer version) {
        try {
            this.preSetter(VERSION, version);
            this.version = version;
        }
        finally {
            this.postSetter(VERSION, version);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() {
        try {
            this.preGetter(NAME);
            String string = this.name;
            return string;
        }
        finally {
            this.postGetter(NAME);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String name) {
        try {
            this.preSetter(NAME, name);
            this.name = name;
        }
        finally {
            this.postSetter(NAME, name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getPinHoleSize() {
        try {
            this.preGetter(PINHOLESIZE);
            Integer n = this.pinHoleSize;
            return n;
        }
        finally {
            this.postGetter(PINHOLESIZE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPinHoleSize(Integer pinHoleSize) {
        try {
            this.preSetter(PINHOLESIZE, pinHoleSize);
            this.pinHoleSize = pinHoleSize;
        }
        finally {
            this.postSetter(PINHOLESIZE, pinHoleSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Illumination getIllumination() {
        try {
            this.preGetter(ILLUMINATION);
            Illumination illumination = this.illumination;
            return illumination;
        }
        finally {
            this.postGetter(ILLUMINATION);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIllumination(Illumination illumination) {
        try {
            this.preSetter(ILLUMINATION, illumination);
            this.illumination = illumination;
        }
        finally {
            this.postSetter(ILLUMINATION, illumination);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContrastMethod getContrastMethod() {
        try {
            this.preGetter(CONTRASTMETHOD);
            ContrastMethod contrastMethod = this.contrastMethod;
            return contrastMethod;
        }
        finally {
            this.postGetter(CONTRASTMETHOD);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContrastMethod(ContrastMethod contrastMethod) {
        try {
            this.preSetter(CONTRASTMETHOD, contrastMethod);
            this.contrastMethod = contrastMethod;
        }
        finally {
            this.postSetter(CONTRASTMETHOD, contrastMethod);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getExcitationWave() {
        try {
            this.preGetter(EXCITATIONWAVE);
            Integer n = this.excitationWave;
            return n;
        }
        finally {
            this.postGetter(EXCITATIONWAVE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExcitationWave(Integer excitationWave) {
        try {
            this.preSetter(EXCITATIONWAVE, excitationWave);
            this.excitationWave = excitationWave;
        }
        finally {
            this.postSetter(EXCITATIONWAVE, excitationWave);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getEmissionWave() {
        try {
            this.preGetter(EMISSIONWAVE);
            Integer n = this.emissionWave;
            return n;
        }
        finally {
            this.postGetter(EMISSIONWAVE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEmissionWave(Integer emissionWave) {
        try {
            this.preSetter(EMISSIONWAVE, emissionWave);
            this.emissionWave = emissionWave;
        }
        finally {
            this.postSetter(EMISSIONWAVE, emissionWave);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFluor() {
        try {
            this.preGetter(FLUOR);
            String string = this.fluor;
            return string;
        }
        finally {
            this.postGetter(FLUOR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFluor(String fluor) {
        try {
            this.preSetter(FLUOR, fluor);
            this.fluor = fluor;
        }
        finally {
            this.postSetter(FLUOR, fluor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Float getNdFilter() {
        try {
            this.preGetter(NDFILTER);
            Float f = this.ndFilter;
            return f;
        }
        finally {
            this.postGetter(NDFILTER);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNdFilter(Float ndFilter) {
        try {
            this.preSetter(NDFILTER, ndFilter);
            this.ndFilter = ndFilter;
        }
        finally {
            this.postSetter(NDFILTER, ndFilter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OTF getOtf() {
        try {
            this.preGetter(OTF);
            OTF oTF = this.otf;
            return oTF;
        }
        finally {
            this.postGetter(OTF);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOtf(OTF otf) {
        try {
            this.preSetter(OTF, otf);
            this.otf = otf;
        }
        finally {
            this.postSetter(OTF, otf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DetectorSettings getDetectorSettings() {
        try {
            this.preGetter(DETECTORSETTINGS);
            DetectorSettings detectorSettings = this.detectorSettings;
            return detectorSettings;
        }
        finally {
            this.postGetter(DETECTORSETTINGS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDetectorSettings(DetectorSettings detectorSettings) {
        try {
            this.preSetter(DETECTORSETTINGS, detectorSettings);
            this.detectorSettings = detectorSettings;
        }
        finally {
            this.postSetter(DETECTORSETTINGS, detectorSettings);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LightSettings getLightSource() {
        try {
            this.preGetter(LIGHTSOURCE);
            LightSettings lightSettings = this.lightSource;
            return lightSettings;
        }
        finally {
            this.postGetter(LIGHTSOURCE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLightSource(LightSettings lightSource) {
        try {
            this.preSetter(LIGHTSOURCE, lightSource);
            this.lightSource = lightSource;
        }
        finally {
            this.postSetter(LIGHTSOURCE, lightSource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LightSettings getAuxLightSource() {
        try {
            this.preGetter(AUXLIGHTSOURCE);
            LightSettings lightSettings = this.auxLightSource;
            return lightSettings;
        }
        finally {
            this.postGetter(AUXLIGHTSOURCE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAuxLightSource(LightSettings auxLightSource) {
        try {
            this.preSetter(AUXLIGHTSOURCE, auxLightSource);
            this.auxLightSource = auxLightSource;
        }
        finally {
            this.postSetter(AUXLIGHTSOURCE, auxLightSource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PhotometricInterpretation getPhotometricInterpretation() {
        try {
            this.preGetter(PHOTOMETRICINTERPRETATION);
            PhotometricInterpretation photometricInterpretation = this.photometricInterpretation;
            return photometricInterpretation;
        }
        finally {
            this.postGetter(PHOTOMETRICINTERPRETATION);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPhotometricInterpretation(PhotometricInterpretation photometricInterpretation) {
        try {
            this.preSetter(PHOTOMETRICINTERPRETATION, photometricInterpretation);
            this.photometricInterpretation = photometricInterpretation;
        }
        finally {
            this.postSetter(PHOTOMETRICINTERPRETATION, photometricInterpretation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AcquisitionMode getMode() {
        try {
            this.preGetter(MODE);
            AcquisitionMode acquisitionMode = this.mode;
            return acquisitionMode;
        }
        finally {
            this.postGetter(MODE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMode(AcquisitionMode mode) {
        try {
            this.preSetter(MODE, mode);
            this.mode = mode;
        }
        finally {
            this.postSetter(MODE, mode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPockelCellSetting() {
        try {
            this.preGetter(POCKELCELLSETTING);
            String string = this.pockelCellSetting;
            return string;
        }
        finally {
            this.postGetter(POCKELCELLSETTING);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPockelCellSetting(String pockelCellSetting) {
        try {
            this.preSetter(POCKELCELLSETTING, pockelCellSetting);
            this.pockelCellSetting = pockelCellSetting;
        }
        finally {
            this.postSetter(POCKELCELLSETTING, pockelCellSetting);
        }
    }

    public boolean isValid() {
        return Validator.validate(this).isValid();
    }

    public Validation validate() {
        return Validator.validate(this);
    }

    public Filterable newInstance() {
        return new LogicalChannel();
    }

    public boolean acceptFilter(Filter __filter) {
        this.id = (Long)__filter.filter(ID, this.id);
        this.details = (Details)__filter.filter(DETAILS, this.details);
        this.version = (Integer)__filter.filter(VERSION, this.version);
        this.name = (String)__filter.filter(NAME, this.name);
        this.pinHoleSize = (Integer)__filter.filter(PINHOLESIZE, this.pinHoleSize);
        this.illumination = (Illumination)__filter.filter(ILLUMINATION, this.illumination);
        this.contrastMethod = (ContrastMethod)__filter.filter(CONTRASTMETHOD, this.contrastMethod);
        this.excitationWave = (Integer)__filter.filter(EXCITATIONWAVE, this.excitationWave);
        this.emissionWave = (Integer)__filter.filter(EMISSIONWAVE, this.emissionWave);
        this.fluor = (String)__filter.filter(FLUOR, this.fluor);
        this.ndFilter = (Float)__filter.filter(NDFILTER, this.ndFilter);
        this.otf = (OTF)__filter.filter(OTF, this.otf);
        this.detectorSettings = (DetectorSettings)__filter.filter(DETECTORSETTINGS, this.detectorSettings);
        this.lightSource = (LightSettings)__filter.filter(LIGHTSOURCE, this.lightSource);
        this.auxLightSource = (LightSettings)__filter.filter(AUXLIGHTSOURCE, this.auxLightSource);
        this.photometricInterpretation = (PhotometricInterpretation)__filter.filter(PHOTOMETRICINTERPRETATION, this.photometricInterpretation);
        this.mode = (AcquisitionMode)__filter.filter(MODE, this.mode);
        this.pockelCellSetting = (String)__filter.filter(POCKELCELLSETTING, this.pockelCellSetting);
        return true;
    }

    public String toString() {
        return "LogicalChannel" + (this.getId() == null ? ":Hash_" + this.hashCode() : ":Id_" + this.getId());
    }

    public Set fields() {
        return FIELDS;
    }

    public Object retrieve(String field) {
        if (field == null) {
            return null;
        }
        if (field.equals(ID)) {
            return this.getId();
        }
        if (field.equals(DETAILS)) {
            return this.getDetails();
        }
        if (field.equals(VERSION)) {
            return this.getVersion();
        }
        if (field.equals(NAME)) {
            return this.getName();
        }
        if (field.equals(PINHOLESIZE)) {
            return this.getPinHoleSize();
        }
        if (field.equals(ILLUMINATION)) {
            return this.getIllumination();
        }
        if (field.equals(CONTRASTMETHOD)) {
            return this.getContrastMethod();
        }
        if (field.equals(EXCITATIONWAVE)) {
            return this.getExcitationWave();
        }
        if (field.equals(EMISSIONWAVE)) {
            return this.getEmissionWave();
        }
        if (field.equals(FLUOR)) {
            return this.getFluor();
        }
        if (field.equals(NDFILTER)) {
            return this.getNdFilter();
        }
        if (field.equals(OTF)) {
            return this.getOtf();
        }
        if (field.equals(DETECTORSETTINGS)) {
            return this.getDetectorSettings();
        }
        if (field.equals(LIGHTSOURCE)) {
            return this.getLightSource();
        }
        if (field.equals(AUXLIGHTSOURCE)) {
            return this.getAuxLightSource();
        }
        if (field.equals(PHOTOMETRICINTERPRETATION)) {
            return this.getPhotometricInterpretation();
        }
        if (field.equals(MODE)) {
            return this.getMode();
        }
        if (field.equals(POCKELCELLSETTING)) {
            return this.getPockelCellSetting();
        }
        if (this._dynamicFields != null) {
            return this._dynamicFields.get(field);
        }
        return null;
    }

    public void putAt(String field, Object value) {
        if (field == null) {
            return;
        }
        if (field.equals(ID)) {
            this.setId((Long)value);
        } else if (field.equals(DETAILS)) {
            this.setDetails((Details)value);
        } else if (field.equals(VERSION)) {
            this.setVersion((Integer)value);
        } else if (field.equals(NAME)) {
            this.setName((String)value);
        } else if (field.equals(PINHOLESIZE)) {
            this.setPinHoleSize((Integer)value);
        } else if (field.equals(ILLUMINATION)) {
            this.setIllumination((Illumination)value);
        } else if (field.equals(CONTRASTMETHOD)) {
            this.setContrastMethod((ContrastMethod)value);
        } else if (field.equals(EXCITATIONWAVE)) {
            this.setExcitationWave((Integer)value);
        } else if (field.equals(EMISSIONWAVE)) {
            this.setEmissionWave((Integer)value);
        } else if (field.equals(FLUOR)) {
            this.setFluor((String)value);
        } else if (field.equals(NDFILTER)) {
            this.setNdFilter((Float)value);
        } else if (field.equals(OTF)) {
            this.setOtf((OTF)value);
        } else if (field.equals(DETECTORSETTINGS)) {
            this.setDetectorSettings((DetectorSettings)value);
        } else if (field.equals(LIGHTSOURCE)) {
            this.setLightSource((LightSettings)value);
        } else if (field.equals(AUXLIGHTSOURCE)) {
            this.setAuxLightSource((LightSettings)value);
        } else if (field.equals(PHOTOMETRICINTERPRETATION)) {
            this.setPhotometricInterpretation((PhotometricInterpretation)value);
        } else if (field.equals(MODE)) {
            this.setMode((AcquisitionMode)value);
        } else if (field.equals(POCKELCELLSETTING)) {
            this.setPockelCellSetting((String)value);
        } else {
            if (this._dynamicFields == null) {
                this._dynamicFields = new HashMap();
            }
            this._dynamicFields.put(field, value);
        }
    }

    public boolean isLoaded() {
        return this._loaded;
    }

    public void unload() {
        this._loaded = false;
        this.details = null;
        this.version = null;
        this.name = null;
        this.pinHoleSize = null;
        this.illumination = null;
        this.contrastMethod = null;
        this.excitationWave = null;
        this.emissionWave = null;
        this.fluor = null;
        this.ndFilter = null;
        this.otf = null;
        this.detectorSettings = null;
        this.lightSource = null;
        this.auxLightSource = null;
        this.photometricInterpretation = null;
        this.mode = null;
        this.pockelCellSetting = null;
    }

    protected void errorIfUnloaded() {
        if (!this._loaded) {
            throw new IllegalStateException("Object unloaded:" + this);
        }
    }

    public final GraphHolder getGraphHolder() {
        if (this._graphHolder == null) {
            this._graphHolder = new GraphHolder();
        }
        return this._graphHolder;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
    }

    static {
        HashSet<String> raw = new HashSet<String>();
        raw.add(ID);
        raw.add(DETAILS);
        raw.add(VERSION);
        raw.add(NAME);
        raw.add(PINHOLESIZE);
        raw.add(ILLUMINATION);
        raw.add(CONTRASTMETHOD);
        raw.add(EXCITATIONWAVE);
        raw.add(EMISSIONWAVE);
        raw.add(FLUOR);
        raw.add(NDFILTER);
        raw.add(OTF);
        raw.add(DETECTORSETTINGS);
        raw.add(LIGHTSOURCE);
        raw.add(AUXLIGHTSOURCE);
        raw.add(PHOTOMETRICINTERPRETATION);
        raw.add(MODE);
        raw.add(POCKELCELLSETTING);
        FIELDS = Collections.unmodifiableSet(raw);
    }
}

