/*
 * Decompiled with CFR 0.152.
 */
package ome.model.containers;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import ome.conditions.ApiUsageException;
import ome.model.IMutable;
import ome.model.IObject;
import ome.model.annotations.ProjectAnnotation;
import ome.model.containers.Dataset;
import ome.model.containers.ProjectDatasetLink;
import ome.model.internal.Details;
import ome.model.internal.GraphHolder;
import ome.util.CBlock;
import ome.util.EmptyIterator;
import ome.util.Filter;
import ome.util.Filterable;
import ome.util.Validation;
import ome.util.Validator;

public class Project
implements IMutable,
IObject,
Serializable {
    private Long id;
    private Details details = new Details();
    private Integer version = new Integer(0);
    private String name;
    private String description;
    private Set datasetLinks = new HashSet(0);
    private Set annotations = new HashSet(0);
    public static final String OWNER_FILTER = "project_owner_filter";
    public static final String GROUP_FILTER = "project_group_filter";
    public static final String EVENT_FILTER = "project_event_filter";
    public static final String PERMS_FILTER = "project_perms_filter";
    public static final String OWNER_FILTER_DATASETLINKS = "project_owner_filter_DATASETLINKS";
    public static final String GROUP_FILTER_DATASETLINKS = "project_group_filter_DATASETLINKS";
    public static final String EVENT_FILTER_DATASETLINKS = "project_event_filter_DATASETLINKS";
    public static final String PERMS_FILTER_DATASETLINKS = "project_perms_filter_DATASETLINKS";
    public static final String OWNER_FILTER_ANNOTATIONS = "project_owner_filter_ANNOTATIONS";
    public static final String GROUP_FILTER_ANNOTATIONS = "project_group_filter_ANNOTATIONS";
    public static final String EVENT_FILTER_ANNOTATIONS = "project_event_filter_ANNOTATIONS";
    public static final String PERMS_FILTER_ANNOTATIONS = "project_perms_filter_ANNOTATIONS";
    private static final long serialVersionUID = 0xC00010C1L;
    public static final String ID = "Project_id";
    public static final String DETAILS = "Project_details";
    public static final String VERSION = "Project_version";
    public static final String NAME = "Project_name";
    public static final String DESCRIPTION = "Project_description";
    public static final String DATASETLINKS = "Project_datasetLinks";
    public static final String ANNOTATIONS = "Project_annotations";
    public static final Set FIELDS;
    protected Map _dynamicFields;
    protected boolean _loaded = true;
    private transient GraphHolder _graphHolder;

    public Project() {
    }

    public Project(Long id) {
        this.setId(id);
        this.getDetails().setContext(this);
    }

    public Project(Long id, boolean loaded) {
        this(id);
        if (!loaded) {
            this.unload();
        }
    }

    protected void preGetter(String field) {
        this.errorIfUnloaded();
    }

    protected void postGetter(String field) {
    }

    protected void preSetter(String field, Object value) {
        this.errorIfUnloaded();
    }

    protected void postSetter(String field, Object value) {
    }

    protected void throwNullCollectionException(String propertyName) {
        throw new ApiUsageException("Error updating collection:" + propertyName + "\n" + "Collection is currently null. This can be seen\n" + "by testing \"sizeOf" + propertyName + " < 0\". This implies\n" + "that this collection was unloaded. Please refresh this object\n" + "in order to update this collection.\n");
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Details getDetails() {
        try {
            this.preGetter(DETAILS);
            Details details = this.details;
            return details;
        }
        finally {
            this.postGetter(DETAILS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDetails(Details details) {
        try {
            this.preSetter(DETAILS, details);
            this.details = details;
        }
        finally {
            this.postSetter(DETAILS, details);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getVersion() {
        try {
            this.preGetter(VERSION);
            Integer n = this.version;
            return n;
        }
        finally {
            this.postGetter(VERSION);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVersion(Integer version) {
        try {
            this.preSetter(VERSION, version);
            this.version = version;
        }
        finally {
            this.postSetter(VERSION, version);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() {
        try {
            this.preGetter(NAME);
            String string = this.name;
            return string;
        }
        finally {
            this.postGetter(NAME);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String name) {
        try {
            this.preSetter(NAME, name);
            this.name = name;
        }
        finally {
            this.postSetter(NAME, name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDescription() {
        try {
            this.preGetter(DESCRIPTION);
            String string = this.description;
            return string;
        }
        finally {
            this.postGetter(DESCRIPTION);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDescription(String description) {
        try {
            this.preSetter(DESCRIPTION, description);
            this.description = description;
        }
        finally {
            this.postSetter(DESCRIPTION, description);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set getDatasetLinks() {
        try {
            this.preGetter(DATASETLINKS);
            Set set = this.datasetLinks;
            return set;
        }
        finally {
            this.postGetter(DATASETLINKS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setDatasetLinks(Set datasetLinks) {
        try {
            this.preSetter(DATASETLINKS, datasetLinks);
            this.datasetLinks = datasetLinks;
        }
        finally {
            this.postSetter(DATASETLINKS, datasetLinks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sizeOfDatasetLinks() {
        try {
            this.preGetter(DATASETLINKS);
            int n = this.datasetLinks == null ? -1 : this.datasetLinks.size();
            return n;
        }
        finally {
            this.postGetter(DATASETLINKS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iterateDatasetLinks() {
        try {
            this.preGetter(DATASETLINKS);
            if (this.getDatasetLinks() == null) {
                EmptyIterator emptyIterator = new EmptyIterator();
                return emptyIterator;
            }
            Iterator iterator = this.getDatasetLinks().iterator();
            return iterator;
        }
        finally {
            this.postGetter(DATASETLINKS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List collectDatasetLinks(CBlock block) {
        try {
            this.preGetter(DATASETLINKS);
            ArrayList result = new ArrayList();
            Iterator it = this.iterateDatasetLinks();
            while (it.hasNext()) {
                IObject obj = (IObject)it.next();
                if (block != null) {
                    result.add(block.call(obj));
                    continue;
                }
                result.add(obj);
            }
            ArrayList arrayList = result;
            return arrayList;
        }
        finally {
            this.postGetter(DATASETLINKS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void linkDataset(Dataset addition) {
        try {
            this.preSetter(DATASETLINKS, addition);
            ProjectDatasetLink link = new ProjectDatasetLink();
            link.link(this, addition);
            this.addProjectDatasetLink(link, true);
        }
        finally {
            this.postSetter(DATASETLINKS, addition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProjectDatasetLink(ProjectDatasetLink link, boolean bothSides) {
        try {
            this.preSetter(DATASETLINKS, link);
            if (this.getDatasetLinks() == null) {
                this.throwNullCollectionException("DatasetLinks");
            }
            this.getDatasetLinks().add(link);
            if (bothSides && link.child().isLoaded()) {
                link.child().addProjectDatasetLink(link, false);
            }
        }
        finally {
            this.postSetter(DATASETLINKS, link);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator linkedDatasetIterator() {
        try {
            this.preGetter(DATASETLINKS);
            if (this.getDatasetLinks() == null) {
                EmptyIterator emptyIterator = new EmptyIterator();
                return emptyIterator;
            }
            final Iterator it = this.getDatasetLinks().iterator();
            Iterator iterator = new Iterator(){

                public boolean hasNext() {
                    return it == null ? false : it.hasNext();
                }

                public Object next() {
                    if (it == null) {
                        throw new NoSuchElementException("datasetLinks is null; no elements.");
                    }
                    ProjectDatasetLink link = (ProjectDatasetLink)it.next();
                    return link.child();
                }

                public void remove() {
                    throw new UnsupportedOperationException("Cannot call remove on this iterator.");
                }
            };
            return iterator;
        }
        finally {
            this.postGetter(DATASETLINKS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set findProjectDatasetLink(Dataset target) {
        try {
            this.preGetter(DATASETLINKS);
            Iterator it = this.iterateDatasetLinks();
            HashSet<ProjectDatasetLink> result = new HashSet<ProjectDatasetLink>();
            while (it.hasNext()) {
                ProjectDatasetLink link = (ProjectDatasetLink)it.next();
                if (link.child() != target) continue;
                result.add(link);
            }
            HashSet<ProjectDatasetLink> hashSet = result;
            return hashSet;
        }
        finally {
            this.postGetter(DATASETLINKS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List linkedDatasetList() {
        try {
            this.preGetter(DATASETLINKS);
            Iterator it = this.linkedDatasetIterator();
            ArrayList list = new ArrayList();
            while (it.hasNext()) {
                list.add(it.next());
            }
            ArrayList arrayList = list;
            return arrayList;
        }
        finally {
            this.postGetter(DATASETLINKS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List eachLinkedDataset(CBlock block) {
        try {
            this.preGetter(DATASETLINKS);
            ArrayList result = new ArrayList();
            Iterator it = this.linkedDatasetIterator();
            while (it.hasNext()) {
                IObject obj = (IObject)it.next();
                if (block != null) {
                    result.add(block.call(obj));
                    continue;
                }
                result.add(obj);
            }
            ArrayList arrayList = result;
            return arrayList;
        }
        finally {
            this.postGetter(DATASETLINKS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlinkDataset(Dataset removal) {
        try {
            this.preSetter(DATASETLINKS, removal);
            Set toRemove = this.findProjectDatasetLink(removal);
            Iterator it = toRemove.iterator();
            while (it.hasNext()) {
                this.removeProjectDatasetLink((ProjectDatasetLink)it.next(), true);
            }
        }
        finally {
            this.postSetter(DATASETLINKS, removal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProjectDatasetLink(ProjectDatasetLink link, boolean bothSides) {
        try {
            this.preSetter(DATASETLINKS, link);
            if (this.getDatasetLinks() == null) {
                this.throwNullCollectionException("DatasetLinks");
            }
            this.getDatasetLinks().remove(link);
            if (bothSides && link.child().isLoaded()) {
                link.child().removeProjectDatasetLink(link, false);
            }
        }
        finally {
            this.postSetter(DATASETLINKS, link);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearDatasetLinks() {
        try {
            this.preSetter(DATASETLINKS, null);
            ArrayList list = new ArrayList(this.getDatasetLinks());
            for (Object object : list) {
                ProjectDatasetLink link = (ProjectDatasetLink)object;
                this.removeProjectDatasetLink(link, true);
            }
        }
        finally {
            this.postSetter(DATASETLINKS, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set getAnnotations() {
        try {
            this.preGetter(ANNOTATIONS);
            Set set = this.annotations;
            return set;
        }
        finally {
            this.postGetter(ANNOTATIONS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setAnnotations(Set annotations) {
        try {
            this.preSetter(ANNOTATIONS, annotations);
            this.annotations = annotations;
        }
        finally {
            this.postSetter(ANNOTATIONS, annotations);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sizeOfAnnotations() {
        try {
            this.preGetter(ANNOTATIONS);
            int n = this.annotations == null ? -1 : this.annotations.size();
            return n;
        }
        finally {
            this.postGetter(ANNOTATIONS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iterateAnnotations() {
        try {
            this.preGetter(ANNOTATIONS);
            if (this.getAnnotations() == null) {
                EmptyIterator emptyIterator = new EmptyIterator();
                return emptyIterator;
            }
            Iterator iterator = this.getAnnotations().iterator();
            return iterator;
        }
        finally {
            this.postGetter(ANNOTATIONS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List collectAnnotations(CBlock block) {
        try {
            this.preGetter(ANNOTATIONS);
            ArrayList result = new ArrayList();
            Iterator it = this.iterateAnnotations();
            while (it.hasNext()) {
                IObject obj = (IObject)it.next();
                if (block != null) {
                    result.add(block.call(obj));
                    continue;
                }
                result.add(obj);
            }
            ArrayList arrayList = result;
            return arrayList;
        }
        finally {
            this.postGetter(ANNOTATIONS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProjectAnnotation(ProjectAnnotation target) {
        try {
            this.preSetter(ANNOTATIONS, target);
            if (this.getAnnotations() == null) {
                this.throwNullCollectionException("Annotations");
            }
            this.getAnnotations().add(target);
            target.setProject(this);
        }
        finally {
            this.postSetter(ANNOTATIONS, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProjectAnnotationSet(Set targets) {
        try {
            this.preSetter(ANNOTATIONS, targets);
            if (this.getAnnotations() == null) {
                this.throwNullCollectionException("Annotations");
            }
            this.getAnnotations().addAll(targets);
            for (ProjectAnnotation target : targets) {
                target.setProject(this);
            }
        }
        finally {
            this.postSetter(ANNOTATIONS, targets);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProjectAnnotation(ProjectAnnotation target) {
        try {
            this.preSetter(ANNOTATIONS, target);
            if (this.getAnnotations() == null) {
                this.throwNullCollectionException("Annotations");
            }
            this.getAnnotations().remove(target);
            target.setProject(null);
        }
        finally {
            this.postSetter(ANNOTATIONS, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProjectAnnotationSet(Set targets) {
        try {
            this.preSetter(ANNOTATIONS, targets);
            if (this.getAnnotations() == null) {
                this.throwNullCollectionException("Annotations");
            }
            this.getAnnotations().removeAll(targets);
            for (ProjectAnnotation target : targets) {
                target.setProject(null);
            }
        }
        finally {
            this.postSetter(ANNOTATIONS, targets);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAnnotations() {
        try {
            this.preSetter(ANNOTATIONS, null);
            if (this.getAnnotations() == null) {
                this.throwNullCollectionException("Annotations");
            }
            this.getAnnotations().clear();
            Iterator it = this.iterateAnnotations();
            while (it.hasNext()) {
                ProjectAnnotation target = (ProjectAnnotation)it.next();
                target.setProject(null);
            }
        }
        finally {
            this.postSetter(ANNOTATIONS, null);
        }
    }

    public boolean isValid() {
        return Validator.validate(this).isValid();
    }

    public Validation validate() {
        return Validator.validate(this);
    }

    public Filterable newInstance() {
        return new Project();
    }

    public boolean acceptFilter(Filter __filter) {
        this.id = (Long)__filter.filter(ID, this.id);
        this.details = (Details)__filter.filter(DETAILS, this.details);
        this.version = (Integer)__filter.filter(VERSION, this.version);
        this.name = (String)__filter.filter(NAME, this.name);
        this.description = (String)__filter.filter(DESCRIPTION, this.description);
        this.datasetLinks = (Set)__filter.filter(DATASETLINKS, this.datasetLinks);
        this.annotations = (Set)__filter.filter(ANNOTATIONS, this.annotations);
        return true;
    }

    public String toString() {
        return "Project" + (this.getId() == null ? ":Hash_" + this.hashCode() : ":Id_" + this.getId());
    }

    public Set fields() {
        return FIELDS;
    }

    public Object retrieve(String field) {
        if (field == null) {
            return null;
        }
        if (field.equals(ID)) {
            return this.getId();
        }
        if (field.equals(DETAILS)) {
            return this.getDetails();
        }
        if (field.equals(VERSION)) {
            return this.getVersion();
        }
        if (field.equals(NAME)) {
            return this.getName();
        }
        if (field.equals(DESCRIPTION)) {
            return this.getDescription();
        }
        if (field.equals(DATASETLINKS)) {
            return this.getDatasetLinks();
        }
        if (field.equals(ANNOTATIONS)) {
            return this.getAnnotations();
        }
        if (this._dynamicFields != null) {
            return this._dynamicFields.get(field);
        }
        return null;
    }

    public void putAt(String field, Object value) {
        if (field == null) {
            return;
        }
        if (field.equals(ID)) {
            this.setId((Long)value);
        } else if (field.equals(DETAILS)) {
            this.setDetails((Details)value);
        } else if (field.equals(VERSION)) {
            this.setVersion((Integer)value);
        } else if (field.equals(NAME)) {
            this.setName((String)value);
        } else if (field.equals(DESCRIPTION)) {
            this.setDescription((String)value);
        } else if (field.equals(DATASETLINKS)) {
            this.setDatasetLinks((Set)value);
        } else if (field.equals(ANNOTATIONS)) {
            this.setAnnotations((Set)value);
        } else {
            if (this._dynamicFields == null) {
                this._dynamicFields = new HashMap();
            }
            this._dynamicFields.put(field, value);
        }
    }

    public boolean isLoaded() {
        return this._loaded;
    }

    public void unload() {
        this._loaded = false;
        this.details = null;
        this.version = null;
        this.name = null;
        this.description = null;
        this.datasetLinks = null;
        this.annotations = null;
    }

    protected void errorIfUnloaded() {
        if (!this._loaded) {
            throw new IllegalStateException("Object unloaded:" + this);
        }
    }

    public final GraphHolder getGraphHolder() {
        if (this._graphHolder == null) {
            this._graphHolder = new GraphHolder();
        }
        return this._graphHolder;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
    }

    static {
        HashSet<String> raw = new HashSet<String>();
        raw.add(ID);
        raw.add(DETAILS);
        raw.add(VERSION);
        raw.add(NAME);
        raw.add(DESCRIPTION);
        raw.add(DATASETLINKS);
        raw.add(ANNOTATIONS);
        FIELDS = Collections.unmodifiableSet(raw);
    }
}

