/*
 * Decompiled with CFR 0.152.
 */
package ome.model.acquisition;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import ome.conditions.ApiUsageException;
import ome.model.IMutable;
import ome.model.IObject;
import ome.model.enums.PixelsType;
import ome.model.internal.Details;
import ome.model.internal.GraphHolder;
import ome.util.Filter;
import ome.util.Filterable;
import ome.util.Validation;
import ome.util.Validator;

public class OTF
implements IMutable,
IObject,
Serializable {
    private Long id;
    private Details details = new Details();
    private Integer version = new Integer(0);
    private Integer sizeX;
    private Integer sizeY;
    private Boolean opticalAxisAvg;
    private PixelsType pixelType;
    private String path;
    public static final String OWNER_FILTER = "otf_owner_filter";
    public static final String GROUP_FILTER = "otf_group_filter";
    public static final String EVENT_FILTER = "otf_event_filter";
    public static final String PERMS_FILTER = "otf_perms_filter";
    private static final long serialVersionUID = 0xC00010C1L;
    public static final String ID = "OTF_id";
    public static final String DETAILS = "OTF_details";
    public static final String VERSION = "OTF_version";
    public static final String SIZEX = "OTF_sizeX";
    public static final String SIZEY = "OTF_sizeY";
    public static final String OPTICALAXISAVG = "OTF_opticalAxisAvg";
    public static final String PIXELTYPE = "OTF_pixelType";
    public static final String PATH = "OTF_path";
    public static final Set FIELDS;
    protected Map _dynamicFields;
    protected boolean _loaded = true;
    private transient GraphHolder _graphHolder;

    public OTF() {
    }

    public OTF(Long id) {
        this.setId(id);
        this.getDetails().setContext(this);
    }

    public OTF(Long id, boolean loaded) {
        this(id);
        if (!loaded) {
            this.unload();
        }
    }

    protected void preGetter(String field) {
        this.errorIfUnloaded();
    }

    protected void postGetter(String field) {
    }

    protected void preSetter(String field, Object value) {
        this.errorIfUnloaded();
    }

    protected void postSetter(String field, Object value) {
    }

    protected void throwNullCollectionException(String propertyName) {
        throw new ApiUsageException("Error updating collection:" + propertyName + "\n" + "Collection is currently null. This can be seen\n" + "by testing \"sizeOf" + propertyName + " < 0\". This implies\n" + "that this collection was unloaded. Please refresh this object\n" + "in order to update this collection.\n");
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Details getDetails() {
        try {
            this.preGetter(DETAILS);
            Details details = this.details;
            return details;
        }
        finally {
            this.postGetter(DETAILS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDetails(Details details) {
        try {
            this.preSetter(DETAILS, details);
            this.details = details;
        }
        finally {
            this.postSetter(DETAILS, details);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getVersion() {
        try {
            this.preGetter(VERSION);
            Integer n = this.version;
            return n;
        }
        finally {
            this.postGetter(VERSION);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVersion(Integer version) {
        try {
            this.preSetter(VERSION, version);
            this.version = version;
        }
        finally {
            this.postSetter(VERSION, version);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getSizeX() {
        try {
            this.preGetter(SIZEX);
            Integer n = this.sizeX;
            return n;
        }
        finally {
            this.postGetter(SIZEX);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSizeX(Integer sizeX) {
        try {
            this.preSetter(SIZEX, sizeX);
            this.sizeX = sizeX;
        }
        finally {
            this.postSetter(SIZEX, sizeX);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getSizeY() {
        try {
            this.preGetter(SIZEY);
            Integer n = this.sizeY;
            return n;
        }
        finally {
            this.postGetter(SIZEY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSizeY(Integer sizeY) {
        try {
            this.preSetter(SIZEY, sizeY);
            this.sizeY = sizeY;
        }
        finally {
            this.postSetter(SIZEY, sizeY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean getOpticalAxisAvg() {
        try {
            this.preGetter(OPTICALAXISAVG);
            Boolean bl = this.opticalAxisAvg;
            return bl;
        }
        finally {
            this.postGetter(OPTICALAXISAVG);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOpticalAxisAvg(Boolean opticalAxisAvg) {
        try {
            this.preSetter(OPTICALAXISAVG, opticalAxisAvg);
            this.opticalAxisAvg = opticalAxisAvg;
        }
        finally {
            this.postSetter(OPTICALAXISAVG, opticalAxisAvg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PixelsType getPixelType() {
        try {
            this.preGetter(PIXELTYPE);
            PixelsType pixelsType = this.pixelType;
            return pixelsType;
        }
        finally {
            this.postGetter(PIXELTYPE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPixelType(PixelsType pixelType) {
        try {
            this.preSetter(PIXELTYPE, pixelType);
            this.pixelType = pixelType;
        }
        finally {
            this.postSetter(PIXELTYPE, pixelType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPath() {
        try {
            this.preGetter(PATH);
            String string = this.path;
            return string;
        }
        finally {
            this.postGetter(PATH);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPath(String path) {
        try {
            this.preSetter(PATH, path);
            this.path = path;
        }
        finally {
            this.postSetter(PATH, path);
        }
    }

    public boolean isValid() {
        return Validator.validate(this).isValid();
    }

    public Validation validate() {
        return Validator.validate(this);
    }

    public Filterable newInstance() {
        return new OTF();
    }

    public boolean acceptFilter(Filter __filter) {
        this.id = (Long)__filter.filter(ID, this.id);
        this.details = (Details)__filter.filter(DETAILS, this.details);
        this.version = (Integer)__filter.filter(VERSION, this.version);
        this.sizeX = (Integer)__filter.filter(SIZEX, this.sizeX);
        this.sizeY = (Integer)__filter.filter(SIZEY, this.sizeY);
        this.opticalAxisAvg = (Boolean)__filter.filter(OPTICALAXISAVG, this.opticalAxisAvg);
        this.pixelType = (PixelsType)__filter.filter(PIXELTYPE, this.pixelType);
        this.path = (String)__filter.filter(PATH, this.path);
        return true;
    }

    public String toString() {
        return "OTF" + (this.getId() == null ? ":Hash_" + this.hashCode() : ":Id_" + this.getId());
    }

    public Set fields() {
        return FIELDS;
    }

    public Object retrieve(String field) {
        if (field == null) {
            return null;
        }
        if (field.equals(ID)) {
            return this.getId();
        }
        if (field.equals(DETAILS)) {
            return this.getDetails();
        }
        if (field.equals(VERSION)) {
            return this.getVersion();
        }
        if (field.equals(SIZEX)) {
            return this.getSizeX();
        }
        if (field.equals(SIZEY)) {
            return this.getSizeY();
        }
        if (field.equals(OPTICALAXISAVG)) {
            return this.getOpticalAxisAvg();
        }
        if (field.equals(PIXELTYPE)) {
            return this.getPixelType();
        }
        if (field.equals(PATH)) {
            return this.getPath();
        }
        if (this._dynamicFields != null) {
            return this._dynamicFields.get(field);
        }
        return null;
    }

    public void putAt(String field, Object value) {
        if (field == null) {
            return;
        }
        if (field.equals(ID)) {
            this.setId((Long)value);
        } else if (field.equals(DETAILS)) {
            this.setDetails((Details)value);
        } else if (field.equals(VERSION)) {
            this.setVersion((Integer)value);
        } else if (field.equals(SIZEX)) {
            this.setSizeX((Integer)value);
        } else if (field.equals(SIZEY)) {
            this.setSizeY((Integer)value);
        } else if (field.equals(OPTICALAXISAVG)) {
            this.setOpticalAxisAvg((Boolean)value);
        } else if (field.equals(PIXELTYPE)) {
            this.setPixelType((PixelsType)value);
        } else if (field.equals(PATH)) {
            this.setPath((String)value);
        } else {
            if (this._dynamicFields == null) {
                this._dynamicFields = new HashMap();
            }
            this._dynamicFields.put(field, value);
        }
    }

    public boolean isLoaded() {
        return this._loaded;
    }

    public void unload() {
        this._loaded = false;
        this.details = null;
        this.version = null;
        this.sizeX = null;
        this.sizeY = null;
        this.opticalAxisAvg = null;
        this.pixelType = null;
        this.path = null;
    }

    protected void errorIfUnloaded() {
        if (!this._loaded) {
            throw new IllegalStateException("Object unloaded:" + this);
        }
    }

    public final GraphHolder getGraphHolder() {
        if (this._graphHolder == null) {
            this._graphHolder = new GraphHolder();
        }
        return this._graphHolder;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
    }

    static {
        HashSet<String> raw = new HashSet<String>();
        raw.add(ID);
        raw.add(DETAILS);
        raw.add(VERSION);
        raw.add(SIZEX);
        raw.add(SIZEY);
        raw.add(OPTICALAXISAVG);
        raw.add(PIXELTYPE);
        raw.add(PATH);
        FIELDS = Collections.unmodifiableSet(raw);
    }
}

