/*
 * Decompiled with CFR 0.152.
 */
package ome.model.acquisition;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import ome.conditions.ApiUsageException;
import ome.model.IMutable;
import ome.model.IObject;
import ome.model.acquisition.LightSource;
import ome.model.enums.FrequencyMultiplication;
import ome.model.enums.LaserMedium;
import ome.model.enums.LaserType;
import ome.model.enums.Pulse;
import ome.util.Filter;
import ome.util.Filterable;
import ome.util.Validation;
import ome.util.Validator;

public class Laser
extends LightSource
implements IMutable,
IObject,
Serializable {
    private LaserType type;
    private LaserMedium laserMedium;
    private FrequencyMultiplication frequencyMultiplication;
    private Boolean tunable;
    private Pulse pulse;
    private Integer wavelength;
    private Boolean pockelCell;
    private Laser pump;
    public static final String OWNER_FILTER = "laser_owner_filter";
    public static final String GROUP_FILTER = "laser_group_filter";
    public static final String EVENT_FILTER = "laser_event_filter";
    public static final String PERMS_FILTER = "laser_perms_filter";
    private static final long serialVersionUID = 0xC00010C1L;
    public static final String TYPE = "Laser_type";
    public static final String LASERMEDIUM = "Laser_laserMedium";
    public static final String FREQUENCYMULTIPLICATION = "Laser_frequencyMultiplication";
    public static final String TUNABLE = "Laser_tunable";
    public static final String PULSE = "Laser_pulse";
    public static final String WAVELENGTH = "Laser_wavelength";
    public static final String POCKELCELL = "Laser_pockelCell";
    public static final String PUMP = "Laser_pump";
    public static final Set FIELDS;

    public Laser() {
    }

    public Laser(Long id) {
        this.setId(id);
        this.getDetails().setContext(this);
    }

    public Laser(Long id, boolean loaded) {
        this(id);
        if (!loaded) {
            this.unload();
        }
    }

    protected void preGetter(String field) {
        this.errorIfUnloaded();
    }

    protected void postGetter(String field) {
    }

    protected void preSetter(String field, Object value) {
        this.errorIfUnloaded();
    }

    protected void postSetter(String field, Object value) {
    }

    protected void throwNullCollectionException(String propertyName) {
        throw new ApiUsageException("Error updating collection:" + propertyName + "\n" + "Collection is currently null. This can be seen\n" + "by testing \"sizeOf" + propertyName + " < 0\". This implies\n" + "that this collection was unloaded. Please refresh this object\n" + "in order to update this collection.\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LaserType getType() {
        try {
            this.preGetter(TYPE);
            LaserType laserType = this.type;
            return laserType;
        }
        finally {
            this.postGetter(TYPE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setType(LaserType type) {
        try {
            this.preSetter(TYPE, type);
            this.type = type;
        }
        finally {
            this.postSetter(TYPE, type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LaserMedium getLaserMedium() {
        try {
            this.preGetter(LASERMEDIUM);
            LaserMedium laserMedium = this.laserMedium;
            return laserMedium;
        }
        finally {
            this.postGetter(LASERMEDIUM);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLaserMedium(LaserMedium laserMedium) {
        try {
            this.preSetter(LASERMEDIUM, laserMedium);
            this.laserMedium = laserMedium;
        }
        finally {
            this.postSetter(LASERMEDIUM, laserMedium);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FrequencyMultiplication getFrequencyMultiplication() {
        try {
            this.preGetter(FREQUENCYMULTIPLICATION);
            FrequencyMultiplication frequencyMultiplication = this.frequencyMultiplication;
            return frequencyMultiplication;
        }
        finally {
            this.postGetter(FREQUENCYMULTIPLICATION);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFrequencyMultiplication(FrequencyMultiplication frequencyMultiplication) {
        try {
            this.preSetter(FREQUENCYMULTIPLICATION, frequencyMultiplication);
            this.frequencyMultiplication = frequencyMultiplication;
        }
        finally {
            this.postSetter(FREQUENCYMULTIPLICATION, frequencyMultiplication);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean getTunable() {
        try {
            this.preGetter(TUNABLE);
            Boolean bl = this.tunable;
            return bl;
        }
        finally {
            this.postGetter(TUNABLE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTunable(Boolean tunable) {
        try {
            this.preSetter(TUNABLE, tunable);
            this.tunable = tunable;
        }
        finally {
            this.postSetter(TUNABLE, tunable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pulse getPulse() {
        try {
            this.preGetter(PULSE);
            Pulse pulse = this.pulse;
            return pulse;
        }
        finally {
            this.postGetter(PULSE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPulse(Pulse pulse) {
        try {
            this.preSetter(PULSE, pulse);
            this.pulse = pulse;
        }
        finally {
            this.postSetter(PULSE, pulse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getWavelength() {
        try {
            this.preGetter(WAVELENGTH);
            Integer n = this.wavelength;
            return n;
        }
        finally {
            this.postGetter(WAVELENGTH);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWavelength(Integer wavelength) {
        try {
            this.preSetter(WAVELENGTH, wavelength);
            this.wavelength = wavelength;
        }
        finally {
            this.postSetter(WAVELENGTH, wavelength);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean getPockelCell() {
        try {
            this.preGetter(POCKELCELL);
            Boolean bl = this.pockelCell;
            return bl;
        }
        finally {
            this.postGetter(POCKELCELL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPockelCell(Boolean pockelCell) {
        try {
            this.preSetter(POCKELCELL, pockelCell);
            this.pockelCell = pockelCell;
        }
        finally {
            this.postSetter(POCKELCELL, pockelCell);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Laser getPump() {
        try {
            this.preGetter(PUMP);
            Laser laser = this.pump;
            return laser;
        }
        finally {
            this.postGetter(PUMP);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPump(Laser pump) {
        try {
            this.preSetter(PUMP, pump);
            this.pump = pump;
        }
        finally {
            this.postSetter(PUMP, pump);
        }
    }

    public boolean isValid() {
        return Validator.validate(this).isValid();
    }

    public Validation validate() {
        return Validator.validate(this);
    }

    public Filterable newInstance() {
        return new Laser();
    }

    public boolean acceptFilter(Filter __filter) {
        this.type = (LaserType)__filter.filter(TYPE, this.type);
        this.laserMedium = (LaserMedium)__filter.filter(LASERMEDIUM, this.laserMedium);
        this.frequencyMultiplication = (FrequencyMultiplication)__filter.filter(FREQUENCYMULTIPLICATION, this.frequencyMultiplication);
        this.tunable = (Boolean)__filter.filter(TUNABLE, this.tunable);
        this.pulse = (Pulse)__filter.filter(PULSE, this.pulse);
        this.wavelength = (Integer)__filter.filter(WAVELENGTH, this.wavelength);
        this.pockelCell = (Boolean)__filter.filter(POCKELCELL, this.pockelCell);
        this.pump = (Laser)__filter.filter(PUMP, this.pump);
        return super.acceptFilter(__filter);
    }

    public String toString() {
        return "Laser" + (this.getId() == null ? ":Hash_" + this.hashCode() : ":Id_" + this.getId());
    }

    public Set fields() {
        return FIELDS;
    }

    public Object retrieve(String field) {
        if (field == null) {
            return null;
        }
        if (field.equals(TYPE)) {
            return this.getType();
        }
        if (field.equals(LASERMEDIUM)) {
            return this.getLaserMedium();
        }
        if (field.equals(FREQUENCYMULTIPLICATION)) {
            return this.getFrequencyMultiplication();
        }
        if (field.equals(TUNABLE)) {
            return this.getTunable();
        }
        if (field.equals(PULSE)) {
            return this.getPulse();
        }
        if (field.equals(WAVELENGTH)) {
            return this.getWavelength();
        }
        if (field.equals(POCKELCELL)) {
            return this.getPockelCell();
        }
        if (field.equals(PUMP)) {
            return this.getPump();
        }
        return super.retrieve(field);
    }

    public void putAt(String field, Object value) {
        if (field == null) {
            return;
        }
        if (field.equals(TYPE)) {
            this.setType((LaserType)value);
        } else if (field.equals(LASERMEDIUM)) {
            this.setLaserMedium((LaserMedium)value);
        } else if (field.equals(FREQUENCYMULTIPLICATION)) {
            this.setFrequencyMultiplication((FrequencyMultiplication)value);
        } else if (field.equals(TUNABLE)) {
            this.setTunable((Boolean)value);
        } else if (field.equals(PULSE)) {
            this.setPulse((Pulse)value);
        } else if (field.equals(WAVELENGTH)) {
            this.setWavelength((Integer)value);
        } else if (field.equals(POCKELCELL)) {
            this.setPockelCell((Boolean)value);
        } else if (field.equals(PUMP)) {
            this.setPump((Laser)value);
        } else {
            super.putAt(field, value);
        }
    }

    public boolean isLoaded() {
        return this._loaded;
    }

    public void unload() {
        this._loaded = false;
        this.type = null;
        this.laserMedium = null;
        this.frequencyMultiplication = null;
        this.tunable = null;
        this.pulse = null;
        this.wavelength = null;
        this.pockelCell = null;
        this.pump = null;
        super.unload();
    }

    protected void errorIfUnloaded() {
        if (!this._loaded) {
            throw new IllegalStateException("Object unloaded:" + this);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
    }

    static {
        HashSet<String> raw = new HashSet<String>();
        raw.add(TYPE);
        raw.addAll(LightSource.FIELDS);
        raw.add(LASERMEDIUM);
        raw.addAll(LightSource.FIELDS);
        raw.add(FREQUENCYMULTIPLICATION);
        raw.addAll(LightSource.FIELDS);
        raw.add(TUNABLE);
        raw.addAll(LightSource.FIELDS);
        raw.add(PULSE);
        raw.addAll(LightSource.FIELDS);
        raw.add(WAVELENGTH);
        raw.addAll(LightSource.FIELDS);
        raw.add(POCKELCELL);
        raw.addAll(LightSource.FIELDS);
        raw.add(PUMP);
        raw.addAll(LightSource.FIELDS);
        FIELDS = Collections.unmodifiableSet(raw);
    }
}

