/*
 * Decompiled with CFR 0.152.
 */
package ome.model.acquisition;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ome.conditions.ApiUsageException;
import ome.model.IMutable;
import ome.model.IObject;
import ome.model.acquisition.Detector;
import ome.model.acquisition.Filter;
import ome.model.acquisition.LightSource;
import ome.model.acquisition.Microscope;
import ome.model.acquisition.Objective;
import ome.model.internal.Details;
import ome.model.internal.GraphHolder;
import ome.util.CBlock;
import ome.util.EmptyIterator;
import ome.util.Filterable;
import ome.util.Validation;
import ome.util.Validator;

public class Instrument
implements IMutable,
IObject,
Serializable {
    private Long id;
    private Details details = new Details();
    private Integer version = new Integer(0);
    private Microscope microscope;
    private Set detector = new HashSet(0);
    private Set objective = new HashSet(0);
    private Set lightSource = new HashSet(0);
    private Set filter = new HashSet(0);
    public static final String OWNER_FILTER = "instrument_owner_filter";
    public static final String GROUP_FILTER = "instrument_group_filter";
    public static final String EVENT_FILTER = "instrument_event_filter";
    public static final String PERMS_FILTER = "instrument_perms_filter";
    public static final String OWNER_FILTER_DETECTOR = "instrument_owner_filter_DETECTOR";
    public static final String GROUP_FILTER_DETECTOR = "instrument_group_filter_DETECTOR";
    public static final String EVENT_FILTER_DETECTOR = "instrument_event_filter_DETECTOR";
    public static final String PERMS_FILTER_DETECTOR = "instrument_perms_filter_DETECTOR";
    public static final String OWNER_FILTER_OBJECTIVE = "instrument_owner_filter_OBJECTIVE";
    public static final String GROUP_FILTER_OBJECTIVE = "instrument_group_filter_OBJECTIVE";
    public static final String EVENT_FILTER_OBJECTIVE = "instrument_event_filter_OBJECTIVE";
    public static final String PERMS_FILTER_OBJECTIVE = "instrument_perms_filter_OBJECTIVE";
    public static final String OWNER_FILTER_LIGHTSOURCE = "instrument_owner_filter_LIGHTSOURCE";
    public static final String GROUP_FILTER_LIGHTSOURCE = "instrument_group_filter_LIGHTSOURCE";
    public static final String EVENT_FILTER_LIGHTSOURCE = "instrument_event_filter_LIGHTSOURCE";
    public static final String PERMS_FILTER_LIGHTSOURCE = "instrument_perms_filter_LIGHTSOURCE";
    public static final String OWNER_FILTER_FILTER = "instrument_owner_filter_FILTER";
    public static final String GROUP_FILTER_FILTER = "instrument_group_filter_FILTER";
    public static final String EVENT_FILTER_FILTER = "instrument_event_filter_FILTER";
    public static final String PERMS_FILTER_FILTER = "instrument_perms_filter_FILTER";
    private static final long serialVersionUID = 0xC00010C1L;
    public static final String ID = "Instrument_id";
    public static final String DETAILS = "Instrument_details";
    public static final String VERSION = "Instrument_version";
    public static final String MICROSCOPE = "Instrument_microscope";
    public static final String DETECTOR = "Instrument_detector";
    public static final String OBJECTIVE = "Instrument_objective";
    public static final String LIGHTSOURCE = "Instrument_lightSource";
    public static final String FILTER = "Instrument_filter";
    public static final Set FIELDS;
    protected Map _dynamicFields;
    protected boolean _loaded = true;
    private transient GraphHolder _graphHolder;

    public Instrument() {
    }

    public Instrument(Long id) {
        this.setId(id);
        this.getDetails().setContext(this);
    }

    public Instrument(Long id, boolean loaded) {
        this(id);
        if (!loaded) {
            this.unload();
        }
    }

    protected void preGetter(String field) {
        this.errorIfUnloaded();
    }

    protected void postGetter(String field) {
    }

    protected void preSetter(String field, Object value) {
        this.errorIfUnloaded();
    }

    protected void postSetter(String field, Object value) {
    }

    protected void throwNullCollectionException(String propertyName) {
        throw new ApiUsageException("Error updating collection:" + propertyName + "\n" + "Collection is currently null. This can be seen\n" + "by testing \"sizeOf" + propertyName + " < 0\". This implies\n" + "that this collection was unloaded. Please refresh this object\n" + "in order to update this collection.\n");
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Details getDetails() {
        try {
            this.preGetter(DETAILS);
            Details details = this.details;
            return details;
        }
        finally {
            this.postGetter(DETAILS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDetails(Details details) {
        try {
            this.preSetter(DETAILS, details);
            this.details = details;
        }
        finally {
            this.postSetter(DETAILS, details);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getVersion() {
        try {
            this.preGetter(VERSION);
            Integer n = this.version;
            return n;
        }
        finally {
            this.postGetter(VERSION);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVersion(Integer version) {
        try {
            this.preSetter(VERSION, version);
            this.version = version;
        }
        finally {
            this.postSetter(VERSION, version);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Microscope getMicroscope() {
        try {
            this.preGetter(MICROSCOPE);
            Microscope microscope = this.microscope;
            return microscope;
        }
        finally {
            this.postGetter(MICROSCOPE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMicroscope(Microscope microscope) {
        try {
            this.preSetter(MICROSCOPE, microscope);
            this.microscope = microscope;
        }
        finally {
            this.postSetter(MICROSCOPE, microscope);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set getDetector() {
        try {
            this.preGetter(DETECTOR);
            Set set = this.detector;
            return set;
        }
        finally {
            this.postGetter(DETECTOR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setDetector(Set detector) {
        try {
            this.preSetter(DETECTOR, detector);
            this.detector = detector;
        }
        finally {
            this.postSetter(DETECTOR, detector);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sizeOfDetector() {
        try {
            this.preGetter(DETECTOR);
            int n = this.detector == null ? -1 : this.detector.size();
            return n;
        }
        finally {
            this.postGetter(DETECTOR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iterateDetector() {
        try {
            this.preGetter(DETECTOR);
            if (this.getDetector() == null) {
                EmptyIterator emptyIterator = new EmptyIterator();
                return emptyIterator;
            }
            Iterator iterator = this.getDetector().iterator();
            return iterator;
        }
        finally {
            this.postGetter(DETECTOR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List collectDetector(CBlock block) {
        try {
            this.preGetter(DETECTOR);
            ArrayList result = new ArrayList();
            Iterator it = this.iterateDetector();
            while (it.hasNext()) {
                IObject obj = (IObject)it.next();
                if (block != null) {
                    result.add(block.call(obj));
                    continue;
                }
                result.add(obj);
            }
            ArrayList arrayList = result;
            return arrayList;
        }
        finally {
            this.postGetter(DETECTOR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDetector(Detector target) {
        try {
            this.preSetter(DETECTOR, target);
            if (this.getDetector() == null) {
                this.throwNullCollectionException("Detector");
            }
            this.getDetector().add(target);
            target.setInstrument(this);
        }
        finally {
            this.postSetter(DETECTOR, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDetectorSet(Set targets) {
        try {
            this.preSetter(DETECTOR, targets);
            if (this.getDetector() == null) {
                this.throwNullCollectionException("Detector");
            }
            this.getDetector().addAll(targets);
            for (Detector target : targets) {
                target.setInstrument(this);
            }
        }
        finally {
            this.postSetter(DETECTOR, targets);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDetector(Detector target) {
        try {
            this.preSetter(DETECTOR, target);
            if (this.getDetector() == null) {
                this.throwNullCollectionException("Detector");
            }
            this.getDetector().remove(target);
            target.setInstrument(null);
        }
        finally {
            this.postSetter(DETECTOR, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDetectorSet(Set targets) {
        try {
            this.preSetter(DETECTOR, targets);
            if (this.getDetector() == null) {
                this.throwNullCollectionException("Detector");
            }
            this.getDetector().removeAll(targets);
            for (Detector target : targets) {
                target.setInstrument(null);
            }
        }
        finally {
            this.postSetter(DETECTOR, targets);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearDetector() {
        try {
            this.preSetter(DETECTOR, null);
            if (this.getDetector() == null) {
                this.throwNullCollectionException("Detector");
            }
            this.getDetector().clear();
            Iterator it = this.iterateDetector();
            while (it.hasNext()) {
                Detector target = (Detector)it.next();
                target.setInstrument(null);
            }
        }
        finally {
            this.postSetter(DETECTOR, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set getObjective() {
        try {
            this.preGetter(OBJECTIVE);
            Set set = this.objective;
            return set;
        }
        finally {
            this.postGetter(OBJECTIVE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setObjective(Set objective) {
        try {
            this.preSetter(OBJECTIVE, objective);
            this.objective = objective;
        }
        finally {
            this.postSetter(OBJECTIVE, objective);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sizeOfObjective() {
        try {
            this.preGetter(OBJECTIVE);
            int n = this.objective == null ? -1 : this.objective.size();
            return n;
        }
        finally {
            this.postGetter(OBJECTIVE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iterateObjective() {
        try {
            this.preGetter(OBJECTIVE);
            if (this.getObjective() == null) {
                EmptyIterator emptyIterator = new EmptyIterator();
                return emptyIterator;
            }
            Iterator iterator = this.getObjective().iterator();
            return iterator;
        }
        finally {
            this.postGetter(OBJECTIVE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List collectObjective(CBlock block) {
        try {
            this.preGetter(OBJECTIVE);
            ArrayList result = new ArrayList();
            Iterator it = this.iterateObjective();
            while (it.hasNext()) {
                IObject obj = (IObject)it.next();
                if (block != null) {
                    result.add(block.call(obj));
                    continue;
                }
                result.add(obj);
            }
            ArrayList arrayList = result;
            return arrayList;
        }
        finally {
            this.postGetter(OBJECTIVE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObjective(Objective target) {
        try {
            this.preSetter(OBJECTIVE, target);
            if (this.getObjective() == null) {
                this.throwNullCollectionException("Objective");
            }
            this.getObjective().add(target);
            target.setInstrument(this);
        }
        finally {
            this.postSetter(OBJECTIVE, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObjectiveSet(Set targets) {
        try {
            this.preSetter(OBJECTIVE, targets);
            if (this.getObjective() == null) {
                this.throwNullCollectionException("Objective");
            }
            this.getObjective().addAll(targets);
            for (Objective target : targets) {
                target.setInstrument(this);
            }
        }
        finally {
            this.postSetter(OBJECTIVE, targets);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObjective(Objective target) {
        try {
            this.preSetter(OBJECTIVE, target);
            if (this.getObjective() == null) {
                this.throwNullCollectionException("Objective");
            }
            this.getObjective().remove(target);
            target.setInstrument(null);
        }
        finally {
            this.postSetter(OBJECTIVE, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObjectiveSet(Set targets) {
        try {
            this.preSetter(OBJECTIVE, targets);
            if (this.getObjective() == null) {
                this.throwNullCollectionException("Objective");
            }
            this.getObjective().removeAll(targets);
            for (Objective target : targets) {
                target.setInstrument(null);
            }
        }
        finally {
            this.postSetter(OBJECTIVE, targets);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearObjective() {
        try {
            this.preSetter(OBJECTIVE, null);
            if (this.getObjective() == null) {
                this.throwNullCollectionException("Objective");
            }
            this.getObjective().clear();
            Iterator it = this.iterateObjective();
            while (it.hasNext()) {
                Objective target = (Objective)it.next();
                target.setInstrument(null);
            }
        }
        finally {
            this.postSetter(OBJECTIVE, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set getLightSource() {
        try {
            this.preGetter(LIGHTSOURCE);
            Set set = this.lightSource;
            return set;
        }
        finally {
            this.postGetter(LIGHTSOURCE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setLightSource(Set lightSource) {
        try {
            this.preSetter(LIGHTSOURCE, lightSource);
            this.lightSource = lightSource;
        }
        finally {
            this.postSetter(LIGHTSOURCE, lightSource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sizeOfLightSource() {
        try {
            this.preGetter(LIGHTSOURCE);
            int n = this.lightSource == null ? -1 : this.lightSource.size();
            return n;
        }
        finally {
            this.postGetter(LIGHTSOURCE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iterateLightSource() {
        try {
            this.preGetter(LIGHTSOURCE);
            if (this.getLightSource() == null) {
                EmptyIterator emptyIterator = new EmptyIterator();
                return emptyIterator;
            }
            Iterator iterator = this.getLightSource().iterator();
            return iterator;
        }
        finally {
            this.postGetter(LIGHTSOURCE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List collectLightSource(CBlock block) {
        try {
            this.preGetter(LIGHTSOURCE);
            ArrayList result = new ArrayList();
            Iterator it = this.iterateLightSource();
            while (it.hasNext()) {
                IObject obj = (IObject)it.next();
                if (block != null) {
                    result.add(block.call(obj));
                    continue;
                }
                result.add(obj);
            }
            ArrayList arrayList = result;
            return arrayList;
        }
        finally {
            this.postGetter(LIGHTSOURCE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLightSource(LightSource target) {
        try {
            this.preSetter(LIGHTSOURCE, target);
            if (this.getLightSource() == null) {
                this.throwNullCollectionException("LightSource");
            }
            this.getLightSource().add(target);
            target.setInstrument(this);
        }
        finally {
            this.postSetter(LIGHTSOURCE, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLightSourceSet(Set targets) {
        try {
            this.preSetter(LIGHTSOURCE, targets);
            if (this.getLightSource() == null) {
                this.throwNullCollectionException("LightSource");
            }
            this.getLightSource().addAll(targets);
            for (LightSource target : targets) {
                target.setInstrument(this);
            }
        }
        finally {
            this.postSetter(LIGHTSOURCE, targets);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLightSource(LightSource target) {
        try {
            this.preSetter(LIGHTSOURCE, target);
            if (this.getLightSource() == null) {
                this.throwNullCollectionException("LightSource");
            }
            this.getLightSource().remove(target);
            target.setInstrument(null);
        }
        finally {
            this.postSetter(LIGHTSOURCE, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLightSourceSet(Set targets) {
        try {
            this.preSetter(LIGHTSOURCE, targets);
            if (this.getLightSource() == null) {
                this.throwNullCollectionException("LightSource");
            }
            this.getLightSource().removeAll(targets);
            for (LightSource target : targets) {
                target.setInstrument(null);
            }
        }
        finally {
            this.postSetter(LIGHTSOURCE, targets);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearLightSource() {
        try {
            this.preSetter(LIGHTSOURCE, null);
            if (this.getLightSource() == null) {
                this.throwNullCollectionException("LightSource");
            }
            this.getLightSource().clear();
            Iterator it = this.iterateLightSource();
            while (it.hasNext()) {
                LightSource target = (LightSource)it.next();
                target.setInstrument(null);
            }
        }
        finally {
            this.postSetter(LIGHTSOURCE, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set getFilter() {
        try {
            this.preGetter(FILTER);
            Set set = this.filter;
            return set;
        }
        finally {
            this.postGetter(FILTER);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setFilter(Set filter) {
        try {
            this.preSetter(FILTER, filter);
            this.filter = filter;
        }
        finally {
            this.postSetter(FILTER, filter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sizeOfFilter() {
        try {
            this.preGetter(FILTER);
            int n = this.filter == null ? -1 : this.filter.size();
            return n;
        }
        finally {
            this.postGetter(FILTER);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iterateFilter() {
        try {
            this.preGetter(FILTER);
            if (this.getFilter() == null) {
                EmptyIterator emptyIterator = new EmptyIterator();
                return emptyIterator;
            }
            Iterator iterator = this.getFilter().iterator();
            return iterator;
        }
        finally {
            this.postGetter(FILTER);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List collectFilter(CBlock block) {
        try {
            this.preGetter(FILTER);
            ArrayList result = new ArrayList();
            Iterator it = this.iterateFilter();
            while (it.hasNext()) {
                IObject obj = (IObject)it.next();
                if (block != null) {
                    result.add(block.call(obj));
                    continue;
                }
                result.add(obj);
            }
            ArrayList arrayList = result;
            return arrayList;
        }
        finally {
            this.postGetter(FILTER);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFilter(Filter target) {
        try {
            this.preSetter(FILTER, target);
            if (this.getFilter() == null) {
                this.throwNullCollectionException("Filter");
            }
            this.getFilter().add(target);
            target.setInstrument(this);
        }
        finally {
            this.postSetter(FILTER, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFilterSet(Set targets) {
        try {
            this.preSetter(FILTER, targets);
            if (this.getFilter() == null) {
                this.throwNullCollectionException("Filter");
            }
            this.getFilter().addAll(targets);
            for (Filter target : targets) {
                target.setInstrument(this);
            }
        }
        finally {
            this.postSetter(FILTER, targets);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFilter(Filter target) {
        try {
            this.preSetter(FILTER, target);
            if (this.getFilter() == null) {
                this.throwNullCollectionException("Filter");
            }
            this.getFilter().remove(target);
            target.setInstrument(null);
        }
        finally {
            this.postSetter(FILTER, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFilterSet(Set targets) {
        try {
            this.preSetter(FILTER, targets);
            if (this.getFilter() == null) {
                this.throwNullCollectionException("Filter");
            }
            this.getFilter().removeAll(targets);
            for (Filter target : targets) {
                target.setInstrument(null);
            }
        }
        finally {
            this.postSetter(FILTER, targets);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearFilter() {
        try {
            this.preSetter(FILTER, null);
            if (this.getFilter() == null) {
                this.throwNullCollectionException("Filter");
            }
            this.getFilter().clear();
            Iterator it = this.iterateFilter();
            while (it.hasNext()) {
                Filter target = (Filter)it.next();
                target.setInstrument(null);
            }
        }
        finally {
            this.postSetter(FILTER, null);
        }
    }

    public boolean isValid() {
        return Validator.validate(this).isValid();
    }

    public Validation validate() {
        return Validator.validate(this);
    }

    public Filterable newInstance() {
        return new Instrument();
    }

    public boolean acceptFilter(ome.util.Filter __filter) {
        this.id = (Long)__filter.filter(ID, this.id);
        this.details = (Details)__filter.filter(DETAILS, this.details);
        this.version = (Integer)__filter.filter(VERSION, this.version);
        this.microscope = (Microscope)__filter.filter(MICROSCOPE, this.microscope);
        this.detector = (Set)__filter.filter(DETECTOR, this.detector);
        this.objective = (Set)__filter.filter(OBJECTIVE, this.objective);
        this.lightSource = (Set)__filter.filter(LIGHTSOURCE, this.lightSource);
        this.filter = (Set)__filter.filter(FILTER, this.filter);
        return true;
    }

    public String toString() {
        return "Instrument" + (this.getId() == null ? ":Hash_" + this.hashCode() : ":Id_" + this.getId());
    }

    public Set fields() {
        return FIELDS;
    }

    public Object retrieve(String field) {
        if (field == null) {
            return null;
        }
        if (field.equals(ID)) {
            return this.getId();
        }
        if (field.equals(DETAILS)) {
            return this.getDetails();
        }
        if (field.equals(VERSION)) {
            return this.getVersion();
        }
        if (field.equals(MICROSCOPE)) {
            return this.getMicroscope();
        }
        if (field.equals(DETECTOR)) {
            return this.getDetector();
        }
        if (field.equals(OBJECTIVE)) {
            return this.getObjective();
        }
        if (field.equals(LIGHTSOURCE)) {
            return this.getLightSource();
        }
        if (field.equals(FILTER)) {
            return this.getFilter();
        }
        if (this._dynamicFields != null) {
            return this._dynamicFields.get(field);
        }
        return null;
    }

    public void putAt(String field, Object value) {
        if (field == null) {
            return;
        }
        if (field.equals(ID)) {
            this.setId((Long)value);
        } else if (field.equals(DETAILS)) {
            this.setDetails((Details)value);
        } else if (field.equals(VERSION)) {
            this.setVersion((Integer)value);
        } else if (field.equals(MICROSCOPE)) {
            this.setMicroscope((Microscope)value);
        } else if (field.equals(DETECTOR)) {
            this.setDetector((Set)value);
        } else if (field.equals(OBJECTIVE)) {
            this.setObjective((Set)value);
        } else if (field.equals(LIGHTSOURCE)) {
            this.setLightSource((Set)value);
        } else if (field.equals(FILTER)) {
            this.setFilter((Set)value);
        } else {
            if (this._dynamicFields == null) {
                this._dynamicFields = new HashMap();
            }
            this._dynamicFields.put(field, value);
        }
    }

    public boolean isLoaded() {
        return this._loaded;
    }

    public void unload() {
        this._loaded = false;
        this.details = null;
        this.version = null;
        this.microscope = null;
        this.detector = null;
        this.objective = null;
        this.lightSource = null;
        this.filter = null;
    }

    protected void errorIfUnloaded() {
        if (!this._loaded) {
            throw new IllegalStateException("Object unloaded:" + this);
        }
    }

    public final GraphHolder getGraphHolder() {
        if (this._graphHolder == null) {
            this._graphHolder = new GraphHolder();
        }
        return this._graphHolder;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
    }

    static {
        HashSet<String> raw = new HashSet<String>();
        raw.add(ID);
        raw.add(DETAILS);
        raw.add(VERSION);
        raw.add(MICROSCOPE);
        raw.add(DETECTOR);
        raw.add(OBJECTIVE);
        raw.add(LIGHTSOURCE);
        raw.add(FILTER);
        FIELDS = Collections.unmodifiableSet(raw);
    }
}

