/*
 * Decompiled with CFR 0.152.
 */
package ome.model.acquisition;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import ome.conditions.ApiUsageException;
import ome.model.IMutable;
import ome.model.IObject;
import ome.model.acquisition.Detector;
import ome.model.enums.Binning;
import ome.model.internal.Details;
import ome.model.internal.GraphHolder;
import ome.util.Filter;
import ome.util.Filterable;
import ome.util.Validation;
import ome.util.Validator;

public class DetectorSettings
implements IMutable,
IObject,
Serializable {
    private Long id;
    private Details details = new Details();
    private Integer version = new Integer(0);
    private Float voltage;
    private Float gain;
    private Float offsetValue;
    private Float readOutRate;
    private Binning binning;
    private Float amplification;
    private Detector detector;
    public static final String OWNER_FILTER = "detectorsettings_owner_filter";
    public static final String GROUP_FILTER = "detectorsettings_group_filter";
    public static final String EVENT_FILTER = "detectorsettings_event_filter";
    public static final String PERMS_FILTER = "detectorsettings_perms_filter";
    private static final long serialVersionUID = 0xC00010C1L;
    public static final String ID = "DetectorSettings_id";
    public static final String DETAILS = "DetectorSettings_details";
    public static final String VERSION = "DetectorSettings_version";
    public static final String VOLTAGE = "DetectorSettings_voltage";
    public static final String GAIN = "DetectorSettings_gain";
    public static final String OFFSETVALUE = "DetectorSettings_offsetValue";
    public static final String READOUTRATE = "DetectorSettings_readOutRate";
    public static final String BINNING = "DetectorSettings_binning";
    public static final String AMPLIFICATION = "DetectorSettings_amplification";
    public static final String DETECTOR = "DetectorSettings_detector";
    public static final Set FIELDS;
    protected Map _dynamicFields;
    protected boolean _loaded = true;
    private transient GraphHolder _graphHolder;

    public DetectorSettings() {
    }

    public DetectorSettings(Long id) {
        this.setId(id);
        this.getDetails().setContext(this);
    }

    public DetectorSettings(Long id, boolean loaded) {
        this(id);
        if (!loaded) {
            this.unload();
        }
    }

    protected void preGetter(String field) {
        this.errorIfUnloaded();
    }

    protected void postGetter(String field) {
    }

    protected void preSetter(String field, Object value) {
        this.errorIfUnloaded();
    }

    protected void postSetter(String field, Object value) {
    }

    protected void throwNullCollectionException(String propertyName) {
        throw new ApiUsageException("Error updating collection:" + propertyName + "\n" + "Collection is currently null. This can be seen\n" + "by testing \"sizeOf" + propertyName + " < 0\". This implies\n" + "that this collection was unloaded. Please refresh this object\n" + "in order to update this collection.\n");
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Details getDetails() {
        try {
            this.preGetter(DETAILS);
            Details details = this.details;
            return details;
        }
        finally {
            this.postGetter(DETAILS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDetails(Details details) {
        try {
            this.preSetter(DETAILS, details);
            this.details = details;
        }
        finally {
            this.postSetter(DETAILS, details);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getVersion() {
        try {
            this.preGetter(VERSION);
            Integer n = this.version;
            return n;
        }
        finally {
            this.postGetter(VERSION);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVersion(Integer version) {
        try {
            this.preSetter(VERSION, version);
            this.version = version;
        }
        finally {
            this.postSetter(VERSION, version);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Float getVoltage() {
        try {
            this.preGetter(VOLTAGE);
            Float f = this.voltage;
            return f;
        }
        finally {
            this.postGetter(VOLTAGE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVoltage(Float voltage) {
        try {
            this.preSetter(VOLTAGE, voltage);
            this.voltage = voltage;
        }
        finally {
            this.postSetter(VOLTAGE, voltage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Float getGain() {
        try {
            this.preGetter(GAIN);
            Float f = this.gain;
            return f;
        }
        finally {
            this.postGetter(GAIN);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGain(Float gain) {
        try {
            this.preSetter(GAIN, gain);
            this.gain = gain;
        }
        finally {
            this.postSetter(GAIN, gain);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Float getOffsetValue() {
        try {
            this.preGetter(OFFSETVALUE);
            Float f = this.offsetValue;
            return f;
        }
        finally {
            this.postGetter(OFFSETVALUE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOffsetValue(Float offsetValue) {
        try {
            this.preSetter(OFFSETVALUE, offsetValue);
            this.offsetValue = offsetValue;
        }
        finally {
            this.postSetter(OFFSETVALUE, offsetValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Float getReadOutRate() {
        try {
            this.preGetter(READOUTRATE);
            Float f = this.readOutRate;
            return f;
        }
        finally {
            this.postGetter(READOUTRATE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReadOutRate(Float readOutRate) {
        try {
            this.preSetter(READOUTRATE, readOutRate);
            this.readOutRate = readOutRate;
        }
        finally {
            this.postSetter(READOUTRATE, readOutRate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Binning getBinning() {
        try {
            this.preGetter(BINNING);
            Binning binning = this.binning;
            return binning;
        }
        finally {
            this.postGetter(BINNING);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBinning(Binning binning) {
        try {
            this.preSetter(BINNING, binning);
            this.binning = binning;
        }
        finally {
            this.postSetter(BINNING, binning);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Float getAmplification() {
        try {
            this.preGetter(AMPLIFICATION);
            Float f = this.amplification;
            return f;
        }
        finally {
            this.postGetter(AMPLIFICATION);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAmplification(Float amplification) {
        try {
            this.preSetter(AMPLIFICATION, amplification);
            this.amplification = amplification;
        }
        finally {
            this.postSetter(AMPLIFICATION, amplification);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Detector getDetector() {
        try {
            this.preGetter(DETECTOR);
            Detector detector = this.detector;
            return detector;
        }
        finally {
            this.postGetter(DETECTOR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDetector(Detector detector) {
        try {
            this.preSetter(DETECTOR, detector);
            this.detector = detector;
        }
        finally {
            this.postSetter(DETECTOR, detector);
        }
    }

    public boolean isValid() {
        return Validator.validate(this).isValid();
    }

    public Validation validate() {
        return Validator.validate(this);
    }

    public Filterable newInstance() {
        return new DetectorSettings();
    }

    public boolean acceptFilter(Filter __filter) {
        this.id = (Long)__filter.filter(ID, this.id);
        this.details = (Details)__filter.filter(DETAILS, this.details);
        this.version = (Integer)__filter.filter(VERSION, this.version);
        this.voltage = (Float)__filter.filter(VOLTAGE, this.voltage);
        this.gain = (Float)__filter.filter(GAIN, this.gain);
        this.offsetValue = (Float)__filter.filter(OFFSETVALUE, this.offsetValue);
        this.readOutRate = (Float)__filter.filter(READOUTRATE, this.readOutRate);
        this.binning = (Binning)__filter.filter(BINNING, this.binning);
        this.amplification = (Float)__filter.filter(AMPLIFICATION, this.amplification);
        this.detector = (Detector)__filter.filter(DETECTOR, this.detector);
        return true;
    }

    public String toString() {
        return "DetectorSettings" + (this.getId() == null ? ":Hash_" + this.hashCode() : ":Id_" + this.getId());
    }

    public Set fields() {
        return FIELDS;
    }

    public Object retrieve(String field) {
        if (field == null) {
            return null;
        }
        if (field.equals(ID)) {
            return this.getId();
        }
        if (field.equals(DETAILS)) {
            return this.getDetails();
        }
        if (field.equals(VERSION)) {
            return this.getVersion();
        }
        if (field.equals(VOLTAGE)) {
            return this.getVoltage();
        }
        if (field.equals(GAIN)) {
            return this.getGain();
        }
        if (field.equals(OFFSETVALUE)) {
            return this.getOffsetValue();
        }
        if (field.equals(READOUTRATE)) {
            return this.getReadOutRate();
        }
        if (field.equals(BINNING)) {
            return this.getBinning();
        }
        if (field.equals(AMPLIFICATION)) {
            return this.getAmplification();
        }
        if (field.equals(DETECTOR)) {
            return this.getDetector();
        }
        if (this._dynamicFields != null) {
            return this._dynamicFields.get(field);
        }
        return null;
    }

    public void putAt(String field, Object value) {
        if (field == null) {
            return;
        }
        if (field.equals(ID)) {
            this.setId((Long)value);
        } else if (field.equals(DETAILS)) {
            this.setDetails((Details)value);
        } else if (field.equals(VERSION)) {
            this.setVersion((Integer)value);
        } else if (field.equals(VOLTAGE)) {
            this.setVoltage((Float)value);
        } else if (field.equals(GAIN)) {
            this.setGain((Float)value);
        } else if (field.equals(OFFSETVALUE)) {
            this.setOffsetValue((Float)value);
        } else if (field.equals(READOUTRATE)) {
            this.setReadOutRate((Float)value);
        } else if (field.equals(BINNING)) {
            this.setBinning((Binning)value);
        } else if (field.equals(AMPLIFICATION)) {
            this.setAmplification((Float)value);
        } else if (field.equals(DETECTOR)) {
            this.setDetector((Detector)value);
        } else {
            if (this._dynamicFields == null) {
                this._dynamicFields = new HashMap();
            }
            this._dynamicFields.put(field, value);
        }
    }

    public boolean isLoaded() {
        return this._loaded;
    }

    public void unload() {
        this._loaded = false;
        this.details = null;
        this.version = null;
        this.voltage = null;
        this.gain = null;
        this.offsetValue = null;
        this.readOutRate = null;
        this.binning = null;
        this.amplification = null;
        this.detector = null;
    }

    protected void errorIfUnloaded() {
        if (!this._loaded) {
            throw new IllegalStateException("Object unloaded:" + this);
        }
    }

    public final GraphHolder getGraphHolder() {
        if (this._graphHolder == null) {
            this._graphHolder = new GraphHolder();
        }
        return this._graphHolder;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
    }

    static {
        HashSet<String> raw = new HashSet<String>();
        raw.add(ID);
        raw.add(DETAILS);
        raw.add(VERSION);
        raw.add(VOLTAGE);
        raw.add(GAIN);
        raw.add(OFFSETVALUE);
        raw.add(READOUTRATE);
        raw.add(BINNING);
        raw.add(AMPLIFICATION);
        raw.add(DETECTOR);
        FIELDS = Collections.unmodifiableSet(raw);
    }
}

