/*
 * Decompiled with CFR 0.152.
 */
package pojos;

import java.sql.Timestamp;
import java.util.HashSet;
import java.util.Set;
import ome.model.IObject;
import ome.model.annotations.ImageAnnotation;
import ome.model.containers.Category;
import ome.model.containers.Dataset;
import ome.model.core.Image;
import ome.model.core.Pixels;
import ome.util.CBlock;
import pojos.AnnotationData;
import pojos.CategoryData;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.PixelsData;
import pojos.SetMutator;

public class ImageData
extends DataObject {
    public static final String NAME = "Image_name";
    public static final String DESCRIPTION = "Image_description";
    public static final String PIXELS = "Image_pixels";
    public static final String ANNOTATIONS = "Image_annotations";
    public static final String DATASET_LINKS = "Image_datasetLinks";
    private PixelsData defaultPixels;
    private Set allPixels;
    private Set datasets;
    private Set categories;
    private Set annotations;
    private Long annotationCount;
    private Long classificationCount;

    public ImageData() {
        this.setDirty(true);
        this.setValue((IObject)new Image());
    }

    public ImageData(Image image) {
        if (image == null) {
            throw new IllegalArgumentException("Object cannot null.");
        }
        this.setValue((IObject)image);
    }

    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("The name cannot be null.");
        }
        this.setDirty(true);
        this.asImage().setName(name);
    }

    public String getName() {
        return this.asImage().getName();
    }

    public void setDescription(String description) {
        this.setDirty(true);
        this.asImage().setDescription(description);
    }

    public String getDescription() {
        return this.asImage().getDescription();
    }

    public Timestamp getCreated() {
        return this.timeOfEvent(this.asImage().getDetails().getCreationEvent());
    }

    public Timestamp getInserted() {
        return this.timeOfEvent(this.asImage().getDetails().getUpdateEvent());
    }

    public PixelsData getDefaultPixels() {
        if (this.defaultPixels == null && this.asImage().getDefaultPixels() != null) {
            this.defaultPixels = new PixelsData(this.asImage().getDefaultPixels());
        }
        return this.defaultPixels;
    }

    public void setDefaultPixels(PixelsData defaultPixels) {
        if (this.getDefaultPixels() == defaultPixels) {
            return;
        }
        this.setDirty(true);
        this.defaultPixels = defaultPixels;
        if (defaultPixels != null) {
            this.asImage().collectPixels(new CBlock(){

                public Object call(IObject object) {
                    ((Pixels)object).setDefaultPixels(Boolean.FALSE);
                    return null;
                }
            });
            defaultPixels.asPixels().setDefaultPixels(Boolean.TRUE);
        }
    }

    public Set getAllPixels() {
        if (this.allPixels == null && this.asImage().sizeOfPixels() >= 0) {
            this.allPixels = new HashSet(this.asImage().collectPixels(new CBlock(){

                public Object call(IObject object) {
                    return new PixelsData((Pixels)object);
                }
            }));
        }
        return this.allPixels == null ? null : new HashSet(this.allPixels);
    }

    public void setAllPixels(Set newValue) {
        Set currentValue = this.getAllPixels();
        SetMutator m = new SetMutator(currentValue, newValue);
        while (m.moreDeletions()) {
            this.setDirty(true);
            this.asImage().removePixels(m.nextDeletion().asPixels());
        }
        while (m.moreAdditions()) {
            this.setDirty(true);
            this.asImage().addPixels(m.nextAddition().asPixels());
        }
        this.allPixels = m.result();
    }

    public Set getDatasets() {
        if (this.datasets == null && this.asImage().sizeOfDatasetLinks() >= 0) {
            this.datasets = new HashSet(this.asImage().eachLinkedDataset(new CBlock(){

                public Object call(IObject object) {
                    return new DatasetData((Dataset)object);
                }
            }));
        }
        return this.datasets == null ? null : new HashSet(this.datasets);
    }

    public void setDatasets(Set newValue) {
        Set currentValue = this.getDatasets();
        SetMutator m = new SetMutator(currentValue, newValue);
        while (m.moreDeletions()) {
            this.setDirty(true);
            this.asImage().unlinkDataset(m.nextDeletion().asDataset());
        }
        while (m.moreAdditions()) {
            this.setDirty(true);
            this.asImage().linkDataset(m.nextAddition().asDataset());
        }
        this.datasets = m.result();
    }

    public Set getCategories() {
        if (this.categories == null && this.asImage().sizeOfCategoryLinks() >= 0) {
            this.categories = new HashSet(this.asImage().eachLinkedCategory(new CBlock(){

                public Object call(IObject object) {
                    return new CategoryData((Category)object);
                }
            }));
        }
        return this.categories == null ? null : new HashSet(this.categories);
    }

    public void setCategories(Set newValue) {
        Set currentValue = this.getCategories();
        SetMutator m = new SetMutator(currentValue, newValue);
        while (m.moreDeletions()) {
            this.setDirty(true);
            this.asImage().unlinkCategory(m.nextDeletion().asCategory());
            this.classificationCount = this.classificationCount == null ? null : new Long(this.classificationCount - 1L);
        }
        while (m.moreAdditions()) {
            this.setDirty(true);
            this.asImage().linkCategory(m.nextAddition().asCategory());
            this.classificationCount = this.classificationCount == null ? null : new Long(this.classificationCount + 1L);
        }
        this.categories = m.result();
    }

    public Set getAnnotations() {
        if (this.annotations == null && this.asImage().sizeOfAnnotations() >= 0) {
            this.annotations = new HashSet(this.asImage().collectAnnotations(new CBlock(){

                public Object call(IObject object) {
                    return new AnnotationData((ImageAnnotation)object);
                }
            }));
        }
        return this.annotations == null ? null : new HashSet(this.annotations);
    }

    public void setAnnotations(Set newValue) {
        Set currentValue = this.getAnnotations();
        SetMutator m = new SetMutator(currentValue, newValue);
        while (m.moreDeletions()) {
            this.setDirty(true);
            this.asImage().removeImageAnnotation(m.nextDeletion().asImageAnnotation());
            this.annotationCount = this.annotationCount == null ? null : new Long(this.annotationCount - 1L);
        }
        while (m.moreAdditions()) {
            this.setDirty(true);
            this.asImage().addImageAnnotation(m.nextAddition().asImageAnnotation());
            this.annotationCount = this.annotationCount == null ? null : new Long(this.annotationCount + 1L);
        }
        this.annotations = m.result();
    }

    public Long getAnnotationCount() {
        if (this.annotationCount == null) {
            this.annotationCount = this.getCount(ANNOTATIONS);
        }
        return this.annotationCount;
    }

    public Long getClassificationCount() {
        if (this.classificationCount == null) {
            this.classificationCount = this.getCount("Image_categoryLinks");
        }
        return this.classificationCount;
    }
}

