/*
 * Decompiled with CFR 0.152.
 */
package pojos;

import java.util.HashSet;
import java.util.Set;
import ome.model.IObject;
import ome.model.annotations.DatasetAnnotation;
import ome.model.containers.Dataset;
import ome.model.containers.Project;
import ome.model.core.Image;
import ome.util.CBlock;
import pojos.AnnotationData;
import pojos.DataObject;
import pojos.ImageData;
import pojos.ProjectData;
import pojos.SetMutator;

public class DatasetData
extends DataObject {
    public static final String NAME = "Dataset_name";
    public static final String DESCRIPTION = "Dataset_description";
    public static final String IMAGE_LINKS = "Dataset_imageLinks";
    public static final String PROJECT_LINKS = "Dataset_projectLinks";
    public static final String ANNOTATIONS = "Dataset_annotations";
    private Set images;
    private Set projects;
    private Set annotations;
    private Long annotationCount;

    public DatasetData() {
        this.setDirty(true);
        this.setValue((IObject)new Dataset());
    }

    public DatasetData(Dataset dataset) {
        if (dataset == null) {
            throw new IllegalArgumentException("Object cannot null.");
        }
        this.setValue((IObject)dataset);
    }

    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("The name cannot be null.");
        }
        this.setDirty(true);
        this.asDataset().setName(name);
    }

    public String getName() {
        return this.asDataset().getName();
    }

    public void setDescription(String description) {
        this.setDirty(true);
        this.asDataset().setDescription(description);
    }

    public String getDescription() {
        return this.asDataset().getDescription();
    }

    public Set getImages() {
        if (this.images == null && this.asDataset().sizeOfImageLinks() >= 0) {
            this.images = new HashSet(this.asDataset().eachLinkedImage(new CBlock(){

                public Object call(IObject object) {
                    return new ImageData((Image)object);
                }
            }));
        }
        return this.images == null ? null : new HashSet(this.images);
    }

    public Set getProjects() {
        if (this.projects == null && this.asDataset().sizeOfProjectLinks() >= 0) {
            this.projects = new HashSet(this.asDataset().eachLinkedProject(new CBlock(){

                public Object call(IObject object) {
                    return new ProjectData((Project)object);
                }
            }));
        }
        return this.projects == null ? null : new HashSet(this.projects);
    }

    public void setImages(Set newValue) {
        Set currentValue = this.getImages();
        SetMutator m = new SetMutator(currentValue, newValue);
        while (m.moreDeletions()) {
            this.setDirty(true);
            this.asDataset().unlinkImage(m.nextDeletion().asImage());
        }
        while (m.moreAdditions()) {
            this.setDirty(true);
            this.asDataset().linkImage(m.nextAddition().asImage());
        }
        this.images = m.result();
    }

    public void setProjects(Set newValue) {
        Set currentValue = this.getProjects();
        SetMutator m = new SetMutator(currentValue, newValue);
        while (m.moreDeletions()) {
            this.setDirty(true);
            this.asDataset().unlinkProject(m.nextDeletion().asProject());
        }
        while (m.moreAdditions()) {
            this.setDirty(true);
            this.asDataset().linkProject(m.nextAddition().asProject());
        }
        this.projects = m.result();
    }

    public Set getAnnotations() {
        if (this.annotations == null && this.asDataset().sizeOfAnnotations() >= 0) {
            this.annotations = new HashSet(this.asDataset().collectAnnotations(new CBlock(){

                public Object call(IObject object) {
                    return new AnnotationData((DatasetAnnotation)object);
                }
            }));
        }
        return this.annotations == null ? null : new HashSet(this.annotations);
    }

    public void setAnnotations(Set newValue) {
        Set currentValue = this.getAnnotations();
        SetMutator m = new SetMutator(currentValue, newValue);
        while (m.moreDeletions()) {
            this.setDirty(true);
            this.asDataset().removeDatasetAnnotation(m.nextDeletion().asDatasetAnnotation());
            this.annotationCount = this.annotationCount == null ? null : new Long(this.annotationCount - 1L);
        }
        while (m.moreAdditions()) {
            this.setDirty(true);
            this.asDataset().removeDatasetAnnotation(m.nextAddition().asDatasetAnnotation());
            this.annotationCount = this.annotationCount == null ? null : new Long(this.annotationCount + 1L);
        }
        this.annotations = m.result();
    }

    public Long getAnnotationCount() {
        if (this.annotationCount == null) {
            this.annotationCount = this.getCount(ANNOTATIONS);
        }
        return this.annotationCount;
    }
}

