/*
 * Decompiled with CFR 0.152.
 */
package pojos;

import java.sql.Timestamp;
import ome.model.IObject;
import ome.model.annotations.DatasetAnnotation;
import ome.model.annotations.ImageAnnotation;
import ome.model.containers.Dataset;
import ome.model.core.Image;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ImageData;

public class AnnotationData
extends DataObject {
    public static final int IMAGE_ANNOTATION = 0;
    public static final int DATASET_ANNOTATION = 1;
    public static final String IMAGE_ANNOTATION_CONTENT = "ImageAnnotation_content";
    public static final String IMAGE_ANNOTATION_IMAGE = "ImageAnnotation_image";
    public static final String DATASET_ANNOTATION_CONTENT = "DatasetAnnotation_content";
    public static final String DATASET_ANNOTATION_DATASET = "DatasetAnnotation_dataset";
    private DataObject annotatedObject;
    private int annotationType;

    public AnnotationData(int annotationType) {
        switch (annotationType) {
            case 0: {
                this.annotationType = annotationType;
                this.setValue((IObject)new ImageAnnotation());
                break;
            }
            case 1: {
                this.annotationType = annotationType;
                this.setValue((IObject)new DatasetAnnotation());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unkown annotation type: " + annotationType);
            }
        }
    }

    public AnnotationData(ImageAnnotation imageAnnotation) {
        if (imageAnnotation == null) {
            throw new IllegalArgumentException("Annotation cannot null.");
        }
        this.annotationType = 0;
        this.setValue((IObject)imageAnnotation);
    }

    public AnnotationData(DatasetAnnotation datasetAnnotation) {
        if (datasetAnnotation == null) {
            throw new IllegalArgumentException("Annotation cannot null.");
        }
        this.annotationType = 1;
        this.setValue((IObject)datasetAnnotation);
    }

    public void setText(String text) {
        switch (this.annotationType) {
            case 0: {
                this.asImageAnnotation().setContent(text);
                break;
            }
            case 1: {
                this.asDatasetAnnotation().setContent(text);
            }
        }
    }

    public String getText() {
        switch (this.annotationType) {
            case 0: {
                return this.asImageAnnotation().getContent();
            }
            case 1: {
                return this.asDatasetAnnotation().getContent();
            }
        }
        return null;
    }

    public Timestamp getLastModified() {
        if (this.nullDetails()) {
            return null;
        }
        return this.timeOfEvent(this.getDetails().getUpdateEvent());
    }

    public void setAnnotatedObject(DataObject annotatedObject) {
        if (annotatedObject == null) {
            throw new IllegalArgumentException("The annotated object cannotbe null.");
        }
        if (!(annotatedObject instanceof DatasetData) && !(annotatedObject instanceof DatasetData)) {
            throw new IllegalArgumentException("DataObject not valid.");
        }
        if (this.annotatedObject == annotatedObject) {
            return;
        }
        this.setDirty(true);
        this.annotatedObject = annotatedObject;
        switch (this.annotationType) {
            case 0: {
                this.asImageAnnotation().setImage(annotatedObject.asImage());
                break;
            }
            case 1: {
                this.asDatasetAnnotation().setDataset(annotatedObject.asDataset());
            }
        }
    }

    public DataObject getAnnotatedObject() {
        if (this.annotatedObject == null) {
            switch (this.annotationType) {
                case 0: {
                    Image i = this.asImageAnnotation().getImage();
                    this.annotatedObject = i == null ? null : new ImageData(i);
                    break;
                }
                case 1: {
                    Dataset d = this.asDatasetAnnotation().getDataset();
                    this.annotatedObject = d == null ? null : new DatasetData(d);
                }
            }
        }
        return this.annotatedObject;
    }
}

